/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import simpletree.distance.LightWeightDistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;

public class StressCurve {
    private static final int SPACE = 20;

    public BufferedImage generate(Dimension size, float alpha, AbstractMatrix projection, AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, size.width, size.height);
        LightWeightDistanceMatrix dmat = new LightWeightDistanceMatrix(matrix, diss);
        LightWeightDistanceMatrix dmatprj = new LightWeightDistanceMatrix(projection, new Euclidean());
        double maxrn = Double.NEGATIVE_INFINITY;
        double maxr2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                double valuern = dmat.getDistance(i, j);
                double valuer2 = dmatprj.getDistance(i, j);
                if (valuern > maxrn) {
                    maxrn = valuern;
                }
                if (!(valuer2 > maxr2)) continue;
                maxr2 = valuer2;
            }
        }
        int rgbcolor = Color.GRAY.getRGB();
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                double distrn = (double)dmat.getDistance(i, j) / maxrn;
                double distr2 = (double)dmatprj.getDistance(i, j) / maxr2;
                int x = 40 + (int)((double)(size.width - 60) * distrn);
                int y = 40 + (int)((double)(size.height - 60) * distr2);
                this.simulateAlpha(image, alpha, x, y, rgbcolor);
            }
        }
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(4.0f));
        g2.drawLine(10, 20, size.width - 20, 20);
        g2.drawLine(20, 10, 20, size.height - 20);
        g2.setStroke(new BasicStroke(3.0f));
        g2.setColor(Color.RED);
        g2.drawLine(10, 10, size.width - 20, size.height - 20);
        g2.setStroke(new BasicStroke(1.0f));
        BufferedImage refimage = new BufferedImage(size.height, size.width, 1);
        for (int i = 0; i < size.height; ++i) {
            for (int j = 0; j < size.width; ++j) {
                refimage.setRGB(j, i, image.getRGB(j, size.height - i - 1));
            }
        }
        return refimage;
    }

    private void simulateAlpha(BufferedImage image, float alpha, int x, int y, int rgb) {
        try {
            int oldrgb = image.getRGB(x, y);
            int oldr = oldrgb >> 16 & 0xFF;
            int oldg = oldrgb >> 8 & 0xFF;
            int oldb = oldrgb & 0xFF;
            int newr = (int)(alpha * (float)((rgb >> 16 & 0xFF) - oldr) + (float)oldr);
            int newg = (int)(alpha * (float)((rgb >> 8 & 0xFF) - oldg) + (float)oldg);
            int newb = (int)(alpha * (float)((rgb & 0xFF) - oldb) + (float)oldb);
            int newrgb = newb | newg << 8 | newr << 16;
            image.setRGB(x, y, newrgb);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.out.println(x + "," + y);
        }
    }

    public static void main(String[] args) throws IOException {
        String dir = "/home/paulovich/Dropbox/dados/";
        AbstractMatrix data = MatrixFactory.getInstance(dir + "segmentation-normcols.data-notnull.data");
        DenseMatrix proj = new DenseMatrix();
        ((AbstractMatrix)proj).load(dir + "segmentation-normcols.data-notnull.data-lamp.prj");
        StressCurve sc = new StressCurve();
        BufferedImage image = sc.generate(new Dimension(800, 800), 0.1f, proj, data, new Euclidean());
        ImageIO.write((RenderedImage)image, "png", new File("/home/paulovich/stress_pastel.png"));
    }
}

