/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.force;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public class InverseForceScheme {
    private float fractionDelta = 1.0f;
    private int[] index;
    private int nriterations = 100;
    private static final float EPSILON = 1.0E-7f;

    public AbstractMatrix execute(AbstractMatrix projection, AbstractMatrix matrix) throws IOException {
        DistanceMatrix dmatr2 = new DistanceMatrix(projection, new Euclidean());
        ArrayList<Integer> index_aux = new ArrayList<Integer>();
        for (int i = 0; i < dmatr2.getElementCount(); ++i) {
            index_aux.add(i);
        }
        this.index = new int[dmatr2.getElementCount()];
        int ind = 0;
        for (int j = 0; j < this.index.length; ++j) {
            if (ind >= index_aux.size()) {
                ind = 0;
            }
            this.index[j] = (Integer)index_aux.get(ind);
            index_aux.remove(ind);
            ind += index_aux.size() / 10;
        }
        float[][] aux_matrix = matrix.toMatrix();
        for (int i = 0; i < this.nriterations; ++i) {
            this.iteration(dmatr2, aux_matrix);
        }
        DenseMatrix newmatrix = new DenseMatrix();
        newmatrix.setAttributes(matrix.getAttributes());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            newmatrix.addRow(new DenseVector(aux_matrix[i], matrix.getRow(i).getId(), matrix.getRow(i).getKlass()), matrix.getLabel(i));
        }
        return newmatrix;
    }

    private void iteration(DistanceMatrix dmatr2, float[][] aux_matrix) {
        double error = 0.0;
        for (int ins1 = 0; ins1 < aux_matrix.length; ++ins1) {
            int instance1 = this.index[ins1];
            for (int ins2 = 0; ins2 < aux_matrix.length; ++ins2) {
                int instance2 = this.index[ins2];
                if (instance1 == instance2) continue;
                double[] diffvect = new double[aux_matrix[0].length];
                double drn = 0.0;
                for (int k = 0; k < diffvect.length; ++k) {
                    diffvect[k] = aux_matrix[instance2][k] - aux_matrix[instance1][k];
                    drn += diffvect[k] * diffvect[k];
                }
                if ((drn = Math.sqrt(drn)) < (double)1.0E-7f) {
                    drn = 1.0E-7f;
                }
                double dr2 = dmatr2.getDistance(instance1, instance2);
                double delta = dr2 - drn;
                error += Math.abs(delta);
                delta /= (double)this.fractionDelta;
                for (int k = 0; k < diffvect.length; ++k) {
                    float[] fArray = aux_matrix[instance2];
                    int n = k;
                    fArray[n] = (float)((double)fArray[n] + delta * (diffvect[k] / drn));
                }
            }
        }
        System.out.println("error: " + (error /= (double)(dmatr2.getElementCount() * dmatr2.getElementCount() - dmatr2.getElementCount())));
    }

    public static void main(String[] args) throws IOException {
        String matrixfile = "/home/paulovich/iris-std.data";
        String projfile = "/home/paulovich/iris-std.prj.data";
        AbstractMatrix matrix = MatrixFactory.getInstance(matrixfile);
        AbstractMatrix projection = MatrixFactory.getInstance(projfile);
        InverseForceScheme ifs = new InverseForceScheme();
        AbstractMatrix newmatrix = ifs.execute(projection, matrix);
        newmatrix.save(matrixfile + "_inv.data");
    }
}

