/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.idmap;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.projection.technique.Projection;
import simpletree.projection.technique.fastmap.FastmapProjection;
import simpletree.projection.technique.force.ForceSchemeProjection2D;
import simpletree.projection.technique.nnp.NearestNeighborProjection;

public class IDMAPProjection
implements Projection {
    private InitializationType ini = InitializationType.FASTMAP;
    private float fracdelta = 8.0f;
    private int nriterations = 50;

    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.project(dmat);
    }

    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        AbstractMatrix projection = null;
        if (this.ini == InitializationType.FASTMAP) {
            FastmapProjection fastmap = new FastmapProjection();
            projection = fastmap.project(dmat);
        } else if (this.ini == InitializationType.RANDOM) {
            int pivot1 = (int)((double)(dmat.getElementCount() - 1) * Math.random());
            int pivot2 = (int)((double)(dmat.getElementCount() - 1) * Math.random());
            projection = new DenseMatrix();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("x");
            attributes.add("y");
            projection.setAttributes(attributes);
            ArrayList<Integer> ids = dmat.getIds();
            ArrayList<String> labels = dmat.getLabels();
            float[] cdata = dmat.getClassData();
            for (int i = 0; i < dmat.getElementCount(); ++i) {
                float[] point = new float[]{dmat.getDistance(i, pivot1), dmat.getDistance(i, pivot2)};
                DenseVector vector = new DenseVector(point, ids.get(i), cdata[i]);
                if (labels.isEmpty()) {
                    projection.addRow(vector);
                    continue;
                }
                projection.addRow(vector, labels.get(i));
            }
        } else {
            NearestNeighborProjection nnp = new NearestNeighborProjection();
            projection = nnp.project(dmat);
        }
        ForceSchemeProjection2D force = new ForceSchemeProjection2D();
        force.setFractionDelta(this.fracdelta);
        force.setNumberIterations(this.nriterations);
        force.setProjection(projection);
        projection = force.project(dmat);
        return projection;
    }

    public InitializationType getInitialization() {
        return this.ini;
    }

    public void setInitialization(InitializationType ini) {
        this.ini = ini;
    }

    public float getFractionDelta() {
        return this.fracdelta;
    }

    public void setFractionDelta(float fracdelta) {
        this.fracdelta = fracdelta;
    }

    public int getNumberIterations() {
        return this.nriterations;
    }

    public void setNumberIterations(int nriterations) {
        this.nriterations = nriterations;
    }

    public static enum InitializationType {
        FASTMAP("Fastmap"),
        NNP("Nearest Neighbor Projection (NNP)"),
        RANDOM("Random");

        private final String name;

        private InitializationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

