/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.lsp;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import lspsolver.Solver;
import simpletree.datamining.clustering.BKmeans;
import simpletree.datamining.clustering.Kmedoids;
import simpletree.datamining.neighbors.ANN;
import simpletree.datamining.neighbors.KNN;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.Projection;
import simpletree.projection.technique.idmap.IDMAPProjection;
import simpletree.util.MeshGenerator;
import simpletree.util.ProjectionUtil;
import simpletree.view.ProjectionFrameComp;

public class LSPProjection2D
implements Projection {
    private AbstractMatrix cpprojection;
    private int[] controlpoints;
    private ControlPointsType type = ControlPointsType.RANDOM;
    private int nrcontrolpoints = 100;
    private int nrneighbors = 10;
    private float fracdelta = 8.0f;
    private int nriterations = 50;

    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        long start = System.currentTimeMillis();
        BKmeans bkmeans = new BKmeans(this.nrcontrolpoints);
        ArrayList<ArrayList<Integer>> clusters = bkmeans.execute(diss, matrix);
        AbstractMatrix centroids = bkmeans.getCentroids();
        if (this.controlpoints == null || this.cpprojection == null) {
            this.controlpoints = this.getControlPoints(bkmeans, clusters, matrix);
            AbstractMatrix matrix_cp = MatrixFactory.getInstance(matrix.getClass());
            for (int i = 0; i < this.controlpoints.length; ++i) {
                matrix_cp.addRow(matrix.getRow(this.controlpoints[i]));
            }
            DistanceMatrix dmat_cp = new DistanceMatrix(matrix_cp, diss);
            this.cpprojection = this.projectControlPoints(dmat_cp);
        }
        this.nrcontrolpoints = this.controlpoints.length;
        ANN appknn = new ANN(this.nrneighbors);
        Pair[][] mesh = appknn.execute(matrix, diss, clusters, centroids);
        MeshGenerator meshgen = new MeshGenerator();
        mesh = meshgen.execute(mesh, matrix, diss);
        AbstractMatrix projection = this.createFinalProjection(mesh, matrix);
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Least Square Projection (LSP) time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
        return projection;
    }

    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        if (this.type == ControlPointsType.KMEDOIDS) {
            Kmedoids kmedois = new Kmedoids(this.nrcontrolpoints);
            kmedois.execute(dmat);
            this.controlpoints = kmedois.getMedoids();
        } else if (this.type == ControlPointsType.RANDOM) {
            this.controlpoints = new int[this.nrcontrolpoints];
            for (int i = 0; i < this.controlpoints.length; ++i) {
                this.controlpoints[i] = (int)(Math.random() * (double)dmat.getElementCount());
            }
        }
        DistanceMatrix dmat_cp = new DistanceMatrix(this.nrcontrolpoints);
        for (int i = 0; i < this.nrcontrolpoints; ++i) {
            for (int j = 0; j < this.nrcontrolpoints; ++j) {
                if (i == j) continue;
                dmat_cp.setDistance(i, j, dmat.getDistance(this.controlpoints[i], this.controlpoints[j]));
            }
        }
        this.cpprojection = this.projectControlPoints(dmat_cp);
        KNN knnmesh = new KNN(this.nrneighbors);
        Pair[][] mesh = knnmesh.execute(dmat);
        MeshGenerator meshgen = new MeshGenerator();
        mesh = meshgen.execute(mesh, dmat);
        return this.createFinalProjection(mesh, dmat);
    }

    public void setControlPoints(ArrayList<Integer> controlpoints) {
        this.controlpoints = new int[controlpoints.size()];
        for (int i = 0; i < controlpoints.size(); ++i) {
            this.controlpoints[i] = controlpoints.get(i);
        }
    }

    public void setControlPointsProjection(AbstractMatrix cpprojection) {
        this.cpprojection = cpprojection;
    }

    public ControlPointsType getControlPointsChoice() {
        return this.type;
    }

    public void setControlPointsChoice(ControlPointsType type) {
        this.type = type;
    }

    public int getNumberControlPoints() {
        return this.nrcontrolpoints;
    }

    public void setNumberControlPoints(int nrcontrolpoints) {
        this.nrcontrolpoints = nrcontrolpoints;
    }

    public int getNumberNeighbors() {
        return this.nrneighbors;
    }

    public void setNumberNeighbors(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    public float getFractionDelta() {
        return this.fracdelta;
    }

    public void setFractionDelta(float fracdelta) {
        this.fracdelta = fracdelta;
    }

    public int getNumberIterations() {
        return this.nriterations;
    }

    public void setNumberIterations(int nriterations) {
        this.nriterations = nriterations;
    }

    protected AbstractMatrix projectControlPoints(DistanceMatrix dmat_cp) throws IOException {
        IDMAPProjection idmap = new IDMAPProjection();
        idmap.setFractionDelta(this.fracdelta);
        idmap.setNumberIterations(this.nriterations);
        this.cpprojection = idmap.project(dmat_cp);
        return this.cpprojection;
    }

    private AbstractMatrix createFinalProjection(Pair[][] neighbors, AbstractMatrix matrix) throws IOException {
        DenseMatrix projection = new DenseMatrix();
        ArrayList<Integer> ids = matrix.getIds();
        float[] cdata = matrix.getClassData();
        ArrayList<String> labels = matrix.getLabels();
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            DenseVector vector = new DenseVector(new float[]{0.0f, 0.0f}, ids.get(i), cdata[i]);
            if (labels.isEmpty()) {
                ((AbstractMatrix)projection).addRow(vector);
                continue;
            }
            projection.addRow(vector, labels.get(i));
        }
        this.projectUsingColt(neighbors, projection);
        Runtime.getRuntime().gc();
        return projection;
    }

    private AbstractMatrix createFinalProjection(Pair[][] neighbors, DistanceMatrix dmat) {
        DenseMatrix projection = new DenseMatrix();
        ArrayList<Integer> ids = dmat.getIds();
        float[] classData = dmat.getClassData();
        ArrayList<String> labels = dmat.getLabels();
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            if (labels.isEmpty()) {
                ((AbstractMatrix)projection).addRow(new DenseVector(new float[]{0.0f, 0.0f}, ids.get(i), classData[i]));
                continue;
            }
            projection.addRow(new DenseVector(new float[]{0.0f, 0.0f}, ids.get(i), classData[i]), labels.get(i));
        }
        this.projectUsingColt(neighbors, projection);
        Runtime.getRuntime().gc();
        return projection;
    }

    private void projectUsingColt(Pair[][] neighbors, AbstractMatrix projection) {
        int i;
        long start = System.currentTimeMillis();
        int nRows = neighbors.length + this.nrcontrolpoints;
        int nColumns = neighbors.length;
        SparseDoubleMatrix2D A = new SparseDoubleMatrix2D(nRows, nColumns);
        for (i = 0; i < neighbors.length; ++i) {
            float dist;
            int j;
            A.setQuick(i, i, 1.0);
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (int j2 = 0; j2 < neighbors[i].length; ++j2) {
                if (max < neighbors[i][j2].value) {
                    max = neighbors[i][j2].value;
                }
                if (!(min > neighbors[i][j2].value)) continue;
                min = neighbors[i][j2].value;
            }
            float sum = 0.0f;
            for (j = 0; j < neighbors[i].length; ++j) {
                if (!(max > min)) continue;
                dist = (neighbors[i][j].value - min) / (max - min) * 0.9f + 0.1f;
                sum += 1.0f / dist;
            }
            for (j = 0; j < neighbors[i].length; ++j) {
                if (max > min) {
                    dist = (neighbors[i][j].value - min) / (max - min) * 0.9f + 0.1f;
                    A.setQuick(i, neighbors[i][j].index, (double)(-(1.0f / dist / sum)));
                    continue;
                }
                A.setQuick(i, neighbors[i][j].index, (double)(-(1.0f / (float)neighbors[i].length)));
            }
        }
        for (i = 0; i < this.nrcontrolpoints; ++i) {
            A.setQuick(projection.getRowCount() + i, this.controlpoints[i], 1.0);
        }
        SparseDoubleMatrix2D B = new SparseDoubleMatrix2D(nRows, 2);
        for (int i2 = 0; i2 < this.cpprojection.getRowCount(); ++i2) {
            B.setQuick(neighbors.length + i2, 0, (double)this.cpprojection.getRow(i2).getValue(0));
            B.setQuick(neighbors.length + i2, 1, (double)this.cpprojection.getRow(i2).getValue(1));
        }
        DoubleMatrix2D AtA = A.zMult((DoubleMatrix2D)A, null, 1.0, 1.0, true, false);
        DoubleMatrix2D AtB = A.zMult((DoubleMatrix2D)B, null, 1.0, 1.0, true, false);
        start = System.currentTimeMillis();
        CholeskyDecomposition chol = new CholeskyDecomposition(AtA);
        DoubleMatrix2D X = chol.solve(AtB);
        for (int i3 = 0; i3 < X.rows(); ++i3) {
            AbstractVector row = projection.getRow(i3);
            row.setValue(0, (float)X.getQuick(i3, 0));
            row.setValue(1, (float)X.getQuick(i3, 1));
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Solving the system using Colt time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
    }

    private void projectUsingProgram(Pair[][] neighbors, AbstractMatrix projection) {
        long start = System.currentTimeMillis();
        int nRows = neighbors.length + this.nrcontrolpoints;
        int nColumns = neighbors.length;
        Solver solver = new Solver(nRows, nColumns);
        try {
            int i;
            for (i = 0; i < neighbors.length; ++i) {
                float dist;
                int j;
                solver.addToA(i, i, 1.0f);
                float max = Float.NEGATIVE_INFINITY;
                float min = Float.POSITIVE_INFINITY;
                for (int j2 = 0; j2 < neighbors[i].length; ++j2) {
                    if (max < neighbors[i][j2].value) {
                        max = neighbors[i][j2].value;
                    }
                    if (!(min > neighbors[i][j2].value)) continue;
                    min = neighbors[i][j2].value;
                }
                float sum = 0.0f;
                for (j = 0; j < neighbors[i].length; ++j) {
                    if (!(max > min)) continue;
                    dist = (neighbors[i][j].value - min) / (max - min) * 0.9f + 0.1f;
                    sum += 1.0f / dist;
                }
                for (j = 0; j < neighbors[i].length; ++j) {
                    if (max > min) {
                        dist = (neighbors[i][j].value - min) / (max - min) * 0.9f + 0.1f;
                        solver.addToA(i, neighbors[i][j].index, -(1.0f / dist / sum));
                        continue;
                    }
                    solver.addToA(i, neighbors[i][j].index, -(1.0f / (float)neighbors[i].length));
                }
            }
            for (i = 0; i < this.nrcontrolpoints; ++i) {
                solver.addToA(projection.getRowCount() + i, this.controlpoints[i], 1.0f);
            }
            for (i = 0; i < this.cpprojection.getRowCount(); ++i) {
                solver.addToB(neighbors.length + i, 0, this.cpprojection.getRow(i).getValue(0));
                solver.addToB(neighbors.length + i, 1, this.cpprojection.getRow(i).getValue(1));
            }
            float[] result = solver.solve();
            for (int i2 = 0; i2 < result.length; i2 += 2) {
                AbstractVector row = projection.getRow(i2 / 2);
                row.setValue(0, result[i2]);
                row.setValue(1, result[i2 + 1]);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LSPProjection2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Solving the system using LSPSolver time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
    }

    private int[] getControlPoints(BKmeans bkmeans, ArrayList<ArrayList<Integer>> clusters, AbstractMatrix matrix) throws IOException {
        int[] localcp;
        block7: {
            block6: {
                int i;
                localcp = null;
                if (this.type != ControlPointsType.KMEANS) break block6;
                localcp = bkmeans.getMedoids(matrix);
                ArrayList<Integer> medoids_aux = new ArrayList<Integer>();
                for (i = 0; i < localcp.length; ++i) {
                    medoids_aux.add(localcp[i]);
                }
                while (medoids_aux.size() < this.nrcontrolpoints) {
                    block2: for (int c = 0; c < clusters.size() && medoids_aux.size() < this.nrcontrolpoints; ++c) {
                        if (clusters.get(c).size() <= matrix.getRowCount() / this.nrcontrolpoints) continue;
                        for (int i2 = 0; i2 < clusters.get(c).size(); ++i2) {
                            if (medoids_aux.contains(clusters.get(c).get(i2))) continue;
                            medoids_aux.add(clusters.get(c).get(i2));
                            continue block2;
                        }
                    }
                }
                localcp = new int[medoids_aux.size()];
                for (i = 0; i < localcp.length; ++i) {
                    localcp[i] = (Integer)medoids_aux.get(i);
                }
                break block7;
            }
            if (this.type != ControlPointsType.RANDOM) break block7;
            localcp = new int[this.nrcontrolpoints];
            for (int i = 0; i < localcp.length; ++i) {
                localcp[i] = (int)(Math.random() * (double)matrix.getRowCount());
            }
        }
        return localcp;
    }

    public static void main(String[] args) throws IOException {
        String filename = "/home/paulovich/Dropbox/dados/swissroll10000.data";
        AbstractMatrix matrix = MatrixFactory.getInstance(filename);
        ProjectionUtil.log(false, false);
        long start = System.currentTimeMillis();
        LSPProjection2D lsp = new LSPProjection2D();
        lsp.setNumberNeighbors(8);
        lsp.setControlPointsChoice(ControlPointsType.RANDOM);
        lsp.setFractionDelta(8.0f);
        lsp.setNumberIterations(50);
        lsp.setNumberControlPoints(matrix.getRowCount() / 10);
        AbstractMatrix projection = lsp.project(matrix, new Euclidean());
        long finish = System.currentTimeMillis();
        System.out.println("LSP time: " + (float)(finish - start) / 1000.0f + "s");
        ProjectionModelComp model = new ProjectionModelComp();
        model.input(projection);
        model.execute();
        ProjectionFrameComp frame = new ProjectionFrameComp();
        frame.input(model.output());
        frame.setTitle("LSP");
        frame.execute();
    }

    public static enum ControlPointsType {
        RANDOM("Random"),
        KMEDOIDS("K-medoids"),
        KMEANS("K-means");

        private final String name;

        private ControlPointsType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

