/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.lsp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.projection.technique.lsp.LSPProjection2DComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class LSPProjection2DParamView
extends AbstractParametersView {
    private LSPProjection2DComp comp;
    private JLabel deltaLabel;
    private JTextField deltaTextField;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JPanel improvementPanel;
    private JPanel lspPanel;
    private JLabel nIterationsLabel;
    private JTextField nIterationsTextField;
    private JLabel numberCPLabel;
    private JTextField numberCPTextField;
    private JLabel numberNeighborsLabel;
    private JTextField numberNeighborsTextField;

    public LSPProjection2DParamView(LSPProjection2DComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.reset();
    }

    private void initComponents() {
        this.improvementPanel = new JPanel();
        this.nIterationsLabel = new JLabel();
        this.deltaLabel = new JLabel();
        this.deltaTextField = new JTextField();
        this.nIterationsTextField = new JTextField();
        this.lspPanel = new JPanel();
        this.numberCPLabel = new JLabel();
        this.numberNeighborsLabel = new JLabel();
        this.numberCPTextField = new JTextField();
        this.numberNeighborsTextField = new JTextField();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("LSP Parameters"));
        this.setLayout(new GridBagLayout());
        this.improvementPanel.setBorder(BorderFactory.createTitledBorder("Projection Improvement (Force)"));
        this.improvementPanel.setLayout(new GridBagLayout());
        this.nIterationsLabel.setText("Number of iterations");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsLabel, gridBagConstraints);
        this.deltaLabel.setText("Fraction of delta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaLabel, gridBagConstraints);
        this.deltaTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.deltaTextField, gridBagConstraints);
        this.nIterationsTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.improvementPanel, gridBagConstraints);
        this.lspPanel.setBorder(BorderFactory.createTitledBorder("LSP parameters"));
        this.lspPanel.setLayout(new GridBagLayout());
        this.numberCPLabel.setText("Number Control Points");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberCPLabel, gridBagConstraints);
        this.numberNeighborsLabel.setText("Number of Neighbors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberNeighborsLabel, gridBagConstraints);
        this.numberCPTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberCPTextField, gridBagConstraints);
        this.numberNeighborsTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.lspPanel.add((Component)this.numberNeighborsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.lspPanel, gridBagConstraints);
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
    }

    public void reset() {
        this.deltaTextField.setText(Float.toString(this.comp.getFractionDelta()));
        this.nIterationsTextField.setText(Integer.toString(this.comp.getNumberIterations()));
        int nrinstances = this.comp.getNumberInstances();
        this.comp.setNumberControlPoints(Math.max(nrinstances / 10, this.comp.getNumberControlPoints()));
        int nrneighbors = 0;
        nrneighbors = this.comp.getNumberInstances() < 1500 ? 10 : (this.comp.getNumberInstances() < 5000 ? 15 : 20);
        this.comp.setNumberNeighbors(Math.max(nrneighbors, this.comp.getNumberNeighbors()));
        this.numberCPTextField.setText(Integer.toString(this.comp.getNumberControlPoints()));
        this.numberNeighborsTextField.setText(Integer.toString(this.comp.getNumberNeighbors()));
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
    }

    public void finished() throws IOException {
        int nnei;
        int ncp;
        int nit;
        float delta;
        if (this.deltaTextField.getText().trim().length() > 0) {
            delta = Float.parseFloat(this.deltaTextField.getText());
            if (!(delta > 0.0f)) {
                throw new IOException("The fraction of delta should be positive.");
            }
        } else {
            throw new IOException("The fraction of delta should be provided.");
        }
        this.comp.setFractionDelta(delta);
        if (this.nIterationsTextField.getText().trim().length() > 0) {
            nit = Integer.parseInt(this.nIterationsTextField.getText());
            if (nit <= -1) {
                throw new IOException("The number of iterations should be positive.");
            }
        } else {
            throw new IOException("The number of iterations should be provided.");
        }
        this.comp.setNumberIterations(nit);
        if (this.numberCPTextField.getText().trim().length() > 0) {
            ncp = Integer.parseInt(this.numberCPTextField.getText());
            if (ncp <= 0) {
                throw new IOException("The number of control points should be positive.");
            }
        } else {
            throw new IOException("The number of control points should be provided.");
        }
        this.comp.setNumberControlPoints(ncp);
        if (this.numberNeighborsTextField.getText().trim().length() > 0) {
            nnei = Integer.parseInt(this.numberNeighborsTextField.getText());
            if (nnei <= 0) {
                throw new IOException("The number of neighbors should be positive.");
            }
        } else {
            throw new IOException("The number of neighbors should be provided.");
        }
        this.comp.setNumberNeighbors(nnei);
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
    }
}

