/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.mds;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.projection.technique.mds.ClassicalMDSProjectionComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class ClassicalMDSProjectionParamView
extends AbstractParametersView {
    private ClassicalMDSProjectionComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;

    public ClassicalMDSProjectionParamView(ClassicalMDSProjectionComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.reset();
    }

    private void initComponents() {
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Classical Scaling Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.add(this.dissimilarityPanel, gridBagConstraints);
    }

    public void reset() {
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
    }

    public void finished() throws IOException {
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
    }
}

