/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.fill;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import simpletree.basics.color.ColorTable;
import simpletree.projectioncloud.fill.MilkPaintsScale;
import simpletree.projectioncloud.topic.Term;
import simpletree.projectioncloud.util.Util;

public class TermRectangle
extends Rectangle {
    private static final ColorTable ct = new ColorTable();
    private int inset;
    private float scale = 1.0f;
    public Font font;
    public Term term;
    public Direction direction = Direction.HORIZONTAL;

    public TermRectangle(int width, int height) {
        super(width, height);
    }

    public TermRectangle(Term term, Font font) {
        this.term = term;
        this.setFont(font);
    }

    public void draw(Graphics2D g2) {
        if (this.isFeasible()) {
            g2.setFont(this.font);
            g2.setColor(ct.getColor(this.term.weight));
            if (this.direction == Direction.VERTICAL) {
                AffineTransform at = new AffineTransform();
                at.translate(this.x + this.width, this.y + this.height);
                at.rotate(Math.toRadians(-90.0));
                at.scale(this.scale, this.scale);
                at.translate(-(this.x + this.width), -(this.y + this.height));
                g2.setTransform(at);
                g2.drawString(this.term.term, this.x + this.width + this.inset, this.y + this.height - this.inset);
            } else {
                AffineTransform at = new AffineTransform();
                at.translate(this.x, this.y + this.height);
                at.scale(this.scale, this.scale);
                at.translate(-this.x, -(this.y + this.height));
                g2.setTransform(at);
                g2.drawString(this.term.term, this.x + this.inset, this.y + this.height - this.inset);
            }
            g2.setTransform(new AffineTransform());
        }
    }

    public void scale(float scale) {
        this.scale *= scale;
        this.width = (int)((float)this.width * scale);
        this.height = (int)((float)this.height * scale);
    }

    public void rotate() {
        int tmp = this.height;
        this.height = this.width;
        this.width = tmp;
        this.direction = this.direction == Direction.HORIZONTAL ? Direction.VERTICAL : Direction.HORIZONTAL;
    }

    public final void setFont(Font font) {
        this.font = font;
        Dimension dimension = Util.getSizeExact(this.term.term, font);
        this.inset = (int)Math.max(3.0f, Math.min((float)dimension.height * 0.1f, 4.0f));
        this.setSize(dimension.width + this.inset * 2, dimension.height + this.inset * 2);
    }

    public boolean isFeasible() {
        return this.width > 2 * this.inset && this.height > 2 * this.inset;
    }

    static {
        ct.setColorScale(new MilkPaintsScale());
        ct.getColorScale().setReverse(true);
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

