/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.projection;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import simpletree.matrix.AbstractMatrix;

public class MarchingSquare {
    private float maxx;
    private float maxy;
    private float minx;
    private float miny;
    private int grid_width;
    private int grid_height;
    private Cell[][] cells;

    public MarchingSquare(AbstractMatrix projection, int grid_width, int grid_height) {
        this.grid_width = grid_width;
        this.grid_height = grid_height;
        this.init(projection);
        this.cells_geometry(grid_width, grid_height);
        this.cells_density(this.cells, projection);
    }

    public void composeGroups(ArrayList<Line2D.Float> lines) {
        ArrayList groups = new ArrayList();
        if (lines.size() > 0) {
            ArrayList<Line2D.Float> lines_aux = new ArrayList<Line2D.Float>(lines);
            Point2D begin = null;
            boolean newgroup = true;
            block0: while (lines_aux.size() > 0) {
                if (newgroup) {
                    groups.add(new ArrayList());
                    begin = lines_aux.remove(0).getP1();
                }
                newgroup = true;
                for (int i = 0; i < lines_aux.size(); ++i) {
                    Line2D.Float line;
                    Point2D p1 = lines_aux.get(i).getP1();
                    Point2D p2 = lines_aux.get(i).getP2();
                    if (Math.abs(begin.getX() - p1.getX()) < (double)0.001f && Math.abs(begin.getY() - p1.getY()) < (double)0.001f) {
                        line = lines_aux.remove(i);
                        ((ArrayList)groups.get(groups.size() - 1)).add(line);
                        begin = line.getP2();
                        newgroup = false;
                        continue block0;
                    }
                    if (!(Math.abs(begin.getX() - p2.getX()) < (double)0.001f) || !(Math.abs(begin.getY() - p2.getY()) < (double)0.001f)) continue;
                    line = lines_aux.remove(i);
                    ((ArrayList)groups.get(groups.size() - 1)).add(line);
                    begin = line.getP1();
                    newgroup = false;
                    continue block0;
                }
            }
        }
        System.out.println("Groups: " + groups.size());
    }

    public ArrayList<Line2D.Float> execute(float isovalue) {
        ArrayList<Line2D.Float> segments = new ArrayList<Line2D.Float>();
        for (int i = 0; i < this.cells.length - 1; ++i) {
            block11: for (int j = 0; j < this.cells[i].length - 1; ++j) {
                int code = 0;
                code = this.cells[i][j].value >= isovalue ? 1 : 0;
                code |= this.cells[i][j + 1].value >= isovalue ? 2 : 0;
                code |= this.cells[i + 1][j + 1].value >= isovalue ? 4 : 0;
                switch (code |= this.cells[i + 1][j].value >= isovalue ? 8 : 0) {
                    case 0: 
                    case 15: {
                        continue block11;
                    }
                    case 1: 
                    case 14: {
                        float x1 = this.cells[i][j].pos.x;
                        float y1 = (this.cells[i][j].pos.y + this.cells[i + 1][j].pos.y) / 2.0f;
                        float x2 = (this.cells[i][j].pos.x + this.cells[i][j + 1].pos.x) / 2.0f;
                        float y2 = this.cells[i][j].pos.y;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                        continue block11;
                    }
                    case 2: 
                    case 13: {
                        float x1 = (this.cells[i][j].pos.x + this.cells[i][j + 1].pos.x) / 2.0f;
                        float y1 = this.cells[i][j].pos.y;
                        float x2 = this.cells[i][j + 1].pos.x;
                        float y2 = (this.cells[i][j + 1].pos.y + this.cells[i + 1][j + 1].pos.y) / 2.0f;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                        continue block11;
                    }
                    case 3: 
                    case 12: {
                        float x1 = this.cells[i][j].pos.x;
                        float y1 = (this.cells[i][j].pos.y + this.cells[i + 1][j].pos.y) / 2.0f;
                        float x2 = this.cells[i][j + 1].pos.x;
                        float y2 = (this.cells[i][j + 1].pos.y + this.cells[i + 1][j + 1].pos.y) / 2.0f;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                        continue block11;
                    }
                    case 4: 
                    case 11: {
                        float x1 = (this.cells[i + 1][j].pos.x + this.cells[i + 1][j + 1].pos.x) / 2.0f;
                        float y1 = this.cells[i + 1][j].pos.y;
                        float x2 = this.cells[i][j + 1].pos.x;
                        float y2 = (this.cells[i][j + 1].pos.y + this.cells[i + 1][j + 1].pos.y) / 2.0f;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                        continue block11;
                    }
                    case 5: 
                    case 10: {
                        float x1 = this.cells[i][j].pos.x;
                        float y1 = (this.cells[i][j].pos.y + this.cells[i + 1][j].pos.y) / 2.0f;
                        float x2 = (this.cells[i + 1][j].pos.x + this.cells[i + 1][j + 1].pos.x) / 2.0f;
                        float y2 = this.cells[i + 1][j].pos.y;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                        x1 = (this.cells[i][j].pos.x + this.cells[i][j + 1].pos.x) / 2.0f;
                        y1 = this.cells[i][j].pos.y;
                        x2 = this.cells[i][j + 1].pos.x;
                        y2 = (this.cells[i][j + 1].pos.y + this.cells[i + 1][j + 1].pos.y) / 2.0f;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                        continue block11;
                    }
                    case 6: 
                    case 9: {
                        float x1 = (this.cells[i][j].pos.x + this.cells[i][j + 1].pos.x) / 2.0f;
                        float y1 = this.cells[i][j].pos.y;
                        float x2 = (this.cells[i + 1][j].pos.x + this.cells[i + 1][j + 1].pos.x) / 2.0f;
                        float y2 = this.cells[i + 1][j].pos.y;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                        continue block11;
                    }
                    case 7: 
                    case 8: {
                        float x1 = this.cells[i][j].pos.x;
                        float y1 = (this.cells[i][j].pos.y + this.cells[i + 1][j].pos.y) / 2.0f;
                        float x2 = (this.cells[i + 1][j].pos.x + this.cells[i + 1][j + 1].pos.x) / 2.0f;
                        float y2 = this.cells[i + 1][j].pos.y;
                        segments.add(new Line2D.Float(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                    }
                }
            }
        }
        return segments;
    }

    private void init(AbstractMatrix projection) {
        this.maxx = Float.NEGATIVE_INFINITY;
        this.maxy = Float.NEGATIVE_INFINITY;
        this.minx = Float.POSITIVE_INFINITY;
        this.miny = Float.POSITIVE_INFINITY;
        for (int i = 0; i < projection.getRowCount(); ++i) {
            float x = projection.getRow(i).getValue(0);
            float y = projection.getRow(i).getValue(1);
            if (this.maxx < x) {
                this.maxx = x;
            }
            if (this.maxy < y) {
                this.maxy = y;
            }
            if (this.minx > x) {
                this.minx = x;
            }
            if (!(this.miny > y)) continue;
            this.miny = y;
        }
    }

    private void cells_density(Cell[][] cells, AbstractMatrix projection) {
        int i;
        float width = (this.maxx - this.minx) / (float)this.grid_width;
        float height = (this.maxy - this.miny) / (float)this.grid_height;
        float max = Float.NEGATIVE_INFINITY;
        float radius = 3.0f * Math.min(width, height) / 2.0f;
        float sd = 1.0f / radius;
        float cnst = (float)(1.0 / (Math.PI * 2 * (double)sd * (double)sd));
        for (i = 0; i < projection.getRowCount(); ++i) {
            float x = projection.getRow(i).getValue(0);
            float y = projection.getRow(i).getValue(1);
            for (int n = 0; n < cells.length; ++n) {
                for (int m = 0; m < cells[n].length; ++m) {
                    float dist = (float)Math.sqrt((x - cells[n][m].pos.x) * (x - cells[n][m].pos.x) + (y - cells[n][m].pos.y) * (y - cells[n][m].pos.y));
                    if (!(dist < radius)) continue;
                    float g = (float)((double)cnst * Math.exp(-(((x - cells[n][m].pos.x) * (x - cells[n][m].pos.x) + (y - cells[n][m].pos.y) * (y - cells[n][m].pos.y)) / 2.0f * sd * sd)));
                    cells[n][m].value += g;
                    if (!(max < cells[n][m].value)) continue;
                    max = cells[n][m].value;
                }
            }
        }
        for (i = 0; i < cells.length; ++i) {
            for (int j = 0; j < cells[i].length; ++j) {
                cells[i][j].value /= max;
            }
        }
    }

    private void cells_geometry(int grid_width, int grid_height) {
        this.cells = new Cell[grid_height + 3][grid_width + 3];
        float width = (this.maxx - this.minx) / (float)grid_width;
        float height = (this.maxy - this.miny) / (float)grid_height;
        for (int i = 0; i < grid_height + 3; ++i) {
            for (int j = 0; j < grid_width + 3; ++j) {
                float x = this.minx - width + (float)j * width;
                float y = this.miny - height + (float)i * height;
                this.cells[i][j] = this.maxx > this.minx && this.maxy > this.miny ? new Cell(x, y) : new Cell(0.0f, 0.0f);
            }
        }
    }

    class Cell {
        public Point2D.Float pos = new Point2D.Float();
        public float value;

        public Cell(float x, float y) {
            this.pos.x = x;
            this.pos.y = y;
            this.value = 0.0f;
        }
    }
}

