/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.projection;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.projectioncloud.projection.MarchingSquare;

public class ProjectionLevelCurvesModel
extends ProjectionModel {
    private float isovalue;
    private ArrayList<Line2D.Float> segments;

    public ProjectionLevelCurvesModel(float isovalue) {
        this.createLevelCurves(isovalue);
    }

    public final void createLevelCurves(float isovalue) {
        this.isovalue = isovalue;
        DenseMatrix proj = new DenseMatrix();
        int size = this.instances.size();
        for (int i = 0; i < size; ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            ((AbstractMatrix)proj).addRow(new DenseVector(new float[]{pi.getX(), pi.getY()}));
        }
        MarchingSquare ms = new MarchingSquare(proj, 25, 25);
        this.segments = ms.execute(isovalue);
        ms.composeGroups(this.segments);
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        if (image != null) {
            ProjectionInstance pi;
            int i;
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (!pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            if (this.segments != null) {
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setColor(Color.red);
                if (highquality) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                for (int i2 = 0; i2 < this.segments.size(); ++i2) {
                    Line2D.Float segment = this.segments.get(i2);
                    g2.draw(segment);
                }
            }
        }
    }
}

