/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.topic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.projectioncloud.topic.Term;

public class CovarianceTopic {
    private AbstractMatrix matrix;
    private int[] indexes;
    private int index;

    public CovarianceTopic(AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public ArrayList<Term> create(ArrayList<Integer> cluster) throws IOException {
        this.indexes = new int[this.matrix.getDimensions()];
        this.index = 0;
        AbstractMatrix auxmat = MatrixFactory.getInstance(this.matrix.getClass());
        for (int i = 0; i < cluster.size(); ++i) {
            auxmat.addRow(this.matrix.getRow(cluster.get(i)));
        }
        float[][] points = auxmat.toMatrix();
        ArrayList<String> newAttributes = new ArrayList<String>();
        points = this.reduceMatrix(points, newAttributes);
        ArrayList<Term> topic = this.extractTopic(points, newAttributes);
        return topic;
    }

    private ArrayList<Term> extractTopic(float[][] points, ArrayList<String> newAttributes) {
        float aux;
        float[] mean = new float[points[0].length];
        Arrays.fill(mean, 0.0f);
        for (int i = 0; i < mean.length; ++i) {
            int j;
            for (j = 0; j < points.length; ++j) {
                int n = i;
                mean[n] = mean[n] + points[j][i];
            }
            int n = i;
            mean[n] = mean[n] / (float)points.length;
            for (j = 0; j < points.length; ++j) {
                float[] fArray = points[j];
                int n2 = i;
                fArray[n2] = fArray[n2] - mean[i];
            }
        }
        float gcov = Float.NEGATIVE_INFINITY;
        int icov = 0;
        int jcov = 0;
        for (int i = 0; i < points[0].length - 1; ++i) {
            for (int j = points[0].length - 1; j > i; --j) {
                if (this.containsIndex(j) || !(gcov < (aux = this.covariance(points, i, j)))) continue;
                gcov = aux;
                icov = i;
                jcov = j;
            }
        }
        this.addIndex(icov);
        this.addIndex(jcov);
        ArrayList<Term> topic = new ArrayList<Term>();
        topic.add(new Term(newAttributes.get(icov), gcov));
        topic.add(new Term(newAttributes.get(jcov), gcov));
        for (int i = 0; i < points[0].length - 1; ++i) {
            if (this.containsIndex(i) || !((aux = (this.covariance(points, icov, i) + this.covariance(points, jcov, i)) / 2.0f) / gcov > 0.1f)) continue;
            topic.add(new Term(newAttributes.get(i), aux));
            this.addIndex(i);
        }
        return topic;
    }

    private float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)(points.length - 1);
    }

    private boolean containsIndex(int index) {
        for (int i = 0; i < this.index; ++i) {
            if (this.indexes[i] != index) continue;
            return true;
        }
        return false;
    }

    private void addIndex(int index) {
        this.indexes[this.index] = index;
        ++this.index;
    }

    private float[][] reduceMatrix(float[][] points, ArrayList<String> newAttributes) {
        int i;
        ArrayList<String> attr = this.matrix.getAttributes();
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (int j = 0; j < points[0].length; ++j) {
            float freq = 0.0f;
            for (int i2 = 0; i2 < points.length; ++i2) {
                freq += points[i2][j];
            }
            pairs.add(new Pair(j, freq));
        }
        Collections.sort(pairs);
        float[][] newpoints = new float[points.length][];
        for (i = 0; i < points.length; ++i) {
            newpoints[i] = new float[points[i].length < 200 ? points[i].length : 200];
            for (int j = 0; j < newpoints[i].length; ++j) {
                newpoints[i][j] = points[i][((Pair)pairs.get((int)j)).index];
            }
        }
        for (i = 0; i < newpoints[0].length; ++i) {
            newAttributes.add(attr.get(((Pair)pairs.get((int)i)).index));
        }
        return newpoints;
    }

    public class Pair
    implements Comparable {
        public int index;
        public float freq;

        public Pair(int index, float freq) {
            this.index = index;
            this.freq = freq;
        }

        public int compareTo(Object o) {
            float diff = ((Pair)o).freq - this.freq;
            return diff == 0.0f ? 0 : (diff > 0.0f ? 1 : -1);
        }
    }
}

