/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import simpletree.matrix.AbstractMatrix;
import simpletree.projectioncloud.topic.GraphTopic;
import simpletree.textprocessing.corpus.zip.ZipCorpus;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.Stopword;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;

public class Wordle {
    public static void main(String[] args) throws IOException {
        String stpfilename = "D:\\My Dropbox\\corpora\\stopwords_news.spw";
        String corpusfilename = "D:\\My Dropbox\\corpora\\rssnewsfeeds.zip";
        int lowercut = 25;
        int uppercut = -1;
        Stopword stp = Stopword.getInstance();
        stp.changeStopwordList(stpfilename);
        ZipCorpus corpus = new ZipCorpus(corpusfilename, 1);
        Preprocessor preproc = new Preprocessor(corpus);
        AbstractMatrix matrixtf = preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.NONE);
        float[][] points = matrixtf.toMatrix();
        int[] freq = new int[matrixtf.getDimensions()];
        Arrays.fill(freq, 0);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                int n = j;
                freq[n] = (int)((float)freq[n] + points[i][j]);
            }
        }
        ArrayList<GraphTopic.Pair> seq = new ArrayList<GraphTopic.Pair>();
        for (int i = 0; i < freq.length; ++i) {
            seq.add(new GraphTopic.Pair(i, freq[i]));
        }
        Collections.sort(seq);
        ArrayList<String> attributes = matrixtf.getAttributes();
        for (int i = 0; i < 200; ++i) {
            System.out.println(attributes.get(((GraphTopic.Pair)seq.get((int)i)).index) + ":" + ((GraphTopic.Pair)seq.get((int)i)).freq);
        }
    }
}

