/*
 * Decompiled with CFR 0.152.
 */
package simpletree.simpletree.view.tools.correlation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.MatrixFactory;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeModel;
import simpletree.simpletree.view.tools.correlation.SimpleTreeCorrelationCoefficient;
import simpletree.simpletree.view.tools.correlation.SimpleTreeCorrelationCoefficientConsole;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.AbstractFilter;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.DMATFilter;
import simpletree.view.JFrameModelViewer;

public class SimpleTreeCorrelationCoefficientView
extends JDialog {
    private SimpleTreeModel model;
    private int choice;
    JFrameModelViewer parent;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JPanel chooseDistanceTypePanel2;
    private JButton closeButton;
    private JPanel dataPanel;
    private JComboBox distanceComboBox;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JButton generateButton;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private JPanel sourcePanel;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JTextField titleTextField;
    private JCheckBox useWeightsCheckBox;

    private SimpleTreeCorrelationCoefficientView(JFrameModelViewer parent) {
        super(parent);
        this.parent = parent;
        this.initComponents();
        this.setModal(true);
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.distanceComboBox.addItem(disstype);
        }
        this.distanceComboBox.setSelectedItem((Object)DissimilarityFactory.DissimilarityType.EUCLIDEAN);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.dataPanel = new JPanel();
        this.chooseDistanceTypePanel2 = new JPanel();
        this.distanceComboBox = new JComboBox();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.useWeightsCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.generateButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Calculate the Silhouette");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("Correlation Coefficient"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.chooseDistanceTypePanel2.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel2.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.chooseDistanceTypePanel2, gridBagConstraints);
        this.titlePanel.setBorder(BorderFactory.createTitledBorder(""));
        this.titleLabel.setText("Title (Optional) : ");
        this.titlePanel.add(this.titleLabel);
        this.titleTextField.setColumns(15);
        this.titlePanel.add(this.titleTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.dataPanel.add((Component)this.titlePanel, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeCorrelationCoefficientView.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.buttonGroup1.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeCorrelationCoefficientView.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeCorrelationCoefficientView.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeCorrelationCoefficientView.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.dataPanel.add((Component)this.sourcePanel, gridBagConstraints);
        this.useWeightsCheckBox.setText("Use Edges Weights");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.dataPanel.add((Component)this.useWeightsCheckBox, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.generateButton.setText("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeCorrelationCoefficientView.this.generateButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.generateButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeCorrelationCoefficientView.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        DistanceMatrix originalDmat = null;
        try {
            if (this.model != null) {
                AbstractDissimilarity diss = DissimilarityFactory.getInstance((DissimilarityFactory.DissimilarityType)((Object)this.distanceComboBox.getSelectedItem()));
                if (this.choice == 0) {
                    if (this.pointsTextField.getText().trim().isEmpty()) {
                        JOptionPane.showMessageDialog(this, "A source data must be informed!", "Error", 0);
                    } else {
                        originalDmat = new DistanceMatrix(MatrixFactory.getInstance(this.pointsTextField.getText()), diss);
                    }
                } else if (this.choice == 1) {
                    if (this.distanceMatrixTextField.getText().trim().isEmpty()) {
                        JOptionPane.showMessageDialog(this, "A source data must be informed!", "Error", 0);
                    } else {
                        originalDmat = new DistanceMatrix(this.distanceMatrixTextField.getText());
                    }
                }
                SimpleTreeCorrelationCoefficient c = new SimpleTreeCorrelationCoefficient();
                ArrayList<SimpleTreeModel> models = new ArrayList<SimpleTreeModel>();
                models.add(this.model);
                Connectivity gCon = null;
                if (this.model.getSelectedConnectivity() != null) {
                    gCon = this.model.getSelectedConnectivity();
                } else if (this.model.getConnectivities() != null && this.model.getConnectivities().size() > 1) {
                    gCon = this.model.getConnectivities().get(1);
                }
                if (gCon == null) {
                    throw new IOException("Error: Tree connectivity not found.");
                }
                ArrayList<ArrayList<Edge>> edges = new ArrayList<ArrayList<Edge>>();
                edges.add(gCon.getEdges());
                ArrayList<ArrayList<Integer>> ids = new ArrayList<ArrayList<Integer>>();
                ArrayList<Integer> idsSet = new ArrayList<Integer>();
                for (int k = 0; k < this.model.getValidInstances().size(); ++k) {
                    idsSet.add(this.model.getValidInstances().get(k).getId());
                }
                ids.add(idsSet);
                String result = c.execute(originalDmat, null, edges, ids, this.useWeightsCheckBox.isSelected());
                SimpleTreeCorrelationCoefficientConsole.getInstance(null).display(this.titleTextField.getText().trim(), result);
                this.setVisible(false);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.choice = 0;
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.choice = 1;
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DATAFilter(), this.pointsTextField);
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DMATFilter(), this.distanceMatrixTextField);
    }

    private void pushButton(AbstractFilter filter, JTextField field) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, filter, this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                field.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeCorrelationCoefficientView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SimpleTreeCorrelationCoefficientView getInstance(JFrameModelViewer parent) {
        return new SimpleTreeCorrelationCoefficientView(parent);
    }

    public void display(SimpleTreeModel model) throws IOException {
        this.model = model;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

