/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.model.Edge;
import simpletree.stress.DistanceStressCurve;
import simpletree.util.TreeDistanceCalculator;

public class SimpleTreeDistanceStressCurve
extends DistanceStressCurve {
    TreeDistanceCalculator t = new TreeDistanceCalculator();

    public BufferedImage generate(Dimension size, float alpha, ArrayList<Edge> edges, ArrayList<Integer> ids, DistanceMatrix originalDmat, boolean useEdgeWeight) throws IOException {
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, size.width, size.height);
        double minrn = originalDmat.getMinDistance();
        double[] min = this.getMinMaxDistance(edges, ids, useEdgeWeight);
        double minr2 = min[0];
        double maxrn = originalDmat.getMaxDistance();
        double maxr2 = min[1];
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawLine(10, 20, size.width - 20, 20);
        g2.drawLine(20, 10, 20, size.height - 20);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.RED);
        g2.drawLine(10, 10, size.width - 20, size.height - 20);
        double dValues = 0.0;
        int rgbcolor = Color.BLUE.getRGB();
        int numRegs = 0;
        System.out.println("Calculating Stress values:");
        for (int i = 0; i < ids.size(); ++i) {
            if (i % (int)((double)ids.size() * 0.1) == 0) {
                System.out.println("-- Processing instance " + i + " of " + ids.size());
            }
            int id_i = ids.get(i);
            int indexOriginal_i = originalDmat.getIds().indexOf(id_i);
            for (int j = i + 1; j < ids.size(); ++j) {
                int id_j = ids.get(j);
                int indexOriginal_j = originalDmat.getIds().indexOf(ids.get(j));
                double distrn = ((double)originalDmat.getDistance(indexOriginal_i, indexOriginal_j) - minrn) / (maxrn - minrn);
                double distr2 = ((double)this.t.getDistance(edges, id_i, id_j, useEdgeWeight) - minr2) / (maxr2 - minr2);
                int x = 40 + (int)((double)(size.width - 60) * distrn);
                int y = 40 + (int)((double)(size.height - 60) * distr2);
                this.simulateAlpha(image, 1.0f, x, y, rgbcolor);
                dValues += Math.abs(distr2 - distrn);
                ++numRegs;
            }
        }
        System.out.println("Dispersion value: " + (dValues /= (double)originalDmat.getElementCount()) + ".");
        BufferedImage refimage = new BufferedImage(size.height, size.width, 1);
        for (int i = 0; i < size.height; ++i) {
            for (int j = 0; j < size.width; ++j) {
                refimage.setRGB(j, i, image.getRGB(j, size.height - i - 1));
            }
        }
        return refimage;
    }

    private double[] getMinMaxDistance(ArrayList<Edge> edges, ArrayList<Integer> ids, boolean useEdgeWeight) {
        double[] ret = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        for (int i = 0; i < ids.size(); ++i) {
            if (i % (int)((double)ids.size() * 0.1) == 0) {
                System.out.println("-- Calculating distances for " + i + " of " + ids.size());
            }
            for (int j = i + 1; j < ids.size(); ++j) {
                float dist = this.t.getDistance(edges, ids.get(i), ids.get(j), useEdgeWeight);
                if ((double)dist < ret[0]) {
                    ret[0] = dist;
                }
                if (!((double)dist > ret[1])) continue;
                ret[1] = dist;
            }
        }
        return ret;
    }
}

