/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeModel;
import simpletree.stress.SimpleTreeDistanceStressCurve;
import simpletree.stress.SimpleTreeStressCurveParamView;
import simpletree.stress.StressCurveComp;
import simpletree.stress.StressCurveDialog;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Basics", name="Calculate Stress Curve", description="Calculate how the distances relations of a tree differ from the original distances relations, for each instance.")
public class SimpleTreeStressCurveComp
extends StressCurveComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private boolean useWeight = true;
    private boolean useVisEuclideanDistance = false;
    private boolean useEuclideanAsWeights = false;

    public Connectivity createEuclideanWeightConnectivity(Connectivity con) {
        AbstractMatrix points = this.exportPoints(this.model.getInstances());
        ArrayList<Edge> connEdges = con.getEdges();
        ArrayList<Integer> ids = points.getIds();
        ArrayList<Edge> euclideanDistEdges = new ArrayList<Edge>();
        if (connEdges == null) {
            return null;
        }
        if (ids == null) {
            return null;
        }
        for (int i = 0; i < connEdges.size(); ++i) {
            int source = connEdges.get(i).getSource();
            int target = connEdges.get(i).getTarget();
            if (ids.indexOf(source) == -1 || ids.indexOf(target) == -1) continue;
            float distance = new Euclidean().calculate(points.getRow(ids.indexOf(source)), points.getRow(ids.indexOf(target)));
            euclideanDistEdges.add(new Edge(source, target, distance));
        }
        Connectivity conn = new Connectivity("Plane Euclidian", euclideanDistEdges);
        return conn;
    }

    @Override
    public void execute() throws IOException {
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        if (this.getDissimilarityType() != null) {
            diss = DissimilarityFactory.getInstance(this.getDissimilarityType());
        }
        SimpleTreeDistanceStressCurve sc = new SimpleTreeDistanceStressCurve();
        if (this.model == null) {
            throw new IOException("A tree model should be provided.");
        }
        if (this.getDataFileName() == null || this.getDataFileName().isEmpty()) {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
        AbstractMatrix validPoints = this.exportPoints(((SimpleTreeModel)this.model).getValidInstances());
        switch (this.getDataFileType()) {
            case 0: {
                try {
                    AbstractMatrix matrix = MatrixFactory.getInstance(this.getDataFileName());
                    this.originalDmat = new DistanceMatrix(matrix, diss);
                }
                catch (IOException ex) {
                    Logger.getLogger(StressCurveComp.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case 1: {
                try {
                    this.originalDmat = new DistanceMatrix(this.getDataFileName());
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(StressCurveComp.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        BufferedImage image = null;
        if (this.useVisEuclideanDistance) {
            DistanceMatrix projectionDmat = new DistanceMatrix(validPoints, new Euclidean());
            ArrayList<String> labels = validPoints.getLabels();
            ArrayList<Integer> ids = validPoints.getIds();
            float[] c = validPoints.getClassData();
            projectionDmat.setLabels(labels);
            projectionDmat.setIds(ids);
            projectionDmat.setClassData(c);
            this.igualateDmats(this.originalDmat, projectionDmat);
            image = sc.generate(new Dimension(1200, 1200), 1.0f, projectionDmat, this.originalDmat);
        } else {
            Connectivity gCon = null;
            if (((SimpleTreeModel)this.model).getSelectedConnectivity() != null) {
                gCon = ((SimpleTreeModel)this.model).getSelectedConnectivity();
            } else if (((SimpleTreeModel)this.model).getConnectivities() != null && ((SimpleTreeModel)this.model).getConnectivities().size() > 1) {
                gCon = ((SimpleTreeModel)this.model).getConnectivities().get(1);
            }
            if (gCon == null) {
                throw new IOException("Error: Tree connectivity not found.");
            }
            if (this.useEuclideanAsWeights) {
                gCon = this.createEuclideanWeightConnectivity(gCon);
            }
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (int i = 0; i < ((SimpleTreeModel)this.model).getValidInstances().size(); ++i) {
                ids.add(((SimpleTreeModel)this.model).getValidInstances().get(i).getId());
            }
            image = sc.generate(new Dimension(1200, 1200), 1.0f, gCon.getEdges(), ids, this.originalDmat, this.useWeight);
        }
        StressCurveDialog.getInstance(null).display(this.graphicLabel, image);
    }

    public void input(@Param(name="Tree Model") SimpleTreeModel model) {
        this.model = model;
    }

    @Override
    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new SimpleTreeStressCurveParamView(this);
        }
        return this.paramview;
    }

    public boolean getUseWeight() {
        return this.useWeight;
    }

    public void setUseWeight(boolean selected) {
        this.useWeight = selected;
    }

    public boolean getUseVisEuclidianDistance() {
        return this.useVisEuclideanDistance;
    }

    public void setUseVisEuclidianDistance(boolean selected) {
        this.useVisEuclideanDistance = selected;
    }

    public boolean getUseEuclideanAsWeights() {
        return this.useEuclideanAsWeights;
    }

    public void setUseEuclideanAsWeights(boolean selected) {
        this.useEuclideanAsWeights = selected;
    }

    private void igualateDmats(DistanceMatrix dmat1, DistanceMatrix dmat2) {
        DistanceMatrix dmBigger;
        DistanceMatrix dmSmaller;
        if (dmat1.getElementCount() > dmat2.getElementCount()) {
            dmSmaller = dmat2;
            dmBigger = dmat1;
        } else {
            dmBigger = dmat2;
            dmSmaller = dmat1;
        }
        for (int i = 0; i < dmBigger.getIds().size(); ++i) {
            int id = dmBigger.getIds().get(i);
            if (dmSmaller.getIds().contains(id)) continue;
            dmBigger.removeElement(id);
            --i;
        }
    }
}

