/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.projection.stress.Stress;
import simpletree.projection.stress.StressFactory;
import simpletree.stress.DistanceStressCurve;
import simpletree.stress.StressCurveDialog;
import simpletree.stress.StressCurveParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Data Analysis", name="Projection Stress Curve", description="Calculate how the distances relations of a projection differ from the original distances relations, for each instance.")
public class StressCurveComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private StressFactory.StressType stresstype = StressFactory.StressType.KRUSKAL;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    protected transient StressCurveParamView paramview;
    protected transient ProjectionModel model;
    protected transient AbstractMatrix originalMatrix;
    protected transient DistanceMatrix originalDmat;
    private String dataFileName = "";
    private int dataFileType;
    protected String graphicLabel = "";

    protected AbstractMatrix exportPoints(ArrayList<AbstractInstance> instances) {
        DenseMatrix matrix = new DenseMatrix();
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < instances.size(); ++i) {
            float[] point = new float[]{((ProjectionInstance)instances.get(i)).getX(), ((ProjectionInstance)instances.get(i)).getY()};
            Integer id = ((ProjectionInstance)instances.get(i)).getId();
            labels.add(((ProjectionInstance)instances.get(i)).toString());
            ((AbstractMatrix)matrix).addRow(new DenseVector(point, id, 0.0f));
        }
        matrix.setLabels(labels);
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("x");
        attributes.add("y");
        matrix.setAttributes(attributes);
        return matrix;
    }

    public void execute() throws IOException {
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        if (this.getDissimilarityType() != null) {
            diss = DissimilarityFactory.getInstance(this.getDissimilarityType());
        }
        Object stress = null;
        Stress stresscalc = StressFactory.getInstance(this.stresstype);
        DistanceStressCurve sc = new DistanceStressCurve();
        if (this.model == null) {
            throw new IOException("A projection model should be provided.");
        }
        if (this.dataFileName == null || this.dataFileName.isEmpty()) {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
        AbstractMatrix points = this.exportPoints(this.model.getInstances());
        DistanceMatrix projectionDmat = new DistanceMatrix(points, new Euclidean());
        switch (this.dataFileType) {
            case 0: {
                try {
                    AbstractMatrix matrix = MatrixFactory.getInstance(this.dataFileName);
                    this.originalDmat = new DistanceMatrix(matrix, diss);
                }
                catch (IOException ex) {
                    Logger.getLogger(StressCurveComp.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case 1: {
                try {
                    this.originalDmat = new DistanceMatrix(this.dataFileName);
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(StressCurveComp.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (this.originalDmat.getElementCount() != projectionDmat.getElementCount()) {
            JOptionPane.showMessageDialog(null, "Original dataset is different from projected dataset!");
        } else {
            BufferedImage image = sc.generate(new Dimension(1200, 1200), 1.0f, projectionDmat, this.originalDmat);
            StressCurveDialog.getInstance(null).display(this.graphicLabel, image);
        }
    }

    public void input(@Param(name="Projection Model") ProjectionModel model) {
        this.model = model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new StressCurveParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
        this.originalMatrix = null;
        this.originalDmat = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public StressFactory.StressType getStressType() {
        return this.stresstype;
    }

    public void setStressType(StressFactory.StressType stresstype) {
        this.stresstype = stresstype;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public int getDataFileType() {
        return this.dataFileType;
    }

    public void setDataFileType(int dataFileType) {
        this.dataFileType = dataFileType;
    }

    public String getGraphicLabel() {
        return this.graphicLabel;
    }

    public void setGraphicLabel(String s) {
        this.graphicLabel = s;
    }
}

