/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import simpletree.stress.ImagePanel;
import simpletree.util.ProjectionMessageDialog;
import simpletree.util.SaveDialog;
import simpletree.util.filter.PNGFilter;

public class StressCurveDialog
extends JDialog {
    private ImagePanel imPanel;
    private BufferedImage img;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton saveImageButton;

    private StressCurveDialog(JDialog parent) {
        super(parent);
        this.initComponents();
        this.setModal(false);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Stress Curve");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StressCurveDialog.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StressCurveDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void saveImageButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new PNGFilter(), this, "", "Stress.png");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            try {
                if (this.imPanel.imgSave != null) {
                    ImageIO.write((RenderedImage)this.imPanel.imgSave, "png", new File(filename));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(StressCurveDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static StressCurveDialog getInstance(JDialog parent) {
        return new StressCurveDialog(parent);
    }

    public void display(final String label, BufferedImage image) {
        final ProjectionMessageDialog md = ProjectionMessageDialog.show(this, "Calculating Stress curve...");
        if (image != null) {
            this.img = image;
            Thread t = new Thread(){

                @Override
                public void run() {
                    StressCurveDialog.this.imPanel = new ImagePanel(label, StressCurveDialog.this.img);
                    StressCurveDialog.this.getContentPane().add((Component)StressCurveDialog.this.imPanel, "Center");
                    StressCurveDialog.this.setPreferredSize(new Dimension(430, 520));
                    StressCurveDialog.this.setSize(new Dimension(430, 520));
                    StressCurveDialog.this.setLocationRelativeTo(StressCurveDialog.this.getParent());
                    md.close();
                    StressCurveDialog.this.setVisible(true);
                }
            };
            t.start();
        }
    }
}

