/*
 * Decompiled with CFR 0.152.
 */
package simpletree.stress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.projection.stress.StressFactory;
import simpletree.stress.StressCurveComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.DMATFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class StressCurveParamView
extends AbstractParametersView {
    protected StressCurveComp comp;
    private ButtonGroup buttonGroup1;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    protected JPanel generalPanel;
    private JLabel graphicLabel;
    private JTextField graphicLabelTextField;
    private JPanel jPanel1;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private JPanel sourcePanel;
    private JComboBox stressComboBox;
    private JPanel stressPanel;

    public StressCurveParamView(StressCurveComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType dissimilarityType : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(dissimilarityType);
        }
        for (Enum enum_ : StressFactory.StressType.values()) {
            this.stressComboBox.addItem(enum_);
        }
        this.reset();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.stressPanel = new JPanel();
        this.stressComboBox = new JComboBox();
        this.generalPanel = new JPanel();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.jPanel1 = new JPanel();
        this.graphicLabel = new JLabel();
        this.graphicLabelTextField = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder("Stress Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.stressPanel.setBorder(BorderFactory.createTitledBorder("Stress Technique"));
        this.stressPanel.setLayout(new BorderLayout());
        this.stressPanel.add((Component)this.stressComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.stressPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add(this.generalPanel, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StressCurveParamView.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.buttonGroup1.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StressCurveParamView.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StressCurveParamView.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StressCurveParamView.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.sourcePanel, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Label"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.graphicLabel.setText("Graphic Label : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.graphicLabel, gridBagConstraints);
        this.graphicLabelTextField.setMinimumSize(new Dimension(150, 20));
        this.graphicLabelTextField.setPreferredSize(new Dimension(150, 20));
        this.graphicLabelTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StressCurveParamView.this.graphicLabelTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.graphicLabelTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.add(this.jPanel1, gridBagConstraints);
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.dissimilarityComboBox.setEnabled(true);
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.dissimilarityComboBox.setEnabled(false);
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, new DATAFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.pointsTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StressCurveParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, new DMATFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.distanceMatrixTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StressCurveParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void graphicLabelTextFieldActionPerformed(ActionEvent evt) {
    }

    public void reset() {
        if (this.comp.getDataFileType() == 1) {
            this.distanceMatrixRadioButton.setSelected(true);
            this.distanceMatrixTextField.setEnabled(true);
            this.distanceMatrixTextField.setText(this.comp.getDataFileName());
            this.distanceMatrixButton.setEnabled(true);
            this.dissimilarityComboBox.setEnabled(false);
            this.pointsTextField.setEnabled(false);
            this.pointsTextField.setText("");
            this.pointsButton.setEnabled(false);
        } else {
            this.pointsRadioButton.setSelected(true);
            this.pointsTextField.setEnabled(true);
            this.pointsTextField.setText(this.comp.getDataFileName());
            this.pointsButton.setEnabled(true);
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
            this.distanceMatrixTextField.setEnabled(false);
            this.distanceMatrixTextField.setText("");
            this.distanceMatrixButton.setEnabled(false);
        }
        this.stressComboBox.setSelectedItem((Object)this.comp.getStressType());
        this.graphicLabelTextField.setText(this.comp.getGraphicLabel());
    }

    public void finished() throws IOException {
        if (this.pointsRadioButton.isSelected()) {
            if (this.pointsTextField.getText().trim().length() > 0) {
                this.comp.setDataFileType(0);
                this.comp.setDataFileName(this.pointsTextField.getText());
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "A points file must be selected.", "Error", 0);
            }
        } else if (this.distanceMatrixRadioButton.isSelected()) {
            if (this.distanceMatrixTextField.getText().trim().length() > 0) {
                this.comp.setDataFileType(1);
                this.comp.setDataFileName(this.distanceMatrixTextField.getText());
                this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "A distance matrix file must be selected.", "Error", 0);
            }
        }
        this.comp.setStressType((StressFactory.StressType)((Object)this.stressComboBox.getSelectedItem()));
        this.comp.setGraphicLabel(this.graphicLabelTextField.getText().trim());
        this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
    }
}

