/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.agglomerative;

import java.io.IOException;
import simpletree.basics.SimpleTree;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.technique.agglomerative.AgglomerativeTreeParamView;
import simpletree.technique.agglomerative.UPGMA;
import simpletree.technique.agglomerative.WPGMA;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Technique", name="Agglomerative Simple Tree", description="Project points from a multidimensional space to the plane preserving the neighborhood relations.", howtocite="ORIGINAL NJ: N. Saitou and M. Nei. The Neighbor-Joining Method: A New Method for Reconstructing Phylogenetic Trees. Molecular Biology and Evolution, 4(4):406\u2013425, 1987 \nRAPID NJ: M. Simonsen, T. Mailund, and C. N. Pedersen. Rapid Neighbour-Joining. In Proceedings of WABI 2008, pages 113\u2013122, Karlsruhe, Germany, September 2008 \nFAST NJ: I. Elias and J. Lagergren. Fast Neighbor Joining. In Proceedings of the 32nd International Colloquium on Automata, Languages and Programming (ICALP\u201905), volume 3580, pages 1263\u20131274, 2005 \nPromotion Procedure: PAIVA, J. G., FLORIAN-CRUZ, L., PEDRINI, H., TELLES, G. P., MINGHIM, R., Improved Similarity Trees and their Application to Visual Data Classification, IEEE Transactions on Visualization and Computer Graphics, v. 17, p. 2459-2468, 2011")
public class AgglomerativeTreeComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private transient AgglomerativeTreeParamView paramview;
    private transient SimpleTree tree;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;
    public AgglomerativeTreeParamView.AgglomerativeTreeType agglomerativeTreeType = AgglomerativeTreeParamView.AgglomerativeTreeType.UPGMA;
    private String dmatFile;

    public void execute() throws IOException {
        if (this.dmatFile != null && !this.dmatFile.trim().isEmpty()) {
            this.matrix = null;
            this.dmat = null;
            this.dmat = new DistanceMatrix(this.dmatFile);
            this.tree = this.agglomerativeTreeType == AgglomerativeTreeParamView.AgglomerativeTreeType.UPGMA ? UPGMA.execute(this.dmat) : WPGMA.execute(this.dmat);
        } else if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            this.tree = this.agglomerativeTreeType == AgglomerativeTreeParamView.AgglomerativeTreeType.UPGMA ? UPGMA.execute(this.matrix, diss) : WPGMA.execute(this.matrix, diss);
            if (this.tree != null) {
                this.tree.updateRecursiveChildCount();
            }
        } else if (this.dmat != null) {
            this.tree = this.agglomerativeTreeType == AgglomerativeTreeParamView.AgglomerativeTreeType.UPGMA ? UPGMA.execute(this.dmat) : WPGMA.execute(this.dmat);
            if (this.tree != null) {
                this.tree.updateRecursiveChildCount();
            } else {
                System.out.println("A arvore eh null!");
            }
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public SimpleTree output() {
        return this.tree;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new AgglomerativeTreeParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
        this.dmat = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }

    public String getDmatFile() {
        return this.dmatFile;
    }

    public void setDmatFile(String text) {
        this.dmatFile = text;
    }
}

