/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.lsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class CreateNNG {
    public void execute(Pair[][] neighbors, AbstractMatrix matrix, AbstractDissimilarity diss) {
        long start = System.currentTimeMillis();
        int origaverage = neighbors[0].length;
        this.completing(neighbors);
        for (int i = 0; i < 10; ++i) {
            this.refining(neighbors, origaverage);
            this.completing(neighbors);
        }
        int nrcomponents = this.connecting(neighbors, matrix, diss);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Number of components on the NNG: {0}", nrcomponents);
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Connecting components time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
    }

    private void refining(Pair[][] neighbors, int origaverage) {
        for (int i = 0; i < neighbors.length; ++i) {
            if (neighbors[i].length <= origaverage) continue;
            ArrayList<Pair> aux = new ArrayList<Pair>();
            for (int j = 0; j < neighbors[i].length; ++j) {
                aux.add(neighbors[i][j]);
            }
            Collections.shuffle(aux);
            Pair[] newneighbors = new Pair[origaverage];
            for (int j = 0; j < origaverage; ++j) {
                newneighbors[j] = (Pair)aux.get(j);
            }
            neighbors[i] = newneighbors;
        }
    }

    private int connecting(Pair[][] neighbors, AbstractMatrix matrix, AbstractDissimilarity diss) {
        int nrcomponents = 0;
        HashSet<Integer> visited = new HashSet<Integer>();
        while (visited.size() < neighbors.length) {
            int seed = 0;
            for (int i = 0; i < neighbors.length; ++i) {
                if (visited.contains(i)) continue;
                seed = i;
                break;
            }
            if (visited.size() > 0) {
                Integer node = (Integer)visited.iterator().next();
                float dist = diss.calculate(matrix.getRow(node), matrix.getRow(seed));
                Pair[] newNeighbors1 = new Pair[neighbors[node].length + 1];
                for (int j = 0; j < neighbors[node].length; ++j) {
                    newNeighbors1[j] = neighbors[node][j];
                }
                newNeighbors1[neighbors[node.intValue()].length] = new Pair(seed, dist);
                neighbors[node.intValue()] = newNeighbors1;
                Pair[] newNeighbors2 = new Pair[neighbors[seed].length + 1];
                for (int j = 0; j < neighbors[seed].length; ++j) {
                    newNeighbors2[j] = neighbors[seed][j];
                }
                newNeighbors2[neighbors[seed].length] = new Pair(node, dist);
                neighbors[seed] = newNeighbors2;
            }
            this.getComponent(neighbors, visited, seed);
            ++nrcomponents;
        }
        return nrcomponents;
    }

    private void completing(Pair[][] neighbors) {
        for (int i = 0; i < neighbors.length; ++i) {
            for (int j = 0; j < neighbors[i].length; ++j) {
                boolean contain = false;
                for (int k = 0; k < neighbors[neighbors[i][j].index].length; ++k) {
                    if (neighbors[neighbors[i][j].index][k].index != i) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                Pair[] newneighbors = new Pair[neighbors[neighbors[i][j].index].length + 1];
                for (int k = 0; k < newneighbors.length - 1; ++k) {
                    newneighbors[k] = neighbors[neighbors[i][j].index][k];
                }
                newneighbors[newneighbors.length - 1] = new Pair(i, neighbors[i][j].value);
                neighbors[neighbors[i][j].index] = newneighbors;
            }
        }
    }

    private void getComponent(Pair[][] neighborhood, HashSet<Integer> visited, int seed) {
        visited.add(seed);
        HashSet<Integer> tovisit = new HashSet<Integer>();
        for (int i = 0; i < neighborhood[seed].length; ++i) {
            if (visited.contains(neighborhood[seed][i].index)) continue;
            tovisit.add(neighborhood[seed][i].index);
        }
        while (tovisit.size() > 0) {
            Integer[] nodes = tovisit.toArray(new Integer[0]);
            for (int i = 0; i < nodes.length; ++i) {
                tovisit.remove(nodes[i]);
                visited.add(nodes[i]);
                for (int j = 0; j < neighborhood[nodes[i]].length; ++j) {
                    if (visited.contains(neighborhood[nodes[i].intValue()][j].index)) continue;
                    tovisit.add(neighborhood[nodes[i].intValue()][j].index);
                }
            }
        }
    }
}

