/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.lsp;

import java.io.IOException;
import simpletree.datamining.sampling.Sampling;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.technique.lsp.LSPProjection2D;
import simpletree.technique.lsp.LSPProjection2DParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Technique", name="Least Square Projection (LSP)", description="Project points from a multidimensional space to the plane preserving the neighborhood relations.", howtocite="Paulovich, F. V.; Nonato, L. G.; Minghim, R.; Levkowitz, H. Least Square Projection: a fast high precision multidimensional projection technique and its application to document mapping. IEEE Transactions on Visualization and Computer Graphics, v. 14, p. 564-575, 2008. ")
public class LSPProjection2DComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private int nrneighbors = 10;
    private int samplesize = 10;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private Sampling.SampleType sampletype = Sampling.SampleType.RANDOM;
    private transient LSPProjection2DParamView paramview;
    private transient AbstractMatrix projection;
    private transient AbstractMatrix matrix;
    private transient AbstractMatrix sampleproj;
    private transient AbstractMatrix sampledata;

    public void execute() throws IOException {
        AbstractDissimilarity diss;
        LSPProjection2D lsp = new LSPProjection2D();
        lsp.setNumberNeighbors(this.nrneighbors);
        lsp.setSampleSize(this.samplesize);
        if (this.matrix != null) {
            diss = DissimilarityFactory.getInstance(this.disstype);
            lsp.setSampleType(this.sampletype);
            if (this.sampledata != null) {
                lsp.setSampleMatrix(this.sampledata);
            }
            if (this.sampleproj != null) {
                lsp.setSampleProjection(this.sampleproj);
            }
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
        this.projection = lsp.project(this.matrix, diss);
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix, @Param(name="sample data") AbstractMatrix sampledata, @Param(name="sample projection") AbstractMatrix sampleproj) {
        this.matrix = matrix;
        this.sampledata = sampledata;
        this.sampleproj = sampleproj;
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix, @Param(name="sample data") AbstractMatrix sampledata) {
        this.matrix = matrix;
        this.sampledata = sampledata;
    }

    public AbstractMatrix output() {
        return this.projection;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new LSPProjection2DParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.projection = null;
        this.matrix = null;
    }

    public int getNumberNeighbors() {
        return this.nrneighbors;
    }

    public void setNumberNeighbors(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    public int getSampleSize() {
        return this.samplesize;
    }

    public void setSampleSize(int samplesize) {
        this.samplesize = samplesize;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public Sampling.SampleType getSampleType() {
        return this.sampletype;
    }

    public void setSampleType(Sampling.SampleType sampletype) {
        this.sampletype = sampletype;
    }

    public boolean isDistanceMatrixProvided() {
        return false;
    }

    public int getNumberInstances() {
        if (this.matrix != null) {
            return this.matrix.getRowCount();
        }
        return 0;
    }
}

