/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.msnj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.basics.ClusterContentSimpleTree;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.MultiscaleParams;
import simpletree.basics.SimpleTree;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.datamining.clustering.multiscale.ClusterIO;
import simpletree.datamining.clustering.multiscale.MultiscaleData;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseVector;
import simpletree.technique.packagenj.PackageNJ;
import simpletree.technique.packagenj.PackageNJConnectionComp;

public class MultiScaleNJ {
    private boolean promotion = false;
    private final PackageNJ.NJAlgorithmType type;
    private final DissimilarityFactory.DissimilarityType dissType;
    private int maxId;
    private MultiscaleParams multiscaleParams;
    private final int minClusterSize = 2;
    public boolean expandLeafClusters = true;

    public MultiScaleNJ(boolean pnj, PackageNJ.NJAlgorithmType type, DissimilarityFactory.DissimilarityType dissType, int maxId) {
        this.promotion = pnj;
        this.type = type;
        this.dissType = dissType;
        this.maxId = maxId;
        this.multiscaleParams = new MultiscaleParams(pnj, type, dissType, maxId);
    }

    public SimpleTree execute(Cluster singleCluster, AbstractMatrix matrix, boolean createSingleRoot, MultiscaleParams multiscaleParams) throws IOException {
        SimpleTree newTree = this.treeFromCluster(createSingleRoot, matrix, singleCluster);
        newTree.setMultiScaleParams(multiscaleParams);
        return newTree;
    }

    public SimpleTree execute(MultiscaleData clusterDataset, AbstractMatrix matrix, boolean createSingleRoot, int levelsToExpand) {
        try {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.dissType);
            List<Cluster> clusterList = clusterDataset.getClusters();
            DistanceMatrix dmCentroids = this.buildCentroidsDM(clusterList, diss, matrix);
            SimpleTree superTree = this.treeFromClusters(createSingleRoot, dmCentroids, matrix, clusterList);
            superTree.setMultiScaleParams(this.multiscaleParams);
            for (ContentSimpleTree node : superTree.getNodes()) {
                node.multiscaleLevel = levelsToExpand - 1;
            }
            if (levelsToExpand > 1) {
                --levelsToExpand;
                for (Cluster cluster : clusterList) {
                    SimpleTree newTree;
                    MultiscaleData newClusterData = new MultiscaleData();
                    newClusterData.setFilename(clusterDataset.getFilename());
                    newClusterData.setMap(clusterDataset.getMap());
                    newClusterData.setMaxClusterId(clusterDataset.getMaxClusterId());
                    if (cluster.getItemList().isEmpty() && cluster.getSubClusterList().isEmpty()) {
                        cluster = ClusterIO.readBinaryCluster(newClusterData.getFilename(), clusterDataset.getMap().get(cluster.getId()), true);
                    }
                    if (cluster.getSubClusterList().isEmpty() && cluster.getSize() > 2) {
                        newTree = this.treeFromCluster(true, matrix, cluster);
                        for (ContentSimpleTree node : newTree.getNodes()) {
                            node.multiscaleLevel = levelsToExpand - 1;
                        }
                        superTree.appendTree(newTree, cluster.getId(), false);
                        continue;
                    }
                    if (cluster.getSubClusterList().isEmpty()) continue;
                    newClusterData.setClusters(cluster.getSubClusterList());
                    newTree = this.execute(newClusterData, matrix, true, levelsToExpand);
                    ContentSimpleTree newTreeRoot = newTree.getNodeById(newTree.getRootId());
                    newTreeRoot.multiscaleLevel = levelsToExpand;
                    superTree.appendTree(newTree, cluster.getId(), false);
                }
            }
            superTree.updateLevels();
            superTree.generateEdges();
            superTree.setMultiScaleParams(this.multiscaleParams);
            return superTree;
        }
        catch (IOException ex) {
            Logger.getLogger(MultiScaleNJ.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private int getMaxId(MultiscaleData clusterDataset, AbstractMatrix matrix) {
        int newMaxId = this.maxId;
        if (newMaxId != 0) {
            return newMaxId;
        }
        newMaxId = Integer.MIN_VALUE;
        for (AbstractVector av : matrix.getRows()) {
            if (newMaxId >= av.getId()) continue;
            newMaxId = av.getId();
        }
        if (clusterDataset.getMaxClusterId() > newMaxId) {
            newMaxId = clusterDataset.getMaxClusterId();
        }
        return newMaxId;
    }

    private DistanceMatrix buildCentroidsDM(List<Cluster> clusterList, AbstractDissimilarity diss, AbstractMatrix matrix) {
        int i;
        DistanceMatrix dmCentroids = new DistanceMatrix(clusterList.size());
        float[] classes = new float[clusterList.size()];
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<String> labels = new ArrayList<String>();
        for (i = 0; i < clusterList.size(); ++i) {
            int medoidId = clusterList.get(i).getMedoidList().get(0);
            classes[i] = matrix.getRow(medoidId).getKlass();
            ids.add(clusterList.get(i).getId());
            labels.add(matrix.getLabel(medoidId));
        }
        for (i = 0; i < clusterList.size(); ++i) {
            for (int j = i + 1; j < clusterList.size(); ++j) {
                DenseVector vectorA = clusterList.get(i).getCentroidVector();
                DenseVector vectorB = clusterList.get(j).getCentroidVector();
                float distance = diss.calculate(vectorA, vectorB);
                dmCentroids.setDistance(i, j, distance);
            }
        }
        dmCentroids.setClassData(classes);
        dmCentroids.setIds(ids);
        dmCentroids.setLabels(labels);
        return dmCentroids;
    }

    private SimpleTree treeFromCluster(boolean createSingleRoot, AbstractMatrix matrix, Cluster cluster) throws IOException {
        SimpleTree newTree;
        if (cluster.getSubClusterList().isEmpty()) {
            if (this.expandLeafClusters) {
                PackageNJConnectionComp njc = new PackageNJConnectionComp();
                AbstractMatrix clusterMatrix = cluster.getClusterPointsMatrix(matrix);
                njc.input(clusterMatrix);
                njc.setMaxId(this.maxId);
                njc.setNjAlgorithmType(this.type);
                njc.setPnj(false);
                njc.setCreateSingleRoot(createSingleRoot);
                njc.execute();
                newTree = njc.output();
                HashMap<Integer, String> treeLabelMap = new HashMap<Integer, String>();
                HashMap<Integer, Float> treeClassMap = new HashMap<Integer, Float>();
                this.fillTreeInfo(cluster, matrix, treeClassMap, treeLabelMap);
                int newTreeMaxId = newTree.getMaxNodeId();
                if (newTreeMaxId > this.maxId) {
                    this.maxId = newTree.getMaxNodeId() + 1;
                }
            } else {
                newTree = new SimpleTree();
                ClusterContentSimpleTree clusterNode = new ClusterContentSimpleTree(cluster.getId(), cluster);
                newTree.addNode(clusterNode);
                HashMap<Integer, String> treeLabelMap = new HashMap<Integer, String>();
                HashMap<Integer, Float> treeClassMap = new HashMap<Integer, Float>();
                this.fillTreeInfo(cluster, matrix, treeClassMap, treeLabelMap);
                newTree.setLabelMap(treeLabelMap);
                newTree.setClassMap(treeClassMap);
                int medoidId = matrix.getRow(cluster.getMedoidList().get(0)).getId();
                clusterNode.setKlass(treeClassMap.get(medoidId).floatValue());
            }
        } else {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.dissType);
            DistanceMatrix dmCentroids = this.buildCentroidsDM(cluster.getSubClusterList(), diss, matrix);
            newTree = this.treeFromClusters(createSingleRoot, dmCentroids, matrix, cluster.getSubClusterList());
        }
        return newTree;
    }

    private SimpleTree treeFromClusters(boolean createSingleRoot, DistanceMatrix dmCentroids, AbstractMatrix matrix, List<Cluster> clusterList) throws IOException {
        PackageNJConnectionComp njc = new PackageNJConnectionComp();
        njc.input(dmCentroids);
        njc.setMaxId(this.maxId);
        njc.setNjAlgorithmType(this.type);
        njc.setPnj(false);
        njc.setCreateSingleRoot(createSingleRoot);
        njc.execute();
        SimpleTree newTree = njc.output();
        int newTreeMaxId = newTree.getMaxNodeId();
        if (newTreeMaxId > this.maxId) {
            this.maxId = newTree.getMaxNodeId() + 1;
        }
        HashMap<Integer, String> treeLabelMap = new HashMap<Integer, String>();
        HashMap<Integer, Float> treeClassMap = new HashMap<Integer, Float>();
        for (Cluster cluster : clusterList) {
            int clusterId = cluster.getId();
            ContentSimpleTree clusterSimpleNode = newTree.getNodeById(clusterId);
            int clusterSimpleNodePosition = newTree.getNodePosition(clusterSimpleNode);
            if (cluster.getSize() > 2) {
                ClusterContentSimpleTree clusterNode = new ClusterContentSimpleTree(clusterId, cluster);
                clusterNode.setParent(clusterSimpleNode.getParent());
                clusterNode.setKlass(clusterSimpleNode.getKlass());
                clusterNode.setLevel(clusterSimpleNode.getLevel());
                clusterNode.setValid(clusterSimpleNode.isValid());
                clusterNode.setRecursiveChildCount(cluster.getSize());
                clusterNode.setLevelHeight(cluster.getLevelHeight());
                newTree.removeNode(clusterSimpleNode);
                newTree.insertNodeAt(clusterSimpleNodePosition, clusterNode);
                continue;
            }
            SimpleTree output = this.treeFromCluster(true, matrix, cluster);
            treeLabelMap.putAll(output.getLabelMap());
            treeClassMap.putAll(output.getClassMap());
            if (output.getMaxNodeId() > this.maxId) {
                this.maxId = output.getMaxNodeId() + 1;
            }
            newTree.appendTree(output, clusterSimpleNode.getId(), false);
            treeLabelMap.putAll(output.getLabelMap());
            treeClassMap.putAll(output.getClassMap());
        }
        newTree.setLabelMap(treeLabelMap);
        newTree.setClassMap(treeClassMap);
        return newTree;
    }

    private void fillTreeInfo(Cluster cluster, AbstractMatrix matrix, HashMap<Integer, Float> classMap, HashMap<Integer, String> labelMap) {
        float classInfo;
        int instanceId;
        if (cluster.getSubClusterList().isEmpty()) {
            for (Integer elementIndex : cluster.getItemList()) {
                instanceId = matrix.getRow(elementIndex).getId();
                if (matrix.getLabels() != null && !matrix.getLabels().isEmpty()) {
                    String label = matrix.getLabels().get(elementIndex);
                    labelMap.put(instanceId, label);
                }
                classInfo = matrix.getRow(elementIndex).getKlass();
                classMap.put(instanceId, Float.valueOf(classInfo));
            }
        }
        for (Integer medoidIndex : cluster.getMedoidList()) {
            instanceId = matrix.getRow(medoidIndex).getId();
            if (matrix.getLabels() != null && !matrix.getLabels().isEmpty()) {
                String label = matrix.getLabels().get(medoidIndex);
                labelMap.put(instanceId, label);
            }
            classInfo = matrix.getRow(medoidIndex).getKlass();
            classMap.put(instanceId, Float.valueOf(classInfo));
        }
    }
}

