/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.packagenj;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.technique.packagenj.DistanceMatrixReader;
import simpletree.technique.packagenj.Node;
import simpletree.technique.packagenj.PexMatrix;
import simpletree.technique.packagenj.Sort;

public class PackageNJ {
    private boolean promotion = false;
    private NJAlgorithmType type;

    public PackageNJ(boolean pnj, NJAlgorithmType type) {
        this.promotion = pnj;
        this.type = type;
    }

    public static HashMap<Integer, Node> originalNJ(PexMatrix p, int maxId) {
        double Sum = 0.0;
        double[] sum = new double[p.n];
        double[] joined = new double[p.n];
        String[] newick = new String[p.n];
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int k = 0; k < p.n; ++k) {
            int x;
            newick[k] = p.ids == null ? Integer.toString(k) : Integer.toString(p.ids[k]);
            sum[k] = 0.0;
            nodes.put(Integer.parseInt(newick[k]), new Node(Integer.parseInt(newick[k])));
            for (x = 0; x < k; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[k][x];
                Sum += p.M[k][x];
            }
            for (x = k + 1; x < p.n; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[x][k];
                Sum += p.M[x][k];
            }
        }
        int nextId = maxId;
        while (p.n > 2) {
            int k;
            double smin = Double.MAX_VALUE;
            int imin = 0;
            int jmin = 0;
            for (int i = 1; i < p.n; ++i) {
                for (int j = 0; j < i; ++j) {
                    double s = (sum[i] - p.M[i][j] + sum[j] - p.M[i][j]) / (double)(2 * (p.n - 2)) + p.M[i][j] / 2.0 + (Sum - sum[i] - sum[j] + p.M[i][j]) / (double)(p.n - 2);
                    if (!(s < smin)) continue;
                    smin = s;
                    imin = i;
                    jmin = j;
                }
            }
            double dikmin = (sum[imin] - p.M[imin][jmin]) / (double)(p.n - 2);
            double djkmin = (sum[jmin] - p.M[imin][jmin]) / (double)(p.n - 2);
            String oldvalue = newick[jmin];
            newick[jmin] = "(" + newick[imin] + ":" + new Formatter().format(Locale.US, "%1.2f", (p.M[imin][jmin] + dikmin - djkmin) / 2.0 - joined[imin]).toString() + "," + newick[jmin] + ":" + new Formatter().format(Locale.US, "%1.2f", (p.M[imin][jmin] + djkmin - dikmin) / 2.0 - joined[jmin]).toString() + ")" + Integer.toString(nextId);
            int id = nextId++;
            Node node = new Node(id);
            node.distance.add((p.M[imin][jmin] + dikmin - djkmin) / 2.0 - joined[imin]);
            node.distance.add((p.M[imin][jmin] + djkmin - dikmin) / 2.0 - joined[jmin]);
            if (newick[imin].lastIndexOf(")") != -1) {
                node.children.add(nodes.get(Integer.parseInt(newick[imin].substring(newick[imin].lastIndexOf(")") + 1))));
            } else {
                node.children.add(nodes.get(Integer.parseInt(newick[imin])));
            }
            if (oldvalue.lastIndexOf(")") != -1) {
                node.children.add(nodes.get(Integer.parseInt(oldvalue.substring(oldvalue.lastIndexOf(")") + 1))));
            } else {
                node.children.add(nodes.get(Integer.parseInt(oldvalue)));
            }
            nodes.put(id, node);
            joined[jmin] = p.M[imin][jmin] / 2.0;
            sum[jmin] = 0.0;
            for (k = 0; k < jmin; ++k) {
                if (k == imin) continue;
                Sum -= p.M[jmin][k];
                int n = k;
                sum[n] = sum[n] - p.M[jmin][k];
                p.M[jmin][k] = (p.M[jmin][k] + (k < imin ? p.M[imin][k] : p.M[k][imin])) / 2.0;
                Sum += p.M[jmin][k];
                int n2 = k;
                sum[n2] = sum[n2] + p.M[jmin][k];
                int n3 = jmin;
                sum[n3] = sum[n3] + p.M[jmin][k];
            }
            for (k = jmin + 1; k < p.n; ++k) {
                if (k == imin) continue;
                Sum -= p.M[k][jmin];
                int n = k;
                sum[n] = sum[n] - p.M[k][jmin];
                p.M[k][jmin] = (p.M[k][jmin] + (k < imin ? p.M[imin][k] : p.M[k][imin])) / 2.0;
                Sum += p.M[k][jmin];
                int n4 = k;
                sum[n4] = sum[n4] + p.M[k][jmin];
                int n5 = jmin;
                sum[n5] = sum[n5] + p.M[k][jmin];
            }
            int n = jmin;
            sum[n] = sum[n] + p.M[imin][jmin];
            for (k = 0; k < imin; ++k) {
                Sum -= p.M[imin][k];
                int n6 = k;
                sum[n6] = sum[n6] - p.M[imin][k];
                p.M[imin][k] = p.M[p.n - 1][k];
            }
            for (k = imin + 1; k < p.n - 1; ++k) {
                Sum -= p.M[k][imin];
                int n7 = k;
                sum[n7] = sum[n7] - p.M[k][imin];
                p.M[k][imin] = p.M[p.n - 1][k];
            }
            Sum -= p.M[p.n - 1][imin];
            newick[imin] = newick[p.n - 1];
            joined[imin] = joined[p.n - 1];
            sum[imin] = sum[p.n - 1] - p.M[p.n - 1][imin];
            --p.n;
        }
        double x = (p.M[1][0] + p.M[2][0] - p.M[2][1]) / 2.0 - joined[0];
        double y = (p.M[1][0] + p.M[2][1] - p.M[2][0]) / 2.0 - joined[1];
        double z = (p.M[2][0] + p.M[2][1] - p.M[1][0]) / 2.0 - joined[2];
        int id = nextId;
        Node node = new Node(id);
        node.distance.add(x);
        node.distance.add(y);
        node.distance.add(z);
        if (newick[0].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0].substring(newick[0].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0])));
        }
        if (newick[1].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1].substring(newick[1].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1])));
        }
        if (newick[2].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2].substring(newick[2].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2])));
        }
        nodes.put(id, node);
        return nodes;
    }

    public static HashMap<Integer, Node> fastNJ(PexMatrix p, int maxId) {
        int nextId = p.n;
        String[] newick = new String[p.n];
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < p.n; ++i) {
            newick[i] = p.ids == null ? Integer.toString(i) : Integer.toString(p.ids[i]);
            nodes.put(Integer.parseInt(newick[i]), new Node(Integer.parseInt(newick[i])));
        }
        nextId = maxId + 1;
        double[] sum = new double[p.n];
        for (int k = 0; k < p.n; ++k) {
            int x;
            sum[k] = 0.0;
            for (x = 0; x < k; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[k][x];
            }
            for (x = k + 1; x < p.n; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[x][k];
            }
        }
        class ClosestPair {
            public int j;
            public double d;

            ClosestPair() {
            }
        }
        ClosestPair[] C = new ClosestPair[p.n + 1];
        int c = p.n;
        for (int i = 0; i < p.n; ++i) {
            double s;
            int j;
            C[i] = new ClosestPair();
            C[i].d = Double.MAX_VALUE;
            for (j = 0; j < i; ++j) {
                s = p.M[i][j] - (sum[i] + sum[j]) / (double)(p.n - 2);
                if (!(s < C[i].d)) continue;
                C[i].d = s;
                C[i].j = j;
            }
            for (j = i + 1; j < p.n; ++j) {
                s = p.M[j][i] - (sum[i] + sum[j]) / (double)(p.n - 2);
                if (!(s < C[i].d)) continue;
                C[i].d = s;
                C[i].j = j;
            }
        }
        while (p.n > 3) {
            int k;
            int jmin;
            int imin;
            int cmin = 0;
            for (int i = 1; i < c; ++i) {
                if (!(C[i].d < C[cmin].d)) continue;
                cmin = i;
            }
            if (cmin > C[cmin].j) {
                imin = cmin;
                jmin = C[cmin].j;
            } else {
                imin = C[cmin].j;
                jmin = cmin;
            }
            double lik = 0.5 * (p.M[imin][jmin] + (sum[imin] - sum[jmin]) / (double)(p.n - 2));
            double ljk = p.M[imin][jmin] - lik;
            String oldvalue = newick[jmin];
            newick[jmin] = "(" + newick[imin] + ":" + new Formatter().format(Locale.US, "%.2f", lik).toString() + "," + newick[jmin] + ":" + new Formatter().format(Locale.US, "%.2f", ljk).toString() + ")" + Integer.toString(nextId);
            int id = nextId++;
            Node node = new Node(id);
            node.distance.add(Math.abs(lik));
            node.distance.add(Math.abs(ljk));
            if (newick[imin].lastIndexOf(")") != -1) {
                node.children.add(nodes.get(Integer.parseInt(newick[imin].substring(newick[imin].lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin])));
            }
            if (oldvalue.lastIndexOf(")") != -1) {
                node.children.add(nodes.get(Integer.parseInt(oldvalue.substring(oldvalue.lastIndexOf(")") + 1))));
            } else {
                node.children.add(nodes.get(Integer.parseInt(oldvalue)));
            }
            nodes.put(id, node);
            sum[jmin] = 0.0;
            for (k = 0; k < jmin; ++k) {
                if (k == imin) continue;
                int n = k;
                sum[n] = sum[n] - p.M[jmin][k];
                p.M[jmin][k] = (p.M[jmin][k] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                int n2 = k;
                sum[n2] = sum[n2] + p.M[jmin][k];
                int n3 = jmin;
                sum[n3] = sum[n3] + p.M[jmin][k];
            }
            for (k = jmin + 1; k < p.n; ++k) {
                if (k == imin) continue;
                int n = k;
                sum[n] = sum[n] - p.M[k][jmin];
                p.M[k][jmin] = (p.M[k][jmin] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                int n4 = k;
                sum[n4] = sum[n4] + p.M[k][jmin];
                int n5 = jmin;
                sum[n5] = sum[n5] + p.M[k][jmin];
            }
            int n = jmin;
            sum[n] = sum[n] + p.M[imin][jmin];
            for (k = 0; k < imin; ++k) {
                int n6 = k;
                sum[n6] = sum[n6] - p.M[imin][k];
                p.M[imin][k] = p.M[p.n - 1][k];
            }
            for (k = imin + 1; k < p.n - 1; ++k) {
                int n7 = k;
                sum[n7] = sum[n7] - p.M[k][imin];
                p.M[k][imin] = p.M[p.n - 1][k];
            }
            newick[imin] = newick[p.n - 1];
            sum[imin] = sum[p.n - 1] - p.M[p.n - 1][imin];
            --p.n;
            ClosestPair a = C[imin];
            C[imin] = C[--c];
            C[c] = a;
            for (int i = 0; i < c; ++i) {
                if (i == jmin || C[i].j == imin || C[i].j == jmin) {
                    double s;
                    int j;
                    C[i].d = Double.MAX_VALUE;
                    for (j = 0; j < i; ++j) {
                        s = p.M[i][j] - (sum[i] + sum[j]) / (double)(p.n - 2);
                        if (!(s < C[i].d)) continue;
                        C[i].d = s;
                        C[i].j = j;
                    }
                    for (j = i + 1; j < p.n; ++j) {
                        s = p.M[j][i] - (sum[i] + sum[j]) / (double)(p.n - 2);
                        if (!(s < C[i].d)) continue;
                        C[i].d = s;
                        C[i].j = j;
                    }
                    continue;
                }
                if (C[i].j != p.n) continue;
                C[i].j = imin;
            }
        }
        double x = (p.M[1][0] + p.M[2][0] - p.M[2][1]) / 2.0;
        double y = (p.M[1][0] + p.M[2][1] - p.M[2][0]) / 2.0;
        double z = (p.M[2][0] + p.M[2][1] - p.M[1][0]) / 2.0;
        int id = nextId;
        Node node = new Node(id);
        node.distance.add(x);
        node.distance.add(y);
        node.distance.add(z);
        if (newick[0].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0].substring(newick[0].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[0])));
        }
        if (newick[1].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1].substring(newick[1].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[1])));
        }
        if (newick[2].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2].substring(newick[2].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[2])));
        }
        nodes.put(id, node);
        return nodes;
    }

    public static HashMap<Integer, Node> rapidNJ(PexMatrix p, int maxId) {
        Node node;
        int id;
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        int nextId = p.n;
        if (p.n < 3) {
            System.out.println("");
        }
        double[][] E = new double[2 * p.n - 3][];
        for (int i = 0; i < p.n; ++i) {
            E[i] = p.M[i];
        }
        p.M = E;
        String[] newick = new String[2 * p.n - 3];
        for (int i = 0; i < p.n; ++i) {
            newick[i] = p.ids == null ? Integer.toString(i) : Integer.toString(p.ids[i]);
            nodes.put(Integer.parseInt(newick[i]), new Node(Integer.parseInt(newick[i])));
        }
        nextId = maxId + 1;
        double[][] S = new double[2 * p.n - 3][];
        int[][] I = new int[2 * p.n - 3][];
        for (int i = 0; i < p.n; ++i) {
            S[i] = new double[i + 1];
            I[i] = new int[i + 1];
            for (int j = 0; j < i; ++j) {
                S[i][j] = p.M[i][j];
            }
            Sort.qsort(S[i], I[i], 0, i);
        }
        double[] sum = new double[2 * p.n - 3];
        double smax = Double.MIN_VALUE;
        for (int k = 0; k < p.n; ++k) {
            int x;
            sum[k] = 0.0;
            for (x = 0; x < k; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[k][x];
            }
            for (x = k + 1; x < p.n; ++x) {
                int n = k;
                sum[n] = sum[n] + p.M[x][k];
            }
            if (!(sum[k] > smax)) continue;
            smax = sum[k];
        }
        int l = p.n;
        while (p.n > 3) {
            int k;
            double smin = Double.MAX_VALUE;
            int imin = 0;
            int jmin = 0;
            block8: for (int i = l - 1; i >= 0; --i) {
                if (p.M[i] == null) continue;
                for (int j = 0; j < i; ++j) {
                    if (p.M[I[i][j]] == null) continue;
                    if (!(S[i][j] < Double.MAX_VALUE) || !(S[i][j] - (sum[i] + smax) / (double)(p.n - 2) < smin)) continue block8;
                    double s = S[i][j] - (sum[i] + sum[I[i][j]]) / (double)(p.n - 2);
                    if (!(s < smin)) continue;
                    smin = s;
                    imin = i;
                    jmin = I[i][j];
                }
            }
            double lik = 0.5 * (p.M[imin][jmin] + (sum[imin] - sum[jmin]) / (double)(p.n - 2));
            double ljk = p.M[imin][jmin] - lik;
            newick[l] = "(" + newick[imin] + ":" + new Formatter().format(Locale.US, "%.2f", lik).toString() + "," + newick[jmin] + ":" + new Formatter().format(Locale.US, "%.2f", ljk).toString() + ")" + Integer.toString(nextId);
            id = nextId++;
            node = new Node(id);
            node.distance.add(lik);
            node.distance.add(ljk);
            if (newick[imin].lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin].substring(newick[imin].lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[imin])));
            }
            if (newick[jmin].lastIndexOf(")") != -1) {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[jmin].substring(newick[jmin].lastIndexOf(")") + 1))));
            } else {
                node.children.add((Node)nodes.get(Integer.parseInt(newick[jmin])));
            }
            nodes.put(id, node);
            newick[jmin] = null;
            newick[imin] = null;
            sum[l] = 0.0;
            p.M[l] = new double[l + 1];
            S[l] = new double[l + 1];
            I[l] = new int[l + 1];
            for (k = 0; k < jmin; ++k) {
                if (k != imin && p.M[k] != null) {
                    int n = k;
                    sum[n] = sum[n] - p.M[jmin][k];
                    p.M[l][k] = (p.M[jmin][k] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                    S[l][k] = p.M[l][k];
                    int n2 = l;
                    sum[n2] = sum[n2] + p.M[l][k];
                    int n3 = k;
                    sum[n3] = sum[n3] + p.M[l][k];
                    continue;
                }
                S[l][k] = Double.MAX_VALUE;
            }
            for (k = jmin + 1; k < l; ++k) {
                if (k != imin && p.M[k] != null) {
                    int n = k;
                    sum[n] = sum[n] - p.M[k][jmin];
                    p.M[l][k] = (p.M[k][jmin] + (k < imin ? p.M[imin][k] : p.M[k][imin]) - p.M[imin][jmin]) / 2.0;
                    S[l][k] = p.M[l][k];
                    int n4 = l;
                    sum[n4] = sum[n4] + p.M[l][k];
                    int n5 = k;
                    sum[n5] = sum[n5] + p.M[l][k];
                    continue;
                }
                S[l][k] = Double.MAX_VALUE;
            }
            for (k = 0; k < imin; ++k) {
                if (k == jmin || p.M[k] == null) continue;
                int n = k;
                sum[n] = sum[n] - p.M[imin][k];
            }
            for (k = imin + 1; k < l; ++k) {
                if (k == jmin || p.M[k] == null) continue;
                int n = k;
                sum[n] = sum[n] - p.M[k][imin];
            }
            Sort.qsort(S[l], I[l], 0, l);
            p.M[jmin] = null;
            p.M[imin] = null;
            S[jmin] = null;
            S[imin] = null;
            I[jmin] = null;
            I[imin] = null;
            smax = Double.MIN_VALUE;
            for (k = 0; k < l; ++k) {
                if (p.M[k] == null || !(sum[k] > smax)) continue;
                smax = sum[k];
            }
            --p.n;
            ++l;
        }
        int a = 0;
        while (true) {
            if (p.M[a] != null) break;
            ++a;
        }
        int i = a++;
        while (true) {
            if (p.M[a] != null) break;
            ++a;
        }
        int j = a++;
        while (true) {
            if (p.M[a] != null) break;
            ++a;
        }
        int k = a;
        double x = (p.M[j][i] + p.M[k][i] - p.M[k][j]) / 2.0;
        double y = (p.M[j][i] + p.M[k][j] - p.M[k][i]) / 2.0;
        double z = (p.M[k][i] + p.M[k][j] - p.M[j][i]) / 2.0;
        id = nextId;
        node = new Node(id);
        node.distance.add(x);
        node.distance.add(y);
        node.distance.add(z);
        if (newick[i].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[i].substring(newick[i].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[i])));
        }
        if (newick[j].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[j].substring(newick[j].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[j])));
        }
        if (newick[k].lastIndexOf(")") != -1) {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[k].substring(newick[k].lastIndexOf(")") + 1))));
        } else {
            node.children.add((Node)nodes.get(Integer.parseInt(newick[k])));
        }
        nodes.put(id, node);
        return nodes;
    }

    public SimpleTree createTree(HashMap<Integer, Node> nodes, int n, int[] ids, String[] labels, float[] cdatas, boolean createSingleRoot) {
        SimpleTree tree = new SimpleTree();
        tree.setType(this.type.toString());
        int maxId = Integer.MIN_VALUE;
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        HashMap<Integer, Float> classMap = new HashMap<Integer, Float>();
        for (int i = 0; i < n; ++i) {
            ContentSimpleTree ct = new ContentSimpleTree(ids[i]);
            ct.setKlass(cdatas[i]);
            tree.addNode(ct);
            labelMap.put(ids[i], labels[i]);
            classMap.put(ids[i], Float.valueOf(cdatas[i]));
        }
        tree.setClassMap(classMap);
        tree.setLabelMap(labelMap);
        if (n > 1) {
            int i;
            ArrayList<Integer> virtualLabels = new ArrayList<Integer>();
            for (Map.Entry entry : nodes.entrySet()) {
                Integer id = (Integer)entry.getKey();
                Node node2 = (Node)entry.getValue();
                if (node2.children.isEmpty()) continue;
                virtualLabels.add(id);
                if (id <= maxId) continue;
                maxId = id;
            }
            Collections.sort(virtualLabels);
            for (i = 0; i < virtualLabels.size(); ++i) {
                Node node = nodes.get(virtualLabels.get(i));
                if (node == null) continue;
                if (createSingleRoot && node.children.size() > 2) {
                    Node newRoot = new Node(node.id + 1);
                    newRoot.children.add(node);
                    newRoot.distance.add(100.0);
                    newRoot.children.add(node.children.get(node.children.size() - 1));
                    newRoot.distance.add(node.distance.get(node.distance.size() - 1));
                    node.children.remove(node.children.size() - 1);
                    node.distance.remove(node.distance.size() - 1);
                    nodes.put(newRoot.id, newRoot);
                    virtualLabels.add(newRoot.id);
                }
                ContentSimpleTree ct = new ContentSimpleTree((Integer)virtualLabels.get(i));
                ct.setValid(false);
                tree.addNode(ct);
            }
            System.gc();
            for (i = 0; i < tree.getSize(); ++i) {
                Node node = nodes.get(tree.getNode(i).getId());
                if (node == null) continue;
                int maxNivel = -1;
                for (int j = 0; j < node.children.size(); ++j) {
                    ContentSimpleTree son = tree.getNodeById(node.children.get((int)j).id);
                    if (son == null) continue;
                    son.setParent(tree.getNode(i).getId());
                    if (son.getLevel() > maxNivel) {
                        maxNivel = son.getLevel();
                    }
                    tree.getNode(i).setChildrenId(j, son.getId());
                    tree.getNode(i).setDistChildren(j, node.distance.get(j).floatValue());
                }
                if (maxNivel == -1) continue;
                tree.getNode(i).setLevel(maxNivel + 1);
            }
            nodes = null;
            if (this.promotion) {
                PackageNJ.promoteLeafs(tree);
            }
            tree.generateEdges();
        }
        return tree;
    }

    public SimpleTree execute(DistanceMatrix dmat, boolean createSingleRoot, int maxId) {
        PexMatrix pexMatrix = DistanceMatrixReader.loadPex(dmat);
        dmat = null;
        if (pexMatrix != null) {
            return this.constructTree(pexMatrix, createSingleRoot, maxId);
        }
        return null;
    }

    public SimpleTree execute(AbstractMatrix matrix, AbstractDissimilarity diss, boolean createSingleRoot, int maxId) {
        PexMatrix pexMatrix = DistanceMatrixReader.loadPex(matrix, diss);
        if (pexMatrix != null) {
            return this.constructTree(pexMatrix, createSingleRoot, maxId);
        }
        return null;
    }

    public SimpleTree execute(String dmatFile, int maxId) throws IOException, ParseException {
        PexMatrix pexMatrix = DistanceMatrixReader.loadPex(dmatFile);
        dmatFile = null;
        if (pexMatrix != null) {
            return this.constructTree(pexMatrix, false, maxId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleTree constructTree(PexMatrix pexMatrix, boolean createSingleRoot, int maxId) {
        SimpleTree tree = null;
        HashMap<Object, Object> nodes = null;
        long linit = System.currentTimeMillis();
        int elementsCount = pexMatrix.n;
        try {
            if (maxId == 0) {
                for (int k = 0; k < pexMatrix.n; ++k) {
                    int currentId;
                    int n = currentId = pexMatrix.ids == null ? k : pexMatrix.ids[k];
                    if (currentId <= maxId) continue;
                    maxId = currentId;
                }
            }
            if (elementsCount < 3) {
                nodes = new HashMap();
                for (int i = 0; i < elementsCount; ++i) {
                    nodes.put(pexMatrix.ids[i], new Node(pexMatrix.ids[i]));
                }
                if (elementsCount == 2) {
                    Node rootNode = new Node(maxId + 1);
                    ++maxId;
                    for (Map.Entry<Object, Object> e : nodes.entrySet()) {
                        rootNode.children.add((Node)e.getValue());
                        rootNode.distance.add(pexMatrix.getDistance(0, 1));
                    }
                    nodes.put(rootNode.id, rootNode);
                }
            } else if (this.type.equals((Object)NJAlgorithmType.ORIGINAL)) {
                nodes = PackageNJ.originalNJ(pexMatrix, maxId);
            } else if (this.type.equals((Object)NJAlgorithmType.FAST)) {
                nodes = PackageNJ.fastNJ(pexMatrix, maxId);
            } else if (this.type.equals((Object)NJAlgorithmType.RAPID)) {
                nodes = PackageNJ.rapidNJ(pexMatrix, maxId);
            } else {
                JOptionPane.showMessageDialog(null, "NINJA option is disabled. Please use NINJA Tree component.");
            }
            if (nodes != null) {
                long diff;
                long lend = System.currentTimeMillis();
                long total = diff = lend - linit;
                linit = System.currentTimeMillis();
                pexMatrix.M = null;
                tree = this.createTree(nodes, elementsCount, pexMatrix.ids, pexMatrix.labels, pexMatrix.classes, createSingleRoot);
                lend = System.currentTimeMillis();
                diff = lend - linit;
                total += diff;
            }
            JOptionPane.showMessageDialog(null, "Error collecting tree nodes!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return tree;
        }
    }

    public static void promoteLeafs(SimpleTree t) {
        if (t == null) {
            return;
        }
        ContentSimpleTree virtualNode = null;
        ContentSimpleTree parentVirtualNode = null;
        ContentSimpleTree childrenParentVirtualNode = null;
        long linit = System.currentTimeMillis();
        block0: for (int i = 0; i < t.getSize(); ++i) {
            if (t.getNode(i).isValid() || t.getNode(i).getId() == t.getRootId()) continue;
            virtualNode = t.getNode(i);
            if (virtualNode.getId() == 270) {
                System.out.println("");
            }
            if ((parentVirtualNode = t.getNodeById(virtualNode.getParent())) == null || !parentVirtualNode.hasChildren()) continue;
            for (int j = 0; j < parentVirtualNode.getNumChildren(); ++j) {
                if (parentVirtualNode.getChildrenId(j) == virtualNode.getId() || (childrenParentVirtualNode = t.getNodeById(parentVirtualNode.getChildrenId(j))) == null || !childrenParentVirtualNode.isValid() || childrenParentVirtualNode.hasChildren()) continue;
                if (virtualNode.hasChildren()) {
                    for (int k = 0; k < virtualNode.getNumChildren(); ++k) {
                        if (t.getNodeById(virtualNode.getChildrenId(k)) == null) continue;
                        t.getNodeById(virtualNode.getChildrenId(k)).setParent(childrenParentVirtualNode.getId());
                        float d = virtualNode.getDistChildren(k) + parentVirtualNode.getDistChildren(parentVirtualNode.getChildrenIndex(virtualNode.getId())) / 2.0f + parentVirtualNode.getDistChildren(parentVirtualNode.getChildrenIndex(childrenParentVirtualNode.getId())) / 4.0f;
                        if (childrenParentVirtualNode.getChildrenId(0) == -1) {
                            childrenParentVirtualNode.setChildrenId(0, virtualNode.getChildrenId(k));
                            childrenParentVirtualNode.setDistChildren(0, d);
                            continue;
                        }
                        childrenParentVirtualNode.setChildrenId(1, virtualNode.getChildrenId(k));
                        childrenParentVirtualNode.setDistChildren(1, d);
                    }
                }
                childrenParentVirtualNode.setParent(parentVirtualNode.getParent());
                childrenParentVirtualNode.setLevel(parentVirtualNode.getLevel());
                if (parentVirtualNode.getParent() != -1 && t.getNodeById(parentVirtualNode.getParent()) != null && t.getNodeById(parentVirtualNode.getParent()).hasChildren()) {
                    if (t.getNodeById(parentVirtualNode.getParent()) != null && t.getNodeById(t.getNodeById(parentVirtualNode.getParent()).getParent()) != null && t.getNodeById(parentVirtualNode.getParent()).getParent() == parentVirtualNode.getId()) {
                        t.getNodeById(childrenParentVirtualNode.getParent()).setParent(childrenParentVirtualNode.getId());
                        if (t.getNodeById(parentVirtualNode.getParent()).getLevel() > childrenParentVirtualNode.getLevel()) {
                            childrenParentVirtualNode.setLevel(t.getNodeById(parentVirtualNode.getParent()).getLevel());
                        } else if (t.getNodeById(childrenParentVirtualNode.getParent()) != null) {
                            t.getNodeById(childrenParentVirtualNode.getParent()).setLevel(childrenParentVirtualNode.getLevel());
                        }
                    } else {
                        int index;
                        float dp = 0.0f;
                        if (t.getNodeById(parentVirtualNode.getParent()) != null) {
                            int ind = t.getNodeById(parentVirtualNode.getParent()).getChildrenIndex(parentVirtualNode.getId());
                            float k = t.getNodeById(parentVirtualNode.getParent()).getDistChildren(ind);
                            float b = parentVirtualNode.getDistChildren(parentVirtualNode.getChildrenIndex(virtualNode.getId()));
                            float a = parentVirtualNode.getDistChildren(parentVirtualNode.getChildrenIndex(childrenParentVirtualNode.getId()));
                            dp = k + b / 2.0f + a / 2.0f;
                        }
                        if (t.getNodeById(parentVirtualNode.getParent()) != null && (index = t.getNodeById(parentVirtualNode.getParent()).getChildrenIndex(parentVirtualNode.getId())) != -1) {
                            t.getNodeById(parentVirtualNode.getParent()).setChildrenId(index, childrenParentVirtualNode.getId());
                            t.getNodeById(parentVirtualNode.getParent()).setDistChildren(index, dp);
                        }
                    }
                }
                parentVirtualNode.setParent(-1);
                virtualNode.setParent(-1);
                if (parentVirtualNode.getNumChildren() == 3) {
                    for (int x = 0; x < parentVirtualNode.getNumChildren(); ++x) {
                        if (parentVirtualNode.getChildrenId(x) == childrenParentVirtualNode.getId() || parentVirtualNode.getChildrenId(x) == virtualNode.getId()) continue;
                        childrenParentVirtualNode.setParent(parentVirtualNode.getChildrenId(x));
                        if (t.getNodeById(parentVirtualNode.getChildrenId(x)) != null) {
                            t.getNodeById(parentVirtualNode.getChildrenId(x)).setParent(childrenParentVirtualNode.getId());
                            t.getNodeById(parentVirtualNode.getChildrenId(x)).setLevel(parentVirtualNode.getLevel());
                        }
                        childrenParentVirtualNode.setLevel(parentVirtualNode.getLevel());
                    }
                }
                t.removeNode(parentVirtualNode);
                t.removeNode(virtualNode);
                virtualNode = null;
                --i;
                continue block0;
            }
        }
        long lend = System.currentTimeMillis();
        long diff = lend - linit;
        System.out.println("Time spent (Leaf promotion) -> " + (float)diff / 1000.0f + " seconds");
    }

    public static enum NJAlgorithmType {
        ORIGINAL("Original Neighbor-Joining"),
        FAST("Fast Neighbor-Joining"),
        RAPID("Rapid Neighbor-Joining");

        private final String name;

        private NJAlgorithmType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

