/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.packagenj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import simpletree.distance.DistanceMatrix;
import simpletree.layout.radial.RadialLayoutComp;
import simpletree.model.SimpleTreeModel;
import simpletree.model.SimpleTreeModelComp;
import simpletree.technique.packagenj.PackageNJConnectionComp;
import simpletree.technique.packagenj.PackageNJConnectionSetBuilderParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Technique", name="Neighbor-Joinning Algorithms Set Builder", description="Builds several NJs, for each distance matrix provided.")
public class PackageNJConnectionSetBuilderComp
extends PackageNJConnectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient PackageNJConnectionSetBuilderParamView paramview;
    private transient ArrayList<SimpleTreeModel> models;
    private transient HashMap<String, DistanceMatrix> dmats;
    private transient String collection;

    @Override
    public void execute() throws IOException {
        if (this.dmats == null || this.dmats.isEmpty()) {
            throw new IOException("A distance matrix set should be provided.");
        }
        PackageNJConnectionComp njc = new PackageNJConnectionComp();
        njc.setPnj(this.isPnj());
        njc.setNjAlgorithmType(this.getNjAlgorithmType());
        SimpleTreeModelComp tmc = new SimpleTreeModelComp();
        tmc.setCollection(this.collection);
        RadialLayoutComp radialc = new RadialLayoutComp();
        this.models = new ArrayList();
        for (int i = 0; i < this.dmats.size(); ++i) {
            this.models.add(null);
        }
        Iterator<Map.Entry<String, DistanceMatrix>> it = this.dmats.entrySet().iterator();
        String chave = "";
        DistanceMatrix dm = null;
        while (it.hasNext()) {
            Map.Entry<String, DistanceMatrix> e = it.next();
            chave = e.getKey();
            dm = e.getValue();
            njc.input(dm);
            njc.execute();
            tmc.input(njc.output());
            tmc.execute();
            radialc.input(tmc.output());
            radialc.execute();
            SimpleTreeModel m = radialc.output();
            int pos = Integer.parseInt(chave.substring(0, chave.indexOf("-")).trim());
            this.models.set(pos, m);
        }
    }

    public void input(@Param(name="distance matrices") HashMap<String, DistanceMatrix> dmats) {
        this.dmats = dmats;
    }

    public void attach(@Param(name="distance matrix") DistanceMatrix dmat) {
        if (this.dmats == null) {
            this.dmats = new HashMap();
        }
        if (this.dmats != null) {
            this.dmats.put(Integer.toString(this.dmats.size()) + "-Dmat " + Integer.toString(this.dmats.size()), dmat);
        }
    }

    public ArrayList<SimpleTreeModel> outputModels() {
        return this.models;
    }

    @Override
    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new PackageNJConnectionSetBuilderParamView(this);
        }
        return this.paramview;
    }

    @Override
    public void reset() {
        this.dmats = null;
    }

    public void setCollection(String c) {
        this.collection = c;
    }

    public String getCollection() {
        return this.collection;
    }
}

