/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates;

import java.io.IOException;
import simpletree.coordination.IdentityCoordinatorComp;
import simpletree.datamining.normalization.NormalizationComp;
import simpletree.datamining.normalization.NormalizationFactory;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.reader.MatrixReaderComp;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.idmap.IDMAPProjection;
import simpletree.projection.technique.idmap.IDMAPProjectionComp;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModelComp;
import simpletree.technique.parallelcoordinates.model.view.ParallelCoordinatesFrameComp;
import simpletree.view.ProjectionFrameComp;

public class Main {
    public static void main(String[] args) throws IOException {
        IdentityCoordinatorComp coord = new IdentityCoordinatorComp();
        coord.execute();
        String filename = "D:\\test.data";
        MatrixReaderComp mrc = new MatrixReaderComp();
        mrc.setFilename(filename);
        mrc.execute();
        AbstractMatrix data = mrc.output();
        ParallelCoordinatesModelComp pcmodel = new ParallelCoordinatesModelComp();
        pcmodel.input(data);
        pcmodel.execute();
        ParallelCoordinatesFrameComp pcframe = new ParallelCoordinatesFrameComp();
        pcframe.setTitle(filename);
        pcframe.input(pcmodel.output());
        pcframe.attach(coord.output());
        pcframe.execute();
        NormalizationComp norm = new NormalizationComp();
        norm.setNormalizationType(NormalizationFactory.NormalizationType.NORMALIZE_COLUMNS);
        norm.input(data);
        norm.execute();
        data = norm.output();
        IDMAPProjectionComp idmap = new IDMAPProjectionComp();
        idmap.setDissimilarityType(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        idmap.setFractionDelta(8.0f);
        idmap.setInitialization(IDMAPProjection.InitializationType.FASTMAP);
        idmap.setNumberIterations(100);
        idmap.input(data);
        idmap.execute();
        ProjectionModelComp pmodel = new ProjectionModelComp();
        pmodel.input(idmap.output());
        pmodel.execute();
        ProjectionFrameComp pframe = new ProjectionFrameComp();
        pframe.setTitle(filename);
        pframe.input(pmodel.output());
        pframe.attach(coord.output());
        pframe.execute();
    }
}

