/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates.model;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.matrix.AbstractMatrix;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModel;
import simpletree.technique.parallelcoordinates.model.PolylineInstance;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Parallel Coordinates.Basics", name="Parallel Coordinates Model", description="Create a parallel coordinates model to be visualized.")
public class ParallelCoordinatesModelComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient ParallelCoordinatesModel model;
    private transient AbstractMatrix data;

    public void execute() throws IOException {
        if (this.data != null) {
            ArrayList<String> attributes = this.data.getAttributes();
            ArrayList<String> labels = this.data.getLabels();
            this.model = new ParallelCoordinatesModel(attributes);
            for (int i = 0; i < this.data.getRowCount(); ++i) {
                PolylineInstance pi;
                if (labels.size() > 0) {
                    pi = new PolylineInstance(this.data.getRow(i), labels.get(i));
                    this.model.addInstance(pi);
                    continue;
                }
                pi = new PolylineInstance(this.data.getRow(i));
                this.model.addInstance(pi);
            }
        } else {
            throw new IOException("A multidimensional data matrix should be provided.");
        }
    }

    public void input(@Param(name="multidimensional data") AbstractMatrix data) {
        this.data = data;
    }

    public ParallelCoordinatesModel output() {
        return this.model;
    }

    public AbstractParametersView getParametersEditor() {
        return null;
    }

    public void reset() {
        this.data = null;
        this.model = null;
    }
}

