/*
 * Decompiled with CFR 0.152.
 */
package simpletree.technique.parallelcoordinates.model.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simpletree.coordination.AbstractCoordinator;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModel;
import simpletree.technique.parallelcoordinates.model.PolylineInstance;
import simpletree.technique.parallelcoordinates.model.view.ParallelCoordinatesFrameOptions;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.PNGFilter;
import simpletree.view.JFrameModelViewer;
import simpletree.view.ProjectionFrame;
import simpletree.view.selection.AbstractSelection;
import simpletree.view.selection.InstanceSelection;
import simpletree.view.selection.coordination.CoordinationSelectionFactory;

public class ParallelCoordinatesFrame
extends JFrameModelViewer {
    private boolean highqualityrender = true;
    private ViewPanel view = new ViewPanel();
    private JSlider alphaSlider;
    private JPanel bottomPanel;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JLabel hLabel;
    private JButton hzoominButton;
    private JButton hzoomoutButton;
    private JToolBar mainToolBar;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JButton optionsButton;
    private JMenuItem savePngMenuItem;
    private ButtonGroup selectionButtonGroup;
    private JToolBar selectionToolBar;
    private JButton silhouetteButton;
    private JMenuItem toolOptionsMenuItem;
    private JToolBar toolsToolBar;
    private JLabel vLabel;
    private JScrollPane viewScrollPane;
    private JButton vzoominButton;
    private JButton vzoomoutButton;

    public ParallelCoordinatesFrame() {
        this.initComponents();
        this.addSelection(new InstanceSelection(this));
    }

    private void initComponents() {
        this.selectionButtonGroup = new ButtonGroup();
        this.viewScrollPane = new JScrollPane(this.view);
        this.mainToolBar = new JToolBar();
        this.hLabel = new JLabel();
        this.hzoominButton = new JButton();
        this.hzoomoutButton = new JButton();
        this.vLabel = new JLabel();
        this.vzoominButton = new JButton();
        this.vzoomoutButton = new JButton();
        this.toolsToolBar = new JToolBar();
        this.silhouetteButton = new JButton();
        this.optionsButton = new JButton();
        this.bottomPanel = new JPanel();
        this.alphaSlider = new JSlider();
        this.selectionToolBar = new JToolBar();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.savePngMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.toolOptionsMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.viewScrollPane, "Center");
        this.mainToolBar.setRollover(true);
        this.hLabel.setText("Horizontal ");
        this.mainToolBar.add(this.hLabel);
        this.hzoominButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        this.hzoominButton.setFocusable(false);
        this.hzoominButton.setHorizontalTextPosition(0);
        this.hzoominButton.setVerticalTextPosition(3);
        this.hzoominButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.hzoominButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.hzoominButton);
        this.hzoomoutButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        this.hzoomoutButton.setFocusable(false);
        this.hzoomoutButton.setHorizontalTextPosition(0);
        this.hzoomoutButton.setVerticalTextPosition(3);
        this.hzoomoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.hzoomoutButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.hzoomoutButton);
        this.vLabel.setText("   Vertical ");
        this.mainToolBar.add(this.vLabel);
        this.vzoominButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        this.vzoominButton.setFocusable(false);
        this.vzoominButton.setHorizontalTextPosition(0);
        this.vzoominButton.setVerticalTextPosition(3);
        this.vzoominButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.vzoominButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.vzoominButton);
        this.vzoomoutButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        this.vzoomoutButton.setFocusable(false);
        this.vzoomoutButton.setHorizontalTextPosition(0);
        this.vzoomoutButton.setVerticalTextPosition(3);
        this.vzoomoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.vzoomoutButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.vzoomoutButton);
        this.toolsToolBar.setRollover(true);
        this.silhouetteButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Information16.gif")));
        this.silhouetteButton.setToolTipText("Calculate Silhouette");
        this.silhouetteButton.setFocusable(false);
        this.silhouetteButton.setHorizontalTextPosition(0);
        this.silhouetteButton.setVerticalTextPosition(3);
        this.silhouetteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.silhouetteButtonActionPerformed(evt);
            }
        });
        this.toolsToolBar.add(this.silhouetteButton);
        this.optionsButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.optionsButton.setFocusable(false);
        this.optionsButton.setHorizontalTextPosition(0);
        this.optionsButton.setVerticalTextPosition(3);
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.optionsButtonActionPerformed(evt);
            }
        });
        this.toolsToolBar.add(this.optionsButton);
        this.mainToolBar.add(this.toolsToolBar);
        this.getContentPane().add((Component)this.mainToolBar, "North");
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.alphaSlider.setValue(100);
        this.alphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ParallelCoordinatesFrame.this.alphaSliderStateChanged(evt);
            }
        });
        this.bottomPanel.add(this.alphaSlider);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.selectionToolBar.setOrientation(1);
        this.selectionToolBar.setRollover(true);
        this.getContentPane().add((Component)this.selectionToolBar, "East");
        this.fileMenu.setText("File");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText("Open File");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.savePngMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.savePngMenuItem.setMnemonic('P');
        this.savePngMenuItem.setText("Export to PNG");
        this.savePngMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.savePngMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.savePngMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.toolOptionsMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.toolOptionsMenuItem.setText("Tool Options");
        this.toolOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParallelCoordinatesFrame.this.toolOptionsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.toolOptionsMenuItem);
        this.menuBar.add(this.editMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void hzoomoutButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.horizontalZoomout();
        }
    }

    private void hzoominButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.horizontalZoomin();
        }
    }

    private void alphaSliderStateChanged(ChangeEvent evt) {
        if (this.model != null) {
            JSlider slider = (JSlider)evt.getSource();
            ((ParallelCoordinatesModel)this.model).setAlpha((float)Math.pow((float)slider.getValue() / 100.0f, 2.0));
            if (this.view != null) {
                this.updateImage();
            }
        }
    }

    private void vzoominButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.verticalZoomin();
        }
    }

    private void vzoomoutButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.verticalZoomout();
        }
    }

    private void savePngMenuItemActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("parallelcoordinates.properties");
                int result = SaveDialog.showSaveDialog(spm, new PNGFilter(), this, "image.png");
                if (result == 0) {
                    String filename = SaveDialog.getFilename();
                    try {
                        this.view.saveToPngImageFile(filename);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("parallelcoordinates.properties");
            int result = OpenDialog.showOpenDialog(spm, new DATAFilter(), this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                try {
                    AbstractMatrix matrix = MatrixFactory.getInstance(filename);
                    ArrayList<String> labels = matrix.getLabels();
                    ParallelCoordinatesModel newmodel = new ParallelCoordinatesModel(matrix.getAttributes());
                    for (int i = 0; i < matrix.getRowCount(); ++i) {
                        PolylineInstance pi;
                        if (labels.size() > 0) {
                            pi = new PolylineInstance(matrix.getRow(i), labels.get(i));
                            newmodel.addInstance(pi);
                            continue;
                        }
                        pi = new PolylineInstance(matrix.getRow(i));
                        newmodel.addInstance(pi);
                    }
                    this.setModel(newmodel);
                    this.setTitle(filename.substring(filename.lastIndexOf("\\") + 1));
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Problems opening the file", 0);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void silhouetteButtonActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            ((ParallelCoordinatesModel)this.model).calculateSilhouette();
            this.model.notifyObservers();
        }
    }

    private void toolOptionsMenuItemActionPerformed(ActionEvent evt) {
        ParallelCoordinatesFrameOptions.getInstance(this).display(this);
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        this.toolOptionsMenuItemActionPerformed(evt);
    }

    @Override
    public void setModel(AbstractModel model) {
        if (model instanceof ParallelCoordinatesModel && model != null) {
            super.setModel(model);
            this.updateImage();
        }
    }

    public ViewPanel getView() {
        return this.view;
    }

    public boolean isHighQualityRender() {
        return this.highqualityrender;
    }

    public void setHighQualityRender(boolean highqualityrender) {
        this.highqualityrender = highqualityrender;
        this.view.cleanImage();
        this.view.repaint();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.view != null) {
            this.view.cleanImage();
            this.view.repaint();
        }
    }

    @Override
    public void addCoordinator(AbstractCoordinator coordinator) {
        super.addCoordinator(coordinator);
        this.addSelection(CoordinationSelectionFactory.getInstance(coordinator, this));
    }

    public void updateImage() {
        if (this.view != null) {
            this.view.cleanImage();
            this.view.repaint();
        }
    }

    public void addSelection(final AbstractSelection selection) {
        if (selection != null) {
            JToggleButton button = new JToggleButton();
            this.selectionButtonGroup.add(button);
            button.setIcon(selection.getIcon());
            button.setSelected(false);
            button.setToolTipText(selection.toString());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ParallelCoordinatesFrame.this.view != null) {
                        ParallelCoordinatesFrame.this.view.setSelection(selection);
                    }
                }
            });
            this.selectionToolBar.add(button);
        }
    }

    public class ViewPanel
    extends JPanel {
        private String label;
        private Point labelpos;
        private Color selcolor = Color.RED;
        private AbstractSelection selection;
        private Point selsource;
        private Point seltarget;
        private BufferedImage image;

        public ViewPanel() {
            this.setBackground(Color.WHITE);
            this.addMouseMotionListener(new MouseMotionListener());
            this.addMouseListener(new MouseClickedListener());
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (ParallelCoordinatesFrame.this.model != null && this.image == null) {
                ParallelCoordinatesModel pmodel = (ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model;
                this.image = new BufferedImage(pmodel.getSize().width, pmodel.getSize().height, 1);
                this.setSize(this.image.getWidth(), this.image.getHeight());
                this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
                Graphics2D g2Buffer = this.image.createGraphics();
                g2Buffer.setColor(this.getBackground());
                g2Buffer.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
                g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model).draw(this.image, ParallelCoordinatesFrame.this.highqualityrender);
                g2Buffer.dispose();
            }
            if (this.image != null) {
                g2.drawImage((Image)this.image, 0, 0, null);
            }
            if (this.selsource != null && this.seltarget != null) {
                int x = this.selsource.x;
                int width = this.seltarget.x - this.selsource.x;
                int y = this.selsource.y;
                int height = this.seltarget.y - this.selsource.y;
                if (this.selsource.x > this.seltarget.x) {
                    x = this.seltarget.x;
                    width = this.selsource.x - this.seltarget.x;
                }
                if (this.selsource.y > this.seltarget.y) {
                    y = this.seltarget.y;
                    height = this.selsource.y - this.seltarget.y;
                }
                g2.setColor(this.selcolor);
                g2.drawRect(x, y, width, height);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.fillRect(x, y, width, height);
            } else if (this.label != null && this.labelpos != null) {
                g2.setFont(this.getFont());
                FontMetrics metrics = g2.getFontMetrics(g2.getFont());
                int width = metrics.stringWidth(this.label);
                int height = metrics.getAscent();
                g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
                g2.setPaint(Color.WHITE);
                g2.fillRect(this.labelpos.x - 2, this.labelpos.y - height, width + 4, height + 4);
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g2.setColor(Color.DARK_GRAY);
                g2.drawRect(this.labelpos.x - 2, this.labelpos.y - height, width + 4, height + 4);
                g2.drawString(this.label, this.labelpos.x, this.labelpos.y);
            }
        }

        public void setSelection(AbstractSelection selection) {
            this.selection = selection;
        }

        public void horizontalZoomin() {
            if (ParallelCoordinatesFrame.this.model != null) {
                ParallelCoordinatesModel pmodel = (ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model;
                pmodel.setSize(pmodel.getSize().width + 50, pmodel.getSize().height);
                ParallelCoordinatesFrame.this.model.notifyObservers();
            }
        }

        public void horizontalZoomout() {
            if (ParallelCoordinatesFrame.this.model != null) {
                ParallelCoordinatesModel pmodel = (ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model;
                pmodel.setSize(Math.max(50, pmodel.getSize().width - 50), pmodel.getSize().height);
                ParallelCoordinatesFrame.this.model.notifyObservers();
            }
        }

        public void verticalZoomin() {
            if (ParallelCoordinatesFrame.this.model != null) {
                ParallelCoordinatesModel pmodel = (ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model;
                pmodel.setSize(pmodel.getSize().width, pmodel.getSize().height + 50);
                ParallelCoordinatesFrame.this.model.notifyObservers();
            }
        }

        public void verticalZoomout() {
            if (ParallelCoordinatesFrame.this.model != null) {
                ParallelCoordinatesModel pmodel = (ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model;
                pmodel.setSize(pmodel.getSize().width, Math.max(100, pmodel.getSize().height - 50));
                ParallelCoordinatesFrame.this.model.notifyObservers();
            }
        }

        public void cleanImage() {
            this.image = null;
        }

        public void saveToPngImageFile(String filename) throws IOException {
            if (this.image != null) {
                try {
                    BufferedImage buffer = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 1);
                    this.paint(buffer.getGraphics());
                    ImageIO.write((RenderedImage)buffer, "png", new File(filename));
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        public void cleanSelectedInstances() {
            if (ParallelCoordinatesFrame.this.model != null) {
                ParallelCoordinatesFrame.this.model.cleanSelectedInstances();
                ParallelCoordinatesFrame.this.model.notifyObservers();
            }
        }

        public void removeSelectedInstances() {
            if (ParallelCoordinatesFrame.this.model != null) {
                ParallelCoordinatesFrame.this.model.removeSelectedInstances();
                ParallelCoordinatesFrame.this.model.notifyObservers();
            }
        }

        public ArrayList<PolylineInstance> getSelectedInstances(Point source, Point target) {
            ArrayList<PolylineInstance> selinstances = new ArrayList<PolylineInstance>();
            if (ParallelCoordinatesFrame.this.model != null) {
                int x = Math.min(source.x, target.x);
                int width = Math.abs(source.x - target.x);
                int y = Math.min(source.y, target.y);
                int height = Math.abs(source.y - target.y);
                Rectangle rect = new Rectangle(x, y, width, height);
                selinstances = ((ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model).getInstancesByPosition(rect);
            }
            return selinstances;
        }

        class MouseClickedListener
        extends MouseAdapter {
            MouseClickedListener() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                super.mouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                super.mousePressed(evt);
                if (evt.getButton() == 1 && ParallelCoordinatesFrame.this.model != null) {
                    ViewPanel.this.selsource = evt.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ArrayList<PolylineInstance> instances;
                super.mouseReleased(evt);
                if (ParallelCoordinatesFrame.this.model != null && ViewPanel.this.selsource != null && ViewPanel.this.seltarget != null && (instances = ViewPanel.this.getSelectedInstances(ViewPanel.this.selsource, ViewPanel.this.seltarget)) != null && ViewPanel.this.selection != null) {
                    ViewPanel.this.selection.selected(new ArrayList<AbstractInstance>(instances));
                }
                ViewPanel.this.selsource = null;
                ViewPanel.this.seltarget = null;
            }
        }

        class MouseMotionListener
        extends MouseMotionAdapter {
            MouseMotionListener() {
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                super.mouseMoved(evt);
                if (ParallelCoordinatesFrame.this.model != null) {
                    PolylineInstance instance = ((ParallelCoordinatesModel)ParallelCoordinatesFrame.this.model).getInstanceByPosition(evt.getPoint());
                    if (instance != null) {
                        ViewPanel.this.label = instance.toString();
                        if (ViewPanel.this.label.trim().length() > 0) {
                            if (ViewPanel.this.label.length() > 100) {
                                ViewPanel.this.label = ViewPanel.this.label.substring(0, 96) + "...";
                            }
                            ViewPanel.this.labelpos = evt.getPoint();
                            ViewPanel.this.repaint();
                        }
                    } else {
                        ViewPanel.this.label = null;
                        ViewPanel.this.labelpos = null;
                        ViewPanel.this.repaint();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (ViewPanel.this.selsource != null) {
                    ViewPanel.this.seltarget = evt.getPoint();
                }
                ViewPanel.this.repaint();
            }
        }
    }
}

