/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.corpus.database;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.textprocessing.corpus.database.ConnectionManager;
import simpletree.textprocessing.corpus.database.SqlManager;

public class CollectionsManager {
    public static ArrayList<String> getCollections() throws IOException {
        ArrayList<String> collections = new ArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("SELECT.COLLECTIONS");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("name");
                collections.add(name);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CollectionsManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(CollectionsManager.class.getName()).log(Level.SEVERE, null, ex);
                throw new IOException(ex.getMessage());
            }
        }
        return collections;
    }

    public static boolean removeCollection(String name) throws IOException {
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("REMOVE.COLLECTION");
            stmt.setString(1, name);
            rows = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            Logger.getLogger(CollectionsManager.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(CollectionsManager.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
        ConnectionManager.compress();
        return rows > 0;
    }
}

