/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.corpus.folder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import simpletree.model.content.LabelContent;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.processing.Ngram;

public class FolderCorpus
extends Corpus {
    LabelContent labels;

    public FolderCorpus(String url, int nrGrams) {
        super(url, nrGrams);
    }

    public void setLabels(LabelContent labels) {
        this.labels = labels;
    }

    @Override
    public String getFullContent(int id) throws IOException {
        if (this.labels == null) {
            return null;
        }
        String urlName = this.url + File.separator + this.labels.get(id);
        return this.getFullContent(urlName);
    }

    @Override
    public String getFullContent(String itemUrl) throws IOException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(itemUrl));
            StringBuilder text = new StringBuilder();
            while ((line = in.readLine()) != null) {
                text.append(line);
                text.append("\r\n");
            }
            in.close();
            return text.toString();
        }
        catch (IOException e) {
            throw new IOException("File " + itemUrl + " does not exist.");
        }
    }

    @Override
    public String getFilteredContent(int id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public String getViewContent(int id) throws IOException {
        return this.getFullContent(id);
    }

    @Override
    public String getViewContent(String itemUrl) throws IOException {
        return this.getFullContent(itemUrl);
    }

    @Override
    public String getSearchContent(int id) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayList<Ngram> getNgrams(int id) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayList<Ngram> getCorpusNgrams() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void run() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

