/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.matrix.AbstractMatrix;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.PreprocessorParamView;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Text Processing", name="Text Preprocessor", description="Process a set of documents and return a \"documents x terms\" matrix containing the frequency of terms.", howtocite="Salton, G. Developments in automatic text retrieval. Science, v. 253, p. 974-980, 1991.")
public class PreprocessorComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private int lowerCut = 10;
    private int upperCut = -1;
    private int numberGrams = 1;
    private StemmerFactory.StemmerType stemmer = StemmerFactory.StemmerType.ENGLISH;
    private int nrlines = 1;
    private transient AbstractMatrix matrix;
    private transient ArrayList<String> labels;
    private transient PreprocessorParamView paramview;
    private transient Corpus corpus;

    public void execute() throws IOException {
        Preprocessor preproc = new Preprocessor(this.corpus);
        this.matrix = preproc.getMatrix(this.lowerCut, this.upperCut, this.numberGrams, this.stemmer);
        this.labels = new ArrayList();
        for (Integer id : this.corpus.getIds()) {
            String label = this.corpus.getLabel(this.nrlines, id);
            this.labels.add(label);
        }
        this.matrix.setLabels(this.labels);
    }

    public void input(@Param(name="corpus") Corpus corpus) {
        this.corpus = corpus;
        this.numberGrams = corpus.getNumberGrams();
    }

    public AbstractMatrix outputMatrix() {
        return this.matrix;
    }

    public ArrayList<String> outputLabels() {
        return this.labels;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new PreprocessorParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
        this.corpus = null;
    }

    public int getLowerCut() {
        return this.lowerCut;
    }

    public void setLowerCut(int lowerCut) {
        this.lowerCut = lowerCut;
    }

    public int getUpperCut() {
        return this.upperCut;
    }

    public void setUpperCut(int upperCut) {
        this.upperCut = upperCut;
    }

    public int getNumberGrams() {
        return this.numberGrams;
    }

    public void setNumberGrams(int numberGrams) {
        this.numberGrams = numberGrams;
    }

    public StemmerFactory.StemmerType getStemmer() {
        return this.stemmer;
    }

    public void setStemmer(StemmerFactory.StemmerType stemmer) {
        this.stemmer = stemmer;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public int getNumberLines() {
        return this.nrlines;
    }

    public void setNumberLines(int nrlines) {
        this.nrlines = nrlines;
    }
}

