/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.transformation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphicalParaconsistentParameterSetting
extends JDialog {
    private float trueValue = 0.5f;
    private float falseValue = 0.5f;
    private float incValue = 0.5f;
    private float indValue = 0.5f;
    private JPanel QUPC_Panel;
    private JButton close_Button;
    private JSlider false_Slider;
    private JTextField false_Text;
    private JSlider inc_Slider;
    private JTextField inc_Text;
    private JSlider ind_Slider;
    private JTextField ind_Text;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSlider true_Slider;
    private JTextField true_Text;

    public GraphicalParaconsistentParameterSetting(Frame parent) {
        super(parent, true);
        this.initComponents();
    }

    private void initComponents() {
        this.ind_Slider = new JSlider();
        this.ind_Text = new JTextField();
        this.QUPC_Panel = new MyPanel();
        this.false_Slider = new JSlider();
        this.false_Text = new JTextField();
        this.true_Slider = new JSlider();
        this.true_Text = new JTextField();
        this.inc_Slider = new JSlider();
        this.inc_Text = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.close_Button = new JButton();
        this.setDefaultCloseOperation(2);
        this.ind_Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GraphicalParaconsistentParameterSetting.this.ind_SliderStateChanged(evt);
            }
        });
        this.ind_Text.setEditable(false);
        this.QUPC_Panel.setBorder(BorderFactory.createEtchedBorder());
        this.QUPC_Panel.setPreferredSize(new Dimension(220, 220));
        GroupLayout QUPC_PanelLayout = new GroupLayout(this.QUPC_Panel);
        this.QUPC_Panel.setLayout(QUPC_PanelLayout);
        QUPC_PanelLayout.setHorizontalGroup(QUPC_PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 216, Short.MAX_VALUE));
        QUPC_PanelLayout.setVerticalGroup(QUPC_PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 216, Short.MAX_VALUE));
        this.false_Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GraphicalParaconsistentParameterSetting.this.false_SliderStateChanged(evt);
            }
        });
        this.false_Text.setEditable(false);
        this.true_Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GraphicalParaconsistentParameterSetting.this.true_SliderStateChanged(evt);
            }
        });
        this.true_Text.setEditable(false);
        this.inc_Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GraphicalParaconsistentParameterSetting.this.inc_SliderStateChanged(evt);
            }
        });
        this.inc_Text.setEditable(false);
        this.jLabel1.setText("Vscc");
        this.jLabel2.setText("Vicc");
        this.jLabel3.setText("Vscct");
        this.jLabel4.setText("Vicct");
        this.jLabel5.setText("Regions");
        this.close_Button.setText("Close");
        this.close_Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphicalParaconsistentParameterSetting.this.close_ButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.QUPC_Panel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.false_Text, -2, 64, -2).addGap(85, 85, 85).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inc_Text, -2, 64, -2)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ind_Slider, -2, 160, -2).addComponent(this.false_Slider, -2, 168, -2).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ind_Text, -2, 64, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.inc_Slider, -2, 168, -2)).addGroup(layout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.true_Text, -2, 64, -2)).addComponent(this.true_Slider, -2, 168, -2))))).addGroup(layout.createSequentialGroup().addGap(145, 145, 145).addComponent(this.close_Button)).addGroup(layout.createSequentialGroup().addGap(119, 119, 119).addComponent(this.jLabel5))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel5).addGap(6, 6, 6).addComponent(this.QUPC_Panel, -2, -1, -2).addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.false_Text, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.false_Slider, -2, -1, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ind_Text, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ind_Slider, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.inc_Text, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inc_Slider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.true_Text, -2, -1, -2)).addGap(11, 11, 11).addComponent(this.true_Slider, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.close_Button).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public void display(float Vscc, float Vicc, float Vscct, float Vicct) {
        this.trueValue = Vscc;
        this.falseValue = -1.0f * Vicc;
        this.incValue = Vscct;
        this.indValue = -1.0f * Vicct;
        this.true_Slider.setValue((int)(this.trueValue * 100.0f));
        this.true_Text.setText(Float.toString(this.trueValue));
        this.false_Slider.setValue((int)(this.falseValue * 100.0f));
        this.false_Text.setText(Float.toString(-1.0f * this.falseValue));
        this.inc_Slider.setValue((int)(this.incValue * 100.0f));
        this.inc_Text.setText(Float.toString(this.incValue));
        this.ind_Slider.setValue((int)(this.indValue * 100.0f));
        this.ind_Text.setText(Float.toString(-1.0f * this.indValue));
        this.QUPC_Panel.repaint();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void ind_SliderStateChanged(ChangeEvent evt) {
        this.indValue = (float)this.ind_Slider.getValue() / 100.0f;
        this.ind_Text.setText(Float.toString(-1.0f * this.indValue));
        this.QUPC_Panel.repaint();
    }

    private void false_SliderStateChanged(ChangeEvent evt) {
        this.falseValue = (float)this.false_Slider.getValue() / 100.0f;
        this.false_Text.setText(Float.toString(-1.0f * this.falseValue));
        this.QUPC_Panel.repaint();
    }

    private void true_SliderStateChanged(ChangeEvent evt) {
        this.trueValue = (float)this.true_Slider.getValue() / 100.0f;
        this.true_Text.setText(Float.toString(this.trueValue));
        this.QUPC_Panel.repaint();
    }

    private void inc_SliderStateChanged(ChangeEvent evt) {
        this.incValue = (float)this.inc_Slider.getValue() / 100.0f;
        this.inc_Text.setText(Float.toString(this.incValue));
        this.QUPC_Panel.repaint();
    }

    private void close_ButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public float getFalseValue() {
        return -1.0f * this.falseValue;
    }

    public float getIncValue() {
        return this.incValue;
    }

    public float getIndValue() {
        return -1.0f * this.indValue;
    }

    public float getTrueValue() {
        return this.trueValue;
    }

    public class MyPanel
    extends JPanel {
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponents(g);
            this.draw(g);
        }

        public void draw(Graphics g) {
            int pmW;
            int pmH;
            int pmW2;
            int pmH2;
            int pmW3;
            int pmH3;
            int pmW4;
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.getBackground());
            g2.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.BLACK);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int minW = 10;
            int minH = 10;
            int maxW = 210;
            int maxH = 210;
            int distW = maxW - minW;
            int distH = maxH - minH;
            int mW = (int)((float)distW * 0.5f);
            int mH = (int)((float)distH * 0.5f);
            g2.drawLine(minW - 3, maxH, maxW, maxH);
            g2.drawLine(minW, maxH + 3, minW, minH);
            g2.drawLine(maxW, maxH, maxW, minH);
            g2.drawLine(minW, minH, maxW, minH);
            g2.drawLine(minW, mH + minW, maxW, mH + minW);
            g2.drawLine(mW + minW, minH, mW + minW, maxH);
            g2.setPaint(Color.RED);
            Polygon pTrue = new Polygon();
            if ((double)GraphicalParaconsistentParameterSetting.this.trueValue >= 0.5) {
                pTrue.addPoint(maxW, maxH);
                pTrue.addPoint((int)((float)distW * GraphicalParaconsistentParameterSetting.this.trueValue) + minW, maxH);
                pTrue.addPoint(maxW, (int)((float)distH * GraphicalParaconsistentParameterSetting.this.trueValue) + minH);
                pmW4 = (int)(((float)maxW + (float)distW * GraphicalParaconsistentParameterSetting.this.trueValue + (float)minW) / 2.0f);
                pmH3 = (int)((float)(maxH + (int)((float)distH * GraphicalParaconsistentParameterSetting.this.trueValue) + minH) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW4, pmH3);
            } else {
                pTrue.addPoint(mW + 10, mH + 10);
                pTrue.addPoint((int)((float)distW * (GraphicalParaconsistentParameterSetting.this.trueValue + 0.5f)) + minW, mH + minH);
                pTrue.addPoint(mW + minW, (int)((float)distH * (GraphicalParaconsistentParameterSetting.this.trueValue + 0.5f)) + minH);
                pmW4 = (int)(((float)(mW + minW) + (float)distW * (GraphicalParaconsistentParameterSetting.this.trueValue + 0.5f) + (float)minW) / 2.0f);
                pmH3 = (int)(((float)(mH + minH) + (float)distH * (GraphicalParaconsistentParameterSetting.this.trueValue + 0.5f) + (float)minH) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW4, pmH3);
            }
            g2.drawPolygon(pTrue);
            g2.setPaint(Color.GREEN);
            Polygon pInd = new Polygon();
            if ((double)GraphicalParaconsistentParameterSetting.this.indValue >= 0.5) {
                pInd.addPoint(minW, maxH);
                pInd.addPoint((int)((float)distW * (1.0f - GraphicalParaconsistentParameterSetting.this.indValue)) + minW, maxH);
                pInd.addPoint(minW, (int)((float)distH * GraphicalParaconsistentParameterSetting.this.indValue) + minH);
                pmW3 = (int)(((float)minW + ((float)distW * (1.0f - GraphicalParaconsistentParameterSetting.this.indValue) + (float)minW)) / 2.0f);
                pmH2 = (int)(((float)maxH + ((float)distH * GraphicalParaconsistentParameterSetting.this.indValue + (float)minH)) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW3, pmH2);
            } else {
                pInd.addPoint(mW + minW, mH + minH);
                pInd.addPoint((int)((float)distW * (0.5f - GraphicalParaconsistentParameterSetting.this.indValue)) + minW, mH + minW);
                pInd.addPoint(mW + minW, (int)((float)distH * (GraphicalParaconsistentParameterSetting.this.indValue + 0.5f)) + minH);
                pmW3 = (int)(((float)(mW + minW) + ((float)distW * (0.5f - GraphicalParaconsistentParameterSetting.this.indValue) + (float)minW)) / 2.0f);
                pmH2 = (int)(((float)(mH + minW) + ((float)distH * (GraphicalParaconsistentParameterSetting.this.indValue + 0.5f) + (float)minH)) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW3, pmH2);
            }
            g2.drawPolygon(pInd);
            g2.setPaint(Color.BLUE);
            Polygon pFalse = new Polygon();
            if ((double)GraphicalParaconsistentParameterSetting.this.falseValue >= 0.5) {
                pFalse.addPoint(minW, minH);
                pFalse.addPoint((int)((float)distW * (1.0f - GraphicalParaconsistentParameterSetting.this.falseValue)) + minW, minH);
                pFalse.addPoint(minW, (int)((float)distH * (1.0f - GraphicalParaconsistentParameterSetting.this.falseValue)) + minH);
                pmW2 = (int)(((float)minW + ((float)distW * (1.0f - GraphicalParaconsistentParameterSetting.this.falseValue) + (float)minW)) / 2.0f);
                pmH = (int)(((float)minH + ((float)distH * (1.0f - GraphicalParaconsistentParameterSetting.this.falseValue) + (float)minH)) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW2, pmH);
            } else {
                pFalse.addPoint(mW + minW, mH + minH);
                pFalse.addPoint(mW + minW, (int)((float)distH * (0.5f - GraphicalParaconsistentParameterSetting.this.falseValue)) + minH);
                pFalse.addPoint((int)((float)distW * (0.5f - GraphicalParaconsistentParameterSetting.this.falseValue)) + minW, mH + minW);
                pmW2 = (int)(((float)(mW + minW) + ((float)distW * (0.5f - GraphicalParaconsistentParameterSetting.this.falseValue) + (float)minW)) / 2.0f);
                pmH = (int)(((float)(mH + minW) + ((float)distH * (0.5f - GraphicalParaconsistentParameterSetting.this.falseValue) + (float)minH)) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW2, pmH);
            }
            g2.drawPolygon(pFalse);
            g2.setPaint(Color.CYAN);
            Polygon pInc = new Polygon();
            if ((double)GraphicalParaconsistentParameterSetting.this.incValue >= 0.5) {
                pInc.addPoint(maxW, minH);
                pInc.addPoint((int)((float)distW * GraphicalParaconsistentParameterSetting.this.incValue) + minW, minH);
                pInc.addPoint(maxW, (int)((float)distH * (1.0f - GraphicalParaconsistentParameterSetting.this.incValue)) + minH);
                pmW = (int)(((float)maxW + ((float)distW * GraphicalParaconsistentParameterSetting.this.incValue + (float)minW)) / 2.0f);
                int pmH4 = (int)(((float)minH + ((float)distH * (1.0f - GraphicalParaconsistentParameterSetting.this.incValue) + (float)minH)) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW, pmH4);
            } else {
                pInc.addPoint(mW + minW, mH + minH);
                pInc.addPoint((int)((float)distW * (GraphicalParaconsistentParameterSetting.this.incValue + 0.5f)) + minW, mH + minH);
                pInc.addPoint(mW + minW, (int)((float)distH * (0.5f - GraphicalParaconsistentParameterSetting.this.incValue)) + minH);
                pmW = (int)(((float)(mW + minW) + ((float)distW * (GraphicalParaconsistentParameterSetting.this.incValue + 0.5f) + (float)minW)) / 2.0f);
                int pmH5 = (int)(((float)(mH + minH) + ((float)distH * (0.5f - GraphicalParaconsistentParameterSetting.this.incValue) + (float)minH)) / 2.0f);
                g2.drawLine(mW + minW, mH + minW, pmW, pmH5);
            }
            g2.drawPolygon(pInc);
            g2.setColor(Color.BLACK);
        }
    }
}

