/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.transformation;

import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.sparse.SparseMatrix;
import simpletree.matrix.sparse.SparseVector;
import simpletree.textprocessing.processing.transformation.MatrixTransformation;

public class NTFTransformation
implements MatrixTransformation {
    @Override
    public AbstractMatrix tranform(AbstractMatrix mat, Object parameter) {
        try {
            SparseMatrix matrix = (SparseMatrix)mat.clone();
            for (int lin = 0; lin < matrix.getRowCount(); ++lin) {
                int col;
                SparseVector sv = (SparseVector)matrix.getRow(lin);
                sv.shouldUpdateNorm();
                int svlength = sv.getIndex().length;
                int nrtermsDoc = 0;
                for (col = 0; col < svlength; ++col) {
                    nrtermsDoc = (int)((float)nrtermsDoc + sv.getValues()[col]);
                }
                col = 0;
                while (col < svlength) {
                    float[] fArray = sv.getValues();
                    int n = col++;
                    fArray[n] = fArray[n] / (float)nrtermsDoc;
                }
            }
            return matrix;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(NTFTransformation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

