/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.transformation;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.sparse.SparseMatrix;
import simpletree.matrix.sparse.SparseVector;
import simpletree.textprocessing.processing.transformation.MatrixTransformation;
import simpletree.textprocessing.processing.transformation.ParaconsistentParameters;
import simpletree.textprocessing.processing.transformation.QUPCCountingReportView;

public class TFIDFParaTransformation
implements MatrixTransformation {
    private ParaconsistentParameters paraParam = null;

    @Override
    public AbstractMatrix tranform(AbstractMatrix mat, Object parameter) {
        try {
            SparseMatrix matrix = (SparseMatrix)mat.clone();
            float[] docsFreq = new float[matrix.getDimensions()];
            for (int lin = 0; lin < matrix.getRowCount(); ++lin) {
                SparseVector sv = (SparseVector)matrix.getRow(lin);
                int svlength = sv.getIndex().length;
                for (int col = 0; col < svlength; ++col) {
                    int n = sv.getIndex()[col];
                    docsFreq[n] = docsFreq[n] + 1.0f;
                }
            }
            float[][] matrix_aux = new float[matrix.getRowCount()][matrix.getDimensions()];
            for (int col = 0; col < matrix.getDimensions(); ++col) {
                int row;
                float max = Float.MIN_VALUE;
                for (row = 0; row < matrix.getRowCount(); ++row) {
                    if (!(matrix.getRow(row).getValue(col) > max)) continue;
                    max = matrix.getRow(row).getValue(col);
                }
                for (row = 0; row < matrix.getRowCount(); ++row) {
                    matrix_aux[row][col] = matrix.getRow(row).getValue(col) / max;
                }
            }
            for (int lin = 0; lin < matrix.getRowCount(); ++lin) {
                SparseVector sv = (SparseVector)matrix.getRow(lin);
                sv.shouldUpdateNorm();
                int svlength = sv.getIndex().length;
                for (int col = 0; col < svlength; ++col) {
                    float tf = sv.getValues()[col];
                    float df = 0.0f;
                    float idf = 0.0f;
                    if (docsFreq[col] != 0.0f) {
                        idf = (float)Math.log((float)matrix.getRowCount() / docsFreq[sv.getIndex()[col]]);
                        df = docsFreq[sv.getIndex()[col]] / (float)matrix.getRowCount();
                    }
                    sv.getValues()[col] = this.paraParam.getBeliefFactor() != false ? tf * idf * this.indexParaAnalyzer(df, matrix_aux[lin][col], this.paraParam.getVscc(), this.paraParam.getVicc(), this.paraParam.getVscct(), this.paraParam.getVicct(), matrix.getAttributes().get(col)) : tf * idf * this.indexParaAnalyzer(matrix_aux[lin][col], df, this.paraParam.getVscc(), this.paraParam.getVicc(), this.paraParam.getVscct(), this.paraParam.getVicct(), matrix.getAttributes().get(col));
                }
            }
            if (this.paraParam.isShowCountingReport()) {
                String str = JOptionPane.showInputDialog(null, "Enter a title to QUPC counting report view", "QUPC Counting Report Title", 1);
                if (str == null) {
                    str = "";
                }
                QUPCCountingReportView report = new QUPCCountingReportView();
                report.setTitle(str);
                report.display(this.paraParam);
            }
            return matrix;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(TFIDFParaTransformation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private float indexParaAnalyzer(float fc, float fd, float vscc, float vicc, float vscct, float vicct, String att) {
        float gct = fc + fd - 1.0f;
        float gc = fc - fd;
        float ver = this.paraParam.getVer();
        float fal = this.paraParam.getFal();
        float ind = this.paraParam.getInd();
        float inc = this.paraParam.getInc();
        float qver_p_inc = this.paraParam.getQver_p_inc();
        float qver_p_ind = this.paraParam.getQver_p_ind();
        float inc_p_ver = this.paraParam.getInc_p_ver();
        float ind_p_ver = this.paraParam.getInd_p_ver();
        float inc_p_fal = this.paraParam.getInc_p_fal();
        float ind_p_fal = this.paraParam.getInd_p_fal();
        float qfal_p_inc = this.paraParam.getQfal_p_inc();
        float qfal_p_ind = this.paraParam.getQfal_p_ind();
        if (gc >= vscc) {
            this.paraParam.getQUPCInf().count(0, att);
            return ver;
        }
        if (gc <= vicc) {
            this.paraParam.getQUPCInf().count(1, att);
            return fal;
        }
        if (gct >= vscct) {
            this.paraParam.getQUPCInf().count(3, att);
            return inc;
        }
        if (gct <= vicct) {
            this.paraParam.getQUPCInf().count(2, att);
            return ind;
        }
        if (0.0f <= gc && gc < vscc && 0.0f <= gct && gct < vscct) {
            if (gc >= gct) {
                this.paraParam.getQUPCInf().count(4, att);
                return qver_p_inc;
            }
            this.paraParam.getQUPCInf().count(6, att);
            return inc_p_ver;
        }
        if (0.0f <= gc && gc < vscc && vicct < gct && gct <= 0.0f) {
            if (gc >= Math.abs(gct)) {
                this.paraParam.getQUPCInf().count(5, att);
                return qver_p_ind;
            }
            this.paraParam.getQUPCInf().count(7, att);
            return ind_p_ver;
        }
        if (vicct < gc && gc <= 0.0f && vicct < gct && gct <= 0.0f) {
            if (Math.abs(gc) >= Math.abs(gct)) {
                this.paraParam.getQUPCInf().count(11, att);
                return qfal_p_ind;
            }
            this.paraParam.getQUPCInf().count(9, att);
            return ind_p_fal;
        }
        if (vicct < gc && gc <= 0.0f && 0.0f <= gct && gct < vscct) {
            if (Math.abs(gc) >= gct) {
                this.paraParam.getQUPCInf().count(10, att);
                return qfal_p_inc;
            }
            this.paraParam.getQUPCInf().count(8, att);
            return inc_p_fal;
        }
        this.paraParam.getQUPCInf().count(0, att);
        return ver;
    }

    public void setParaconsistentParameters(ParaconsistentParameters pdata) {
        this.paraParam = pdata;
    }
}

