/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.transformation;

import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.sparse.SparseMatrix;
import simpletree.matrix.sparse.SparseVector;
import simpletree.textprocessing.processing.transformation.MatrixTransformation;

public class TFIDFTransformation
implements MatrixTransformation {
    @Override
    public AbstractMatrix tranform(AbstractMatrix mat, Object parameter) {
        try {
            int col;
            int svlength;
            SparseVector sv;
            int lin;
            SparseMatrix matrix = (SparseMatrix)mat.clone();
            float[] docsFreq = new float[matrix.getDimensions()];
            for (lin = 0; lin < matrix.getRowCount(); ++lin) {
                sv = (SparseVector)matrix.getRow(lin);
                svlength = sv.getIndex().length;
                for (col = 0; col < svlength; ++col) {
                    int n = sv.getIndex()[col];
                    docsFreq[n] = docsFreq[n] + 1.0f;
                }
            }
            for (lin = 0; lin < matrix.getRowCount(); ++lin) {
                sv = (SparseVector)matrix.getRow(lin);
                sv.shouldUpdateNorm();
                svlength = sv.getIndex().length;
                for (col = 0; col < svlength; ++col) {
                    float tf = sv.getValues()[col];
                    float idf = 0.0f;
                    if (docsFreq[col] != 0.0f) {
                        idf = (float)Math.log((float)matrix.getRowCount() / docsFreq[sv.getIndex()[col]]);
                    }
                    sv.getValues()[col] = tf * idf;
                }
            }
            return matrix;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(TFIDFTransformation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

