/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import simpletree.model.AbstractInstance;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.processing.view.BrowserControl;
import simpletree.textprocessing.processing.view.ComplexCellRenderer;
import simpletree.textprocessing.processing.view.MyIcon;
import simpletree.view.JFrameModelViewer;

public class ListTextView
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ArrayList<FilePane> documentPaneList;
    private ArrayList<String> topicWords;
    private ArrayList<String> highlightedWords;
    private ArrayList<Integer> selectedIndicesJList;
    private int lastSelectedIndex;
    private Boolean fromListTable = false;
    private FilePane showedFilePane = null;
    private final int numberCharsAtTabTitle = 50;
    private JFrameModelViewer viewer;
    private JPanel buttonPanel;
    private JPanel classButtonsPanel;
    private JButton classifyButton;
    private JButton closeButton;
    private JPanel contentPanel;
    private JList corpusTitlelList;
    private JPanel dataPanel;
    private JButton exportButton;
    private JButton highlightButton;
    private JLabel highlightLabel;
    private JPanel highlightPanel;
    private JTextField highlightTextField;
    private JToolBar highlightToolBar;
    private JTable instancesListTable;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JScrollPane labelScrollPane;
    private JPanel manualClassPanel;
    private JButton removeHighlightButton;
    private JButton setAllButTheseButton;
    private JButton setAllButton;
    private JPanel subButton_Panel;
    private JButton updateButton;
    private JSplitPane windowsSplitPane;
    private ArrayList<TablesMapping> tablepositions;
    private ArrayList<AbstractInstance> instances;
    private Corpus corpus;
    private boolean manualClassifierActive = false;
    private ArrayList<Integer> selectedIds = new ArrayList();
    private boolean fromImage = false;

    private ListTextView(JFrame parent) {
        super(parent);
        this.viewer = (JFrameModelViewer)parent;
        this.initComponents();
        ComplexCellRenderer renderer = new ComplexCellRenderer();
        this.corpusTitlelList.setCellRenderer(renderer);
        this.tablepositions = new ArrayList();
        this.highlightedWords = new ArrayList();
        this.selectedIndicesJList = new ArrayList();
        this.pack();
    }

    private void initComponents() {
        this.windowsSplitPane = new JSplitPane();
        this.dataPanel = new JPanel();
        this.highlightToolBar = new JToolBar();
        this.highlightPanel = new JPanel();
        this.highlightLabel = new JLabel();
        this.highlightTextField = new JTextField();
        this.highlightButton = new JButton();
        this.removeHighlightButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.labelScrollPane = new JScrollPane();
        this.corpusTitlelList = new JList();
        this.contentPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.subButton_Panel = new JPanel();
        this.exportButton = new JButton();
        this.closeButton = new JButton();
        this.classifyButton = new JButton();
        this.manualClassPanel = new JPanel();
        this.classButtonsPanel = new JPanel();
        this.updateButton = new JButton();
        this.setAllButton = new JButton();
        this.setAllButTheseButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.instancesListTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("List Text View");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                ListTextView.this.formWindowClosed(evt);
            }
        });
        this.windowsSplitPane.setOrientation(0);
        this.dataPanel.setMinimumSize(new Dimension(707, 400));
        this.dataPanel.setPreferredSize(new Dimension(600, 400));
        this.dataPanel.setLayout(new GridBagLayout());
        this.highlightPanel.setLayout(new FlowLayout(2));
        this.highlightLabel.setText("Highlight");
        this.highlightPanel.add(this.highlightLabel);
        this.highlightTextField.setColumns(20);
        this.highlightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ListTextView.this.highlightTextFieldKeyPressed(evt);
            }
        });
        this.highlightPanel.add(this.highlightTextField);
        this.highlightButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/TipOfTheDay16.gif")));
        this.highlightButton.setToolTipText("Apply Highlight");
        this.highlightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.highlightButtonActionPerformed(evt);
            }
        });
        this.highlightPanel.add(this.highlightButton);
        this.removeHighlightButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Stop16.gif")));
        this.removeHighlightButton.setToolTipText("Remove Highlight");
        this.removeHighlightButton.setFocusable(false);
        this.removeHighlightButton.setHorizontalTextPosition(0);
        this.removeHighlightButton.setVerticalTextPosition(3);
        this.removeHighlightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.removeHighlightButtonActionPerformed(evt);
            }
        });
        this.highlightPanel.add(this.removeHighlightButton);
        this.highlightToolBar.add(this.highlightPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.dataPanel.add((Component)this.highlightToolBar, gridBagConstraints);
        this.jSplitPane1.setPreferredSize(new Dimension(600, 600));
        this.labelScrollPane.setBorder(BorderFactory.createTitledBorder("Label"));
        this.labelScrollPane.setMinimumSize(new Dimension(200, 55));
        this.corpusTitlelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ListTextView.this.corpusTitlelListMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                ListTextView.this.corpusTitlelListMouseClicked(evt);
            }
        });
        this.corpusTitlelList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ListTextView.this.corpusTitlelListValueChanged(evt);
            }
        });
        this.labelScrollPane.setViewportView(this.corpusTitlelList);
        this.jSplitPane1.setLeftComponent(this.labelScrollPane);
        this.contentPanel.setBorder(BorderFactory.createTitledBorder("Content"));
        this.contentPanel.setMinimumSize(new Dimension(500, 500));
        this.contentPanel.setPreferredSize(new Dimension(800, 500));
        this.contentPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.contentPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.dataPanel.add((Component)this.jSplitPane1, gridBagConstraints);
        this.windowsSplitPane.setLeftComponent(this.dataPanel);
        this.buttonPanel.setMinimumSize(new Dimension(800, 46));
        this.buttonPanel.setPreferredSize(new Dimension(800, 46));
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.subButton_Panel.setBorder(BorderFactory.createEtchedBorder());
        this.exportButton.setText("Export Corpus");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.exportButtonActionPerformed(evt);
            }
        });
        this.subButton_Panel.add(this.exportButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.closeButtonActionPerformed(evt);
            }
        });
        this.subButton_Panel.add(this.closeButton);
        this.classifyButton.setText("Manual Classifier");
        this.classifyButton.setEnabled(false);
        this.classifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.classifyButtonActionPerformed(evt);
            }
        });
        this.subButton_Panel.add(this.classifyButton);
        this.buttonPanel.add(this.subButton_Panel);
        this.manualClassPanel.setBorder(BorderFactory.createTitledBorder("Manual Classifier"));
        this.manualClassPanel.setMinimumSize(new Dimension(800, 13));
        this.manualClassPanel.setPreferredSize(new Dimension(800, 13));
        this.manualClassPanel.setLayout(new GridBagLayout());
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.updateButtonActionPerformed(evt);
            }
        });
        this.classButtonsPanel.add(this.updateButton);
        this.setAllButton.setText("Set All");
        this.setAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.setAllButtonActionPerformed(evt);
            }
        });
        this.classButtonsPanel.add(this.setAllButton);
        this.setAllButTheseButton.setText("Set All but These");
        this.setAllButTheseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListTextView.this.setAllButTheseButtonActionPerformed(evt);
            }
        });
        this.classButtonsPanel.add(this.setAllButTheseButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.manualClassPanel.add((Component)this.classButtonsPanel, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(700, 20));
        this.jScrollPane1.setPreferredSize(new Dimension(800, 64));
        this.instancesListTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.instancesListTable.setMinimumSize(new Dimension(300, 364));
        this.instancesListTable.setPreferredSize(new Dimension(300, 364));
        this.instancesListTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ListTextView.this.instancesListTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.instancesListTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.manualClassPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonPanel.add(this.manualClassPanel);
        this.windowsSplitPane.setRightComponent(this.buttonPanel);
        this.getContentPane().add((Component)this.windowsSplitPane, "Center");
        this.pack();
    }

    private void highlightTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.showedFilePane != null) {
            this.highlightedWords.clear();
            this.showedFilePane.removeHighlights(this.showedFilePane.textArea);
            if (this.highlightTextField.getText().trim().length() > 0) {
                for (String word : this.highlightTextField.getText().trim().split(" ")) {
                    this.highlightedWords.add(word);
                }
                this.highlightEnteredWords();
            }
        }
    }

    private void highlightButtonActionPerformed(ActionEvent evt) {
        if (this.showedFilePane != null) {
            this.highlightedWords.clear();
            this.showedFilePane.removeHighlights(this.showedFilePane.textArea);
            if (this.highlightTextField.getText().trim().length() > 0) {
                for (String word : this.highlightTextField.getText().trim().split(" ")) {
                    this.highlightedWords.add(word);
                }
                this.highlightEnteredWords();
            }
        }
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private int getNewIndex(int[] indices) {
        int elem;
        int i;
        if (indices.length == this.selectedIndicesJList.size()) {
            return this.lastSelectedIndex;
        }
        if (indices.length < this.selectedIndicesJList.size()) {
            for (i = 0; i < this.selectedIndicesJList.size(); ++i) {
                int j;
                elem = this.selectedIndicesJList.get(i);
                for (j = 0; j < indices.length && elem != indices[j]; ++j) {
                }
                if (j != indices.length) continue;
                this.lastSelectedIndex = elem;
                return elem;
            }
        }
        i = 0;
        elem = indices[i];
        while (this.selectedIndicesJList.contains(elem) && i < indices.length) {
            if (++i >= indices.length) continue;
            elem = indices[i];
        }
        this.selectedIndicesJList.add(elem);
        this.lastSelectedIndex = elem;
        return elem;
    }

    private void refreshTableSelection() {
        this.instancesListTable.getSelectionModel().clearSelection();
        for (int i = 0; i < this.corpusTitlelList.getSelectedIndices().length; ++i) {
            int index = this.corpusTitlelList.getSelectedIndices()[i];
            this.instancesListTable.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    private void corpusTitlelListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (!this.corpusTitlelList.isSelectionEmpty()) {
            int selectedLabel = this.corpusTitlelList.getSelectedIndex();
            if (this.corpusTitlelList.getSelectedIndices().length > 1) {
                selectedLabel = this.getNewIndex(this.corpusTitlelList.getSelectedIndices());
                this.selectedIndicesJList.clear();
                for (int i = 0; i < this.corpusTitlelList.getSelectedIndices().length; ++i) {
                    this.selectedIndicesJList.add(this.corpusTitlelList.getSelectedIndices()[i]);
                }
            } else {
                if (this.selectedIndicesJList.size() > 1) {
                    selectedLabel = this.getNewIndex(this.corpusTitlelList.getSelectedIndices());
                }
                this.selectedIndicesJList.clear();
                this.selectedIndicesJList.add(selectedLabel);
                this.lastSelectedIndex = selectedLabel;
            }
            this.refreshContentPane(selectedLabel);
        }
        if (this.manualClassifierActive && !this.fromListTable.booleanValue()) {
            this.refreshTableSelection();
        }
    }

    private void highlightEnteredWords() {
        for (String word : this.highlightedWords) {
            this.showedFilePane.highlight(this.showedFilePane.textArea, word);
        }
    }

    private void refreshContentPane(int index) {
        FilePane selectedPane = this.documentPaneList.get(index);
        this.contentPanel.removeAll();
        this.contentPanel.add(selectedPane);
        this.showedFilePane = selectedPane;
        selectedPane.removeHighlights(selectedPane.textArea);
        if (this.topicWords != null) {
            for (String topicWord : this.topicWords) {
                selectedPane.highlight(selectedPane.textArea, topicWord);
            }
        }
        this.highlightEnteredWords();
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.documentPaneList.clear();
    }

    private void removeHighlightButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.documentPaneList.size(); ++i) {
            FilePane selectedPane = this.documentPaneList.get(i);
            selectedPane.removeHighlights(selectedPane.textArea);
        }
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
    }

    private void setAllButtonActionPerformed(ActionEvent evt) {
    }

    private void setAllButTheseButtonActionPerformed(ActionEvent evt) {
    }

    private void instancesListTableMouseClicked(MouseEvent evt) {
    }

    private void imagesTableMouseClicked(MouseEvent evt) {
        this.instancesListTableMouseClicked(evt);
    }

    private void classifyButtonActionPerformed(ActionEvent evt) {
    }

    private void corpusTitlelListMouseReleased(MouseEvent evt) {
    }

    private void corpusTitlelListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.instancesListTableMouseClicked(evt);
        }
    }

    public static ListTextView getInstance(JFrame parent) {
        return new ListTextView(parent);
    }

    public void display(Corpus corpus, ArrayList<AbstractInstance> instances) {
    }

    public void display(Corpus corpus, List<Integer> ids, List<Color> colors) {
        if (ids == null) {
            Logger.getLogger(ListTextView.class.getName()).log(Level.SEVERE, null, "Error! Cound't display the content of a null document list!");
            return;
        }
        this.documentPaneList = new ArrayList();
        this.corpus = corpus;
        Object[][] elements = new Object[ids.size()][2];
        this.contentPanel.removeAll();
        this.highlightTextField.setText("");
        for (int row = 0; row < ids.size(); ++row) {
            int id = ids.get(row);
            try {
                String fileName = corpus.getLabel(1, id);
                String firstLine = corpus.getViewContent(id).trim();
                if (firstLine.length() > this.numberCharsAtTabTitle) {
                    firstLine = firstLine.substring(0, this.numberCharsAtTabTitle - 3) + "...";
                }
                this.documentPaneList.add(new FilePane(fileName, corpus, id));
                Color instanceColor = colors.get(row);
                elements[row][0] = new MyIcon(instanceColor);
                elements[row][1] = firstLine;
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(ListTextView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.contentPanel.add(this.documentPaneList.get(0));
        this.showedFilePane = this.documentPaneList.get(0);
        this.corpusTitlelList.setListData((E[])elements);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.manualClassPanel.setVisible(false);
        this.exportButton.setVisible(false);
        this.setVisible(true);
    }

    public void display(AbstractInstance instance, Corpus corpus) {
        ArrayList<AbstractInstance> aux = new ArrayList<AbstractInstance>();
        aux.add(instance);
        this.display(corpus, aux);
    }

    private TablesMapping getTablesMappingById(int id) {
        for (int i = 0; i < this.tablepositions.size(); ++i) {
            if (this.tablepositions.get((int)i).id != id) continue;
            return this.tablepositions.get(i);
        }
        return null;
    }

    public void unmarkImages() {
        for (int i = 0; i < this.tablepositions.size(); ++i) {
            TablesMapping tp = this.tablepositions.get(i);
            if (tp == null) continue;
        }
    }

    public void markSelectedImages(ArrayList<Integer> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            TablesMapping tp = this.getTablesMappingById(ids.get(i));
            if (tp == null) continue;
        }
    }

    public void markSelectedInstances(ArrayList<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.fromImage = true;
        this.instancesListTable.clearSelection();
        int minIndex = Integer.MAX_VALUE;
        int maxIndex = Integer.MIN_VALUE;
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < ids.size(); ++i) {
            TablesMapping tp = this.getTablesMappingById(ids.get(i));
            if (tp == null) continue;
            if (tp.instanceTableRow < minIndex) {
                minIndex = tp.instanceTableRow;
            }
            if (tp.instanceTableRow > maxIndex) {
                maxIndex = tp.instanceTableRow;
            }
            rows.add(tp.instanceTableRow);
        }
        this.instancesListTable.changeSelection(minIndex, 0, false, false);
        this.instancesListTable.changeSelection(maxIndex, 0, false, true);
        for (int j = minIndex; j <= maxIndex; ++j) {
            if (rows.contains(j)) continue;
            this.instancesListTable.changeSelection(j, 0, true, false);
        }
        this.fromImage = false;
    }

    private class InstancesRowListener
    implements ListSelectionListener {
        private InstancesRowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!ListTextView.this.fromImage) {
                ListTextView.this.selectedIds.clear();
                for (int i = 0; i < ListTextView.this.instancesListTable.getSelectedRows().length; ++i) {
                    if (ListTextView.this.selectedIds.contains((Integer)ListTextView.this.instancesListTable.getValueAt(ListTextView.this.instancesListTable.getSelectedRows()[i], 4))) continue;
                    ListTextView.this.selectedIds.add((Integer)ListTextView.this.instancesListTable.getValueAt(ListTextView.this.instancesListTable.getSelectedRows()[i], 4));
                }
                ListTextView.this.unmarkImages();
                ListTextView.this.markSelectedImages(ListTextView.this.selectedIds);
            }
        }
    }

    class TablesMapping {
        public int id;
        public String label;
        public int imageTableRow;
        public int imageTableCol;
        public int instanceTableRow = -1;

        public TablesMapping(int id, String label, int row, int col) {
            this.id = id;
            this.label = label;
            this.imageTableRow = row;
            this.imageTableCol = col;
        }
    }

    class FilePane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField filelabelField;
        private JPanel filelabelPanel;
        private JEditorPane textArea;
        private JScrollPane textAreaScrollPane;
        private Highlighter.HighlightPainter myHighlightPainter = new MyHighlightPainter(Color.YELLOW);

        public FilePane(String label, Corpus datasource, int id) {
            this.initComponents(label, datasource, id);
        }

        private void initComponents(String label, Corpus corpus, int id) {
            this.textAreaScrollPane = new JScrollPane();
            this.textArea = new JEditorPane();
            this.filelabelPanel = new JPanel();
            this.filelabelField = new JTextField();
            this.setLayout(new BorderLayout());
            this.textAreaScrollPane.setBorder(BorderFactory.createTitledBorder("File Content"));
            this.textAreaScrollPane.setAutoscrolls(true);
            this.textArea.setEditable(false);
            this.textArea.setAutoscrolls(false);
            this.textAreaScrollPane.setViewportView(this.textArea);
            this.add((Component)this.textAreaScrollPane, "Center");
            this.textArea.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserControl.displayURL(e.getURL().toString());
                    }
                }
            });
            this.filelabelPanel.setLayout(new BorderLayout());
            this.filelabelPanel.setBorder(BorderFactory.createTitledBorder("File Label"));
            this.filelabelField.setEditable(false);
            this.filelabelPanel.add((Component)this.filelabelField, "Center");
            this.add((Component)this.filelabelPanel, "North");
            this.filelabelField.setText(label);
            this.filelabelField.setCaretPosition(0);
            try {
                this.textArea.setText(corpus.getViewContent(id));
                this.textArea.setCaretPosition(0);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void highlight(JTextComponent textComp, String pattern) {
            try {
                Highlighter hilite = textComp.getHighlighter();
                Document doc = textComp.getDocument();
                String text = doc.getText(0, doc.getLength()).toLowerCase();
                int pos = 0;
                pos = text.indexOf(pattern.toLowerCase(), pos);
                if (pos >= 0) {
                    hilite.addHighlight(pos, pos + pattern.length(), this.myHighlightPainter);
                    this.textArea.setCaretPosition(pos);
                    pos += pattern.length();
                }
                while ((pos = text.indexOf(pattern.toLowerCase(), pos)) >= 0) {
                    hilite.addHighlight(pos, pos + pattern.length(), this.myHighlightPainter);
                    pos += pattern.length();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public String toString() {
            return this.filelabelField.getText();
        }

        public void removeHighlights(JTextComponent textComp) {
            Highlighter hilite = textComp.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            for (int i = 0; i < hilites.length; ++i) {
                if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
                hilite.removeHighlight(hilites[i]);
            }
        }

        class MyHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            public MyHighlightPainter(Color color) {
                super(color);
            }
        }
    }
}

