/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import simpletree.textprocessing.processing.Stopword;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.STOPFilter;

public class StopwordsManager
extends JDialog {
    private DefaultTableModel currentWordsTableModel;
    private DefaultTableModel newWordsTableModel;
    private JButton addButton;
    private JPanel addWordsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel currentWordsPanel;
    private JPanel fileButtonPanel;
    private JPanel filePanel;
    private JTextField fileTextField;
    private JButton mergeButton;
    private JPanel mergePanel;
    private JScrollPane newScrollPane;
    private JTable newWordsTable;
    private JButton openButton;
    private JButton removeButton;
    private JButton saveButton;
    private JPanel wordsPanel;
    private JScrollPane wordsScrollPane;
    private JTable wordsTable;

    private StopwordsManager(Frame parent) {
        super(parent);
        this.initComponents();
    }

    private StopwordsManager(Dialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.wordsPanel = new JPanel();
        this.addWordsPanel = new JPanel();
        this.addButton = new JButton();
        this.newScrollPane = new JScrollPane();
        this.newWordsTable = new JTable();
        this.currentWordsPanel = new JPanel();
        this.wordsScrollPane = new JScrollPane();
        this.wordsTable = new JTable();
        this.removeButton = new JButton();
        this.mergePanel = new JPanel();
        this.mergeButton = new JButton();
        this.filePanel = new JPanel();
        this.fileTextField = new JTextField();
        this.fileButtonPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.saveButton = new JButton();
        this.openButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Stopwords List Manager");
        this.setModal(true);
        this.wordsPanel.setBorder(BorderFactory.createTitledBorder("Stopwords Manager"));
        this.wordsPanel.setLayout(new BorderLayout(5, 5));
        this.addWordsPanel.setLayout(new BorderLayout());
        this.addButton.setText("New");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.addButtonActionPerformed(evt);
            }
        });
        this.addWordsPanel.add((Component)this.addButton, "South");
        this.newScrollPane.setBorder(BorderFactory.createTitledBorder("New Stopwords"));
        this.newScrollPane.setPreferredSize(new Dimension(200, 350));
        this.newScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StopwordsManager.this.newScrollPaneMouseClicked(evt);
            }
        });
        this.newScrollPane.setViewportView(this.newWordsTable);
        this.addWordsPanel.add((Component)this.newScrollPane, "Center");
        this.wordsPanel.add((Component)this.addWordsPanel, "East");
        this.currentWordsPanel.setLayout(new BorderLayout());
        this.wordsScrollPane.setBorder(BorderFactory.createTitledBorder("Current Stopwords"));
        this.wordsScrollPane.setPreferredSize(new Dimension(200, 350));
        this.wordsScrollPane.setViewportView(this.wordsTable);
        this.currentWordsPanel.add((Component)this.wordsScrollPane, "Center");
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.removeButtonActionPerformed(evt);
            }
        });
        this.currentWordsPanel.add((Component)this.removeButton, "South");
        this.wordsPanel.add((Component)this.currentWordsPanel, "West");
        this.mergePanel.setLayout(new GridBagLayout());
        this.mergeButton.setText("<< Merge");
        this.mergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.mergeButtonActionPerformed(evt);
            }
        });
        this.mergePanel.add((Component)this.mergeButton, new GridBagConstraints());
        this.wordsPanel.add((Component)this.mergePanel, "Center");
        this.filePanel.setBorder(BorderFactory.createTitledBorder("Stopwords File"));
        this.filePanel.setLayout(new BorderLayout(5, 5));
        this.fileTextField.setColumns(15);
        this.fileTextField.setEditable(false);
        this.filePanel.add((Component)this.fileTextField, "North");
        this.filePanel.add((Component)this.fileButtonPanel, "Center");
        this.wordsPanel.add((Component)this.filePanel, "North");
        this.getContentPane().add((Component)this.wordsPanel, "Center");
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.saveButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveButton);
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.openButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.openButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StopwordsManager.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.wordsTable.getSelectedRow();
        if (index > -1) {
            String stopword = (String)this.currentWordsTableModel.getValueAt(index, 0);
            this.currentWordsTableModel.removeRow(index);
            try {
                Stopword stp = Stopword.getInstance();
                stp.removeStopword(stopword);
            }
            catch (IOException ex) {
                Logger.getLogger(StopwordsManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("textprocessing.properties");
            int result = SaveDialog.showSaveDialog(spm, new STOPFilter(), this, "stopwords.spw");
            if (result == 0) {
                try {
                    String filename = SaveDialog.getFilename();
                    Stopword stp = Stopword.getInstance();
                    stp.saveStopwordsList(filename);
                    spm.setProperty("SPW.FILE", filename.substring(filename.lastIndexOf("\\") + 1));
                    this.fileTextField.setText(filename.substring(filename.lastIndexOf("\\") + 1));
                }
                catch (IOException ex) {
                    Logger.getLogger(StopwordsManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StopwordsManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void newScrollPaneMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.addButtonActionPerformed(null);
        }
    }

    private void mergeButtonActionPerformed(ActionEvent evt) {
        ArrayList<String> stopwords = new ArrayList<String>();
        this.newWordsTable.editCellAt(0, 0);
        try {
            Stopword stp = Stopword.getInstance();
            for (int i = 0; i < this.newWordsTableModel.getRowCount(); ++i) {
                String value = (String)this.newWordsTableModel.getValueAt(i, 0);
                if (value.trim().length() <= 0) continue;
                stopwords.add(value);
            }
            stp.addStopwords(stopwords);
            this.initModels();
            this.wordsTable.setModel(this.currentWordsTableModel);
            this.newWordsTable.setModel(this.newWordsTableModel);
            for (String stopword : stp.getStopwordList()) {
                Object[] row = new String[]{stopword};
                this.currentWordsTableModel.addRow(row);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StopwordsManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.newWordsTableModel.addRow(new String[]{""});
        this.newWordsTable.editCellAt(this.newWordsTableModel.getRowCount() - 1, 0);
        this.newWordsTable.requestFocusInWindow();
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        block5: {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("textprocessing.properties");
                int result = OpenDialog.showOpenDialog(spm, new STOPFilter(), this);
                if (result != 0) break block5;
                try {
                    String filename = OpenDialog.getFilename();
                    Stopword stp = Stopword.getInstance();
                    stp.changeStopwordList(filename);
                    spm.setProperty("SPW.FILE", filename.substring(filename.lastIndexOf("\\") + 1));
                    this.fileTextField.setText(filename.substring(filename.lastIndexOf("\\") + 1));
                    this.initModels();
                    this.wordsTable.setModel(this.currentWordsTableModel);
                    this.newWordsTable.setModel(this.newWordsTableModel);
                    for (String stopword : stp.getStopwordList()) {
                        Object[] row = new String[]{stopword};
                        this.currentWordsTableModel.addRow(row);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(StopwordsManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(StopwordsManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static StopwordsManager getInstance(Container parent) {
        if (parent instanceof JFrame) {
            return new StopwordsManager((JFrame)parent);
        }
        return new StopwordsManager((JDialog)parent);
    }

    public void display() {
        this.initModels();
        this.wordsTable.setModel(this.currentWordsTableModel);
        this.newWordsTable.setModel(this.newWordsTableModel);
        try {
            PropertiesManager spm = PropertiesManager.getInstance("textprocessing.properties");
            String filename = spm.getProperty("SPW.FILE");
            this.fileTextField.setText(filename);
            Stopword stp = Stopword.getInstance();
            for (String stopword : stp.getStopwordList()) {
                Object[] row = new String[]{stopword};
                this.currentWordsTableModel.addRow(row);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void initModels() {
        Object[] titles = new String[]{"Stopwords"};
        this.currentWordsTableModel = new DefaultTableModel(null, titles);
        this.newWordsTableModel = new DefaultTableModel(null, titles);
    }
}

