/*
 * Decompiled with CFR 0.152.
 */
package simpletree.textprocessing.processing.view;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;
import simpletree.textprocessing.corpus.Corpus;
import simpletree.textprocessing.corpus.CorpusFactory;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.AbstractFilter;

public class TextOpenDialog {
    protected static String _filename;
    protected static JFileChooser dialog;

    public static int showOpenDialog(PropertiesManager spm, AbstractFilter filter, Component parent) {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        _filename = null;
        dialog.resetChoosableFileFilters();
        dialog.setAcceptAllFileFilterUsed(false);
        if (filter != null) {
            dialog.setFileFilter(filter);
        }
        dialog.setMultiSelectionEnabled(false);
        dialog.setDialogTitle("Open file");
        dialog.setSelectedFile(new File(""));
        dialog.setFileSelectionMode(2);
        dialog.setCurrentDirectory(new File(spm.getProperty(filter.getProperty())));
        int result = dialog.showOpenDialog(parent);
        if (result == 0) {
            _filename = dialog.getSelectedFile().getAbsolutePath();
            spm.setProperty(filter.getProperty(), dialog.getSelectedFile().getParent());
        }
        return result;
    }

    public static String getFilename() {
        return _filename;
    }

    public static JFileChooser getJFileChooser() {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        return dialog;
    }

    public static Corpus openCorpus(PropertiesManager spm, AbstractFilter filter, Component parent) {
        Corpus c = null;
        int r = TextOpenDialog.showOpenDialog(spm, filter, parent);
        if (r == 0) {
            c = CorpusFactory.getInstance(_filename, 1);
        }
        return c;
    }

    public static boolean checkCorpus(Corpus c, AbstractModel model) {
        int count = 0;
        int valid = 0;
        if (c == null) {
            return false;
        }
        for (AbstractInstance ins : model.getInstances()) {
            int ifl = ins.getId();
            if (c.getIds().contains(ifl)) {
                ++count;
            }
            if (ins.toString().trim().isEmpty()) continue;
            ++valid;
        }
        return count == valid;
    }
}

