/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFileChooser;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.ImageCollection;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.AbstractFilter;

public class ProjectionOpenDialog
extends OpenDialog {
    public static int showOpenDirDialog(Component parent, String directory) {
        dialog = new JFileChooser();
        int oldSelectionMode = dialog.getFileSelectionMode();
        dialog.setFileSelectionMode(1);
        dialog.setDialogTitle("Open Directory");
        dialog.setCurrentDirectory(new File(directory));
        int result = dialog.showOpenDialog(parent);
        if (result == 0) {
            _filename = dialog.getSelectedFile().getAbsolutePath();
        }
        dialog.setFileSelectionMode(oldSelectionMode);
        return result;
    }

    public static int showOpenDialogMultipleFiles(PropertiesManager spm, AbstractFilter filter, Component parent) {
        if (dialog == null) {
            dialog = new JFileChooser();
        }
        _filename = null;
        dialog.resetChoosableFileFilters();
        dialog.setAcceptAllFileFilterUsed(false);
        if (filter != null) {
            dialog.setFileFilter(filter);
        }
        dialog.setMultiSelectionEnabled(false);
        dialog.setDialogTitle("Open file");
        dialog.setSelectedFile(new File(""));
        dialog.setCurrentDirectory(new File(spm.getProperty(filter.getProperty())));
        dialog.setMultiSelectionEnabled(true);
        int result = dialog.showOpenDialog(parent);
        if (result == 0) {
            File[] files = dialog.getSelectedFiles();
            files = ProjectionOpenDialog.sortFilesByLastModDate(files, 0);
            String filesS = "";
            if (files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    filesS = filesS + files[i] + ";";
                }
                filesS = filesS.substring(0, filesS.length() - 1);
            }
            _filename = filesS;
            spm.setProperty(filter.getProperty(), dialog.getSelectedFile().getParent());
        }
        return result;
    }

    public static int showOpenDialogMultipleFilter(PropertiesManager spm, ArrayList<AbstractFilter> filters, Component parent) {
        if (OpenDialog.dialog == null) {
            OpenDialog.dialog = new JFileChooser();
        }
        _filename = null;
        dialog.resetChoosableFileFilters();
        dialog.setAcceptAllFileFilterUsed(false);
        if (filters != null && !filters.isEmpty()) {
            for (int i = 0; i < filters.size(); ++i) {
                dialog.addChoosableFileFilter(filters.get(i));
            }
            dialog.setMultiSelectionEnabled(false);
            dialog.setDialogTitle("Open file");
            dialog.setSelectedFile(new File(""));
            dialog.setCurrentDirectory(new File(spm.getProperty(filters.get(0).getProperty())));
            int result = dialog.showOpenDialog(parent);
            if (result == 0) {
                _filename = dialog.getSelectedFile().getAbsolutePath();
                spm.setProperty(filters.get(0).getProperty(), dialog.getSelectedFile().getParent());
            }
            return result;
        }
        return -1;
    }

    public static File[] sortFilesByLastModDate(File[] fList, final int order) {
        Arrays.sort(fList, new Comparator(){

            public int compare(Object file1, Object file2) {
                if (file1 instanceof File && file2 instanceof File) {
                    if (order == 1) {
                        return (int)(((File)file2).lastModified() - ((File)file1).lastModified());
                    }
                    return (int)(((File)file1).lastModified() - ((File)file2).lastModified());
                }
                return 0;
            }
        });
        return fList;
    }

    public static ImageCollection openImages(PropertiesManager spm, AbstractFilter filter, Component parent) {
        ImageCollection im = null;
        int r = ProjectionOpenDialog.showOpenDialog(spm, filter, parent);
        if (r == 0) {
            im = new ImageCollection(_filename);
        }
        return im;
    }

    public static boolean checkImages(ImageCollection ic, AbstractModel model) {
        int count = 0;
        int valid = 0;
        if (ic == null) {
            return false;
        }
        for (AbstractInstance ins : model.getInstances()) {
            if (!((SimpleTreeInstance)ins).isValid()) continue;
            String filename = ((SimpleTreeModel)model).getLabels().get(ins.getId());
            if (ic.getImageUrls().contains(filename)) {
                ++count;
            }
            if (filename.trim().isEmpty()) continue;
            ++valid;
        }
        return count == valid;
    }

    public static String getFilename() {
        return _filename;
    }
}

