/*
 * Decompiled with CFR 0.152.
 */
package simpletree.util;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.AbstractFilter;

public class SaveDialog {
    private static String _filename;
    private static JFileChooser dialog;

    public static int showSaveDialog(AbstractFilter filter, Component parent, String directory, String filename) {
        if (dialog == null) {
            SaveDialog.createDialog();
        }
        _filename = null;
        dialog.resetChoosableFileFilters();
        dialog.setAcceptAllFileFilterUsed(false);
        if (filter != null) {
            dialog.setFileFilter(filter);
        }
        dialog.setMultiSelectionEnabled(false);
        dialog.setDialogTitle("Save file");
        dialog.setCurrentDirectory(new File(directory));
        if (filename != null && filename.length() > 0) {
            dialog.setSelectedFile(new File(filename));
        } else {
            dialog.setSelectedFile(new File(""));
        }
        int result = dialog.showSaveDialog(parent);
        if (result == 0 && !(_filename = dialog.getSelectedFile().getAbsolutePath()).toLowerCase().endsWith("." + filter.getFileExtension())) {
            _filename = _filename.concat("." + filter.getFileExtension());
        }
        return result;
    }

    public static int showSaveDialog(PropertiesManager spm, AbstractFilter filter, Component parent, String filename) {
        if (dialog == null) {
            SaveDialog.createDialog();
        }
        _filename = null;
        dialog.resetChoosableFileFilters();
        dialog.setAcceptAllFileFilterUsed(false);
        if (filter != null) {
            dialog.setFileFilter(filter);
        }
        dialog.setMultiSelectionEnabled(false);
        dialog.setDialogTitle("Save file");
        if (filename != null && filename.length() > 0) {
            filename = filename.substring(0, filename.lastIndexOf(46)) + "." + filter.getFileExtension().toLowerCase();
            dialog.setSelectedFile(new File(filename));
        } else {
            dialog.setSelectedFile(new File(""));
        }
        dialog.setCurrentDirectory(new File(spm.getProperty(filter.getProperty())));
        int result = dialog.showSaveDialog(parent);
        if (result == 0) {
            _filename = dialog.getSelectedFile().getAbsolutePath();
            spm.setProperty(filter.getProperty(), dialog.getSelectedFile().getParent());
            if (!_filename.toLowerCase().endsWith("." + filter.getFileExtension())) {
                _filename = _filename.concat("." + filter.getFileExtension());
            }
        }
        return result;
    }

    public static int showSaveDialog(PropertiesManager spm, AbstractFilter filter, Component parent) {
        return SaveDialog.showSaveDialog(spm, filter, parent, "newfile." + filter.getFileExtension());
    }

    public static String getFilename() {
        return _filename;
    }

    private static void createDialog() {
        dialog = new JFileChooser(){

            @Override
            public void approveSelection() {
                String message;
                int answer;
                File file = this.getSelectedFile();
                if (file != null && file.exists() && (answer = JOptionPane.showOptionDialog(this, message = "The file \"" + file.getName() + "\" already exists. \nDo you want to replace the existing file?", "Save Warning", 0, 2, null, null, null)) == 1) {
                    return;
                }
                super.approveSelection();
            }
        };
    }
}

