/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import simpletree.basics.color.ColorScalePanel;
import simpletree.coordination.AbstractCoordinator;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.forcelayout.ForceData;
import simpletree.forcelayout.ForceDirectLayout;
import simpletree.graph.technique.layout.RadialLayoutComp;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.reader.MatrixReaderComp;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;
import simpletree.model.Connectivity;
import simpletree.model.GraphInstance;
import simpletree.model.GraphModel;
import simpletree.model.GraphModelComp;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;
import simpletree.model.xml.XMLGraphModelReader;
import simpletree.model.xml.XMLGraphModelWriter;
import simpletree.technique.connection.nj.NJConnectionComp;
import simpletree.util.OpenDialog;
import simpletree.util.ProjectionUtil;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.PNGFilter;
import simpletree.util.filter.SCALARFilter;
import simpletree.util.filter.XMLFilter;
import simpletree.view.GraphFameOptions;
import simpletree.view.GraphFrameComp;
import simpletree.view.JExtendedComboBox;
import simpletree.view.JFrameModelViewer;
import simpletree.view.MemoryCheck;
import simpletree.view.MessageDialog;
import simpletree.view.selection.AbstractSelection;
import simpletree.view.selection.CovarianceSelection;
import simpletree.view.selection.DynamicColorSelection;
import simpletree.view.selection.InstanceSelection;
import simpletree.view.selection.RangeSelection;
import simpletree.view.selection.coordination.CoordinationSelectionFactory;
import simpletree.view.tools.JoinScalars;
import simpletree.view.tools.MultidimensionalClusteringView;
import simpletree.view.tools.SilhouetteCoefficientView;

public class GraphFrame
extends JFrameModelViewer {
    private DefaultComboBoxModel scalarComboModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel edgeComboModel = new DefaultComboBoxModel();
    private boolean highqualityrender = true;
    private boolean showinstancelabel = true;
    private boolean moveinstances = true;
    private ViewPanel view = new ViewPanel();
    private ForceDirectLayout force;
    private boolean start = true;
    private JButton cleanInstancesButton;
    private JMenu clusteringMenu;
    private JLabel colorLabel;
    private JPanel controlPanel;
    private JPanel dataPanel;
    private JComboBox edgeCombo;
    private JLabel edgeLabel;
    private JMenuItem editClean;
    private JMenuItem editDelete;
    private JMenu exportMenu;
    private JMenuItem exportScalarsOption;
    private JMenuItem fileExportToPng;
    private JMenuItem fileExportToProjection;
    private JMenuItem fileOpen;
    private JMenuItem fileSave;
    private JToolBar fixedToolBar;
    private JMenuItem importScalarsOption;
    private JMenuItem joinScalarsOptions;
    private JMenuItem memoryCheckMenuItem;
    private JMenuBar menuBar;
    private JMenu menuEdit;
    private JMenu menuFile;
    private JMenu menuTool;
    private JToggleButton moveInstancesToggleButton;
    private JMenuItem multidimensionalMenuItem;
    private JButton openButton;
    private JButton runForceButton;
    private JButton saveButton;
    private JComboBox scalarCombo;
    private JMenu scalarMenu;
    private JPanel scalarPanel;
    private JScrollPane scrollPanel;
    private ButtonGroup selectionButtonGroup;
    private JToolBar selectionToolBar;
    private JSeparator separator1;
    private JLabel separatorLabel1;
    private JLabel separatorLabel2;
    private JLabel separatorLabel5;
    private JSeparator separatorOptions1;
    private JSeparator separatorOptions2;
    private JSeparator separatorOptions3;
    private JMenuItem silhouetteCoefficientMenuItem;
    private JPanel statusBar_jPanel;
    private JLabel status_jLabel;
    private JToolBar toolBar;
    private JButton toolButton;
    private JMenuItem toolOptions;
    private JPanel toolbarPanel;
    private JButton zoomInButton;
    private JButton zoomOutButton;

    public GraphFrame() {
        this.initComponents();
        this.addSelection(new InstanceSelection(this));
        this.addSelection(new RangeSelection(this));
        this.addSelection(new CovarianceSelection(this));
        this.addSelection(new DynamicColorSelection(this));
    }

    private void initComponents() {
        this.selectionButtonGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.openButton = new JButton();
        this.saveButton = new JButton();
        this.separatorLabel1 = new JLabel();
        this.zoomInButton = new JButton();
        this.zoomOutButton = new JButton();
        this.separatorLabel2 = new JLabel();
        this.toolButton = new JButton();
        this.separatorLabel5 = new JLabel();
        this.runForceButton = new JButton();
        this.controlPanel = new JPanel();
        this.dataPanel = new JPanel();
        this.scrollPanel = new JScrollPane(this.view);
        this.scalarPanel = new JPanel();
        this.colorLabel = new JLabel();
        this.scalarCombo = new JExtendedComboBox((ComboBoxModel)this.scalarComboModel);
        this.edgeLabel = new JLabel();
        this.edgeCombo = new JExtendedComboBox((ComboBoxModel)this.edgeComboModel);
        this.statusBar_jPanel = new JPanel();
        this.status_jLabel = new JLabel();
        this.toolbarPanel = new JPanel();
        this.fixedToolBar = new JToolBar();
        this.moveInstancesToggleButton = new JToggleButton();
        this.cleanInstancesButton = new JButton();
        this.selectionToolBar = new JToolBar();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.fileOpen = new JMenuItem();
        this.fileSave = new JMenuItem();
        this.separator1 = new JSeparator();
        this.exportMenu = new JMenu();
        this.fileExportToPng = new JMenuItem();
        this.fileExportToProjection = new JMenuItem();
        this.menuEdit = new JMenu();
        this.editClean = new JMenuItem();
        this.editDelete = new JMenuItem();
        this.menuTool = new JMenu();
        this.memoryCheckMenuItem = new JMenuItem();
        this.separatorOptions1 = new JSeparator();
        this.scalarMenu = new JMenu();
        this.importScalarsOption = new JMenuItem();
        this.exportScalarsOption = new JMenuItem();
        this.joinScalarsOptions = new JMenuItem();
        this.separatorOptions2 = new JSeparator();
        this.clusteringMenu = new JMenu();
        this.multidimensionalMenuItem = new JMenuItem();
        this.silhouetteCoefficientMenuItem = new JMenuItem();
        this.separatorOptions3 = new JSeparator();
        this.toolOptions = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.openButton.setToolTipText("Open an existing projection");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.openButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.openButton);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.saveButton.setToolTipText("Save the current projection");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.saveButton);
        this.separatorLabel1.setText("       ");
        this.toolBar.add(this.separatorLabel1);
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        this.zoomInButton.setToolTipText("Zoom in");
        this.zoomInButton.setMaximumSize(new Dimension(29, 27));
        this.zoomInButton.setMinimumSize(new Dimension(29, 27));
        this.zoomInButton.setPreferredSize(new Dimension(29, 27));
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.zoomInButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.zoomInButton);
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        this.zoomOutButton.setToolTipText("Zoom out");
        this.zoomOutButton.setMaximumSize(new Dimension(29, 27));
        this.zoomOutButton.setMinimumSize(new Dimension(29, 27));
        this.zoomOutButton.setPreferredSize(new Dimension(29, 27));
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.zoomOutButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.zoomOutButton);
        this.separatorLabel2.setText("       ");
        this.toolBar.add(this.separatorLabel2);
        this.toolButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.toolButton.setToolTipText("Tool Preferences");
        this.toolButton.setMaximumSize(new Dimension(29, 27));
        this.toolButton.setMinimumSize(new Dimension(29, 27));
        this.toolButton.setPreferredSize(new Dimension(29, 27));
        this.toolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.toolButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.toolButton);
        this.separatorLabel5.setText("       ");
        this.toolBar.add(this.separatorLabel5);
        this.runForceButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Play16.gif")));
        this.runForceButton.setToolTipText("Run Force Directed Layout");
        this.runForceButton.setFocusable(false);
        this.runForceButton.setHorizontalTextPosition(0);
        this.runForceButton.setVerticalTextPosition(3);
        this.runForceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.runForceButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.runForceButton);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.controlPanel.setLayout(new BorderLayout());
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.add((Component)this.scrollPanel, "Center");
        this.scalarPanel.setBorder(BorderFactory.createEtchedBorder());
        this.colorLabel.setText("Color");
        this.scalarPanel.add(this.colorLabel);
        this.scalarCombo.setMaximumSize(new Dimension(85, 27));
        this.scalarCombo.setMinimumSize(new Dimension(85, 27));
        this.scalarCombo.setPreferredSize(new Dimension(85, 27));
        this.scalarCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GraphFrame.this.scalarComboItemStateChanged(evt);
            }
        });
        this.scalarPanel.add(this.scalarCombo);
        this.edgeLabel.setText("Edge");
        this.scalarPanel.add(this.edgeLabel);
        this.edgeCombo.setPreferredSize(new Dimension(85, 27));
        this.edgeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GraphFrame.this.edgeComboItemStateChanged(evt);
            }
        });
        this.scalarPanel.add(this.edgeCombo);
        this.dataPanel.add((Component)this.scalarPanel, "North");
        this.controlPanel.add((Component)this.dataPanel, "Center");
        this.statusBar_jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar_jPanel.setPreferredSize(new Dimension(30, 30));
        this.status_jLabel.setText("                      ");
        this.statusBar_jPanel.add(this.status_jLabel);
        this.controlPanel.add((Component)this.statusBar_jPanel, "Last");
        this.toolbarPanel.setLayout(new BorderLayout(0, 20));
        this.fixedToolBar.setOrientation(1);
        this.fixedToolBar.setRollover(true);
        this.moveInstancesToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward16.gif")));
        this.moveInstancesToggleButton.setToolTipText("Move Point");
        this.moveInstancesToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.moveInstancesToggleButtonActionPerformed(evt);
            }
        });
        this.fixedToolBar.add(this.moveInstancesToggleButton);
        this.cleanInstancesButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit16.gif")));
        this.cleanInstancesButton.setToolTipText("Clean Instances");
        this.cleanInstancesButton.setFocusable(false);
        this.cleanInstancesButton.setHorizontalTextPosition(0);
        this.cleanInstancesButton.setVerticalTextPosition(3);
        this.cleanInstancesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.cleanInstancesButtonActionPerformed(evt);
            }
        });
        this.fixedToolBar.add(this.cleanInstancesButton);
        this.toolbarPanel.add((Component)this.fixedToolBar, "North");
        this.selectionToolBar.setOrientation(1);
        this.toolbarPanel.add((Component)this.selectionToolBar, "Center");
        this.controlPanel.add((Component)this.toolbarPanel, "East");
        this.getContentPane().add((Component)this.controlPanel, "Center");
        this.menuFile.setMnemonic('F');
        this.menuFile.setText("File");
        this.fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileOpen.setMnemonic('O');
        this.fileOpen.setText("Open Projection");
        this.fileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.fileOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.fileOpen);
        this.fileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSave.setMnemonic('S');
        this.fileSave.setText("Save Projection");
        this.fileSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.fileSaveActionPerformed(evt);
            }
        });
        this.menuFile.add(this.fileSave);
        this.menuFile.add(this.separator1);
        this.exportMenu.setText("Export");
        this.fileExportToPng.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        this.fileExportToPng.setMnemonic('P');
        this.fileExportToPng.setText("Export PNG File");
        this.fileExportToPng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.fileExportToPngActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.fileExportToPng);
        this.fileExportToProjection.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.fileExportToProjection.setMnemonic('J');
        this.fileExportToProjection.setText("Export 2D Points File");
        this.fileExportToProjection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.fileExportToProjectionActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.fileExportToProjection);
        this.menuFile.add(this.exportMenu);
        this.menuBar.add(this.menuFile);
        this.menuEdit.setMnemonic('E');
        this.menuEdit.setText("Edit");
        this.editClean.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.editClean.setMnemonic('C');
        this.editClean.setText("Clean Projection");
        this.editClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.editCleanActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.editClean);
        this.editDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.editDelete.setMnemonic('D');
        this.editDelete.setText("Delete Points");
        this.editDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.editDeleteActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.editDelete);
        this.menuBar.add(this.menuEdit);
        this.menuTool.setMnemonic('T');
        this.menuTool.setText("Tool");
        this.memoryCheckMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 10));
        this.memoryCheckMenuItem.setMnemonic('H');
        this.memoryCheckMenuItem.setText("Memory Check");
        this.memoryCheckMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.memoryCheckMenuItemActionPerformed(evt);
            }
        });
        this.menuTool.add(this.memoryCheckMenuItem);
        this.menuTool.add(this.separatorOptions1);
        this.scalarMenu.setText("Scalar");
        this.importScalarsOption.setAccelerator(KeyStroke.getKeyStroke(73, 3));
        this.importScalarsOption.setMnemonic('S');
        this.importScalarsOption.setText("Import Scalars");
        this.importScalarsOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.importScalarsOptionActionPerformed(evt);
            }
        });
        this.scalarMenu.add(this.importScalarsOption);
        this.exportScalarsOption.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        this.exportScalarsOption.setMnemonic('x');
        this.exportScalarsOption.setText("Export Scalars");
        this.exportScalarsOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.exportScalarsOptionActionPerformed(evt);
            }
        });
        this.scalarMenu.add(this.exportScalarsOption);
        this.joinScalarsOptions.setAccelerator(KeyStroke.getKeyStroke(74, 3));
        this.joinScalarsOptions.setMnemonic('J');
        this.joinScalarsOptions.setText("Join Scalars");
        this.joinScalarsOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.joinScalarsOptionsActionPerformed(evt);
            }
        });
        this.scalarMenu.add(this.joinScalarsOptions);
        this.menuTool.add(this.scalarMenu);
        this.menuTool.add(this.separatorOptions2);
        this.clusteringMenu.setMnemonic('C');
        this.clusteringMenu.setText("Clustering");
        this.multidimensionalMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        this.multidimensionalMenuItem.setText("Multidimensional Data");
        this.multidimensionalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.multidimensionalMenuItemActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.multidimensionalMenuItem);
        this.silhouetteCoefficientMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.silhouetteCoefficientMenuItem.setText("Silhouette Coefficient");
        this.silhouetteCoefficientMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.silhouetteCoefficientMenuItemActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.silhouetteCoefficientMenuItem);
        this.menuTool.add(this.clusteringMenu);
        this.menuTool.add(this.separatorOptions3);
        this.toolOptions.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.toolOptions.setMnemonic('O');
        this.toolOptions.setText("Tool Options");
        this.toolOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.toolOptionsActionPerformed(evt);
            }
        });
        this.menuTool.add(this.toolOptions);
        this.menuBar.add(this.menuTool);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void fileOpenActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
            int result = OpenDialog.showOpenDialog(spm, new XMLFilter(), this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                try {
                    XMLGraphModelReader mreader = new XMLGraphModelReader();
                    GraphModel newmodel = new GraphModel();
                    mreader.read(newmodel, filename);
                    this.setModel(newmodel);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fileSaveActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
                int result = SaveDialog.showSaveDialog(spm, new XMLFilter(), this, "model.xml");
                if (result == 0) {
                    String filename = SaveDialog.getFilename();
                    try {
                        XMLGraphModelWriter mwriter = new XMLGraphModelWriter();
                        mwriter.write((GraphModel)this.model, filename);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void fileExportToPngActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
            int result = SaveDialog.showSaveDialog(spm, new PNGFilter(), this, "image.png");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                try {
                    this.view.saveToPngImageFile(filename);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fileExportToProjectionActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
                int result = SaveDialog.showSaveDialog(spm, new DATAFilter(), this, "projection.data");
                if (result == 0) {
                    String filename = SaveDialog.getFilename();
                    try {
                        AbstractMatrix matrix = ProjectionUtil.modelToMatrix((GraphModel)this.model, this.getCurrentScalar());
                        matrix.save(filename);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void editCleanActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.cleanSelectedInstances();
        }
    }

    private void editDeleteActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.removeSelectedInstances();
        }
    }

    private void memoryCheckMenuItemActionPerformed(ActionEvent evt) {
        MemoryCheck.showMemoryCheck();
    }

    private void importScalarsOptionActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
                int result = OpenDialog.showOpenDialog(spm, new SCALARFilter(), this);
                if (result == 0 && this.model != null) {
                    final MessageDialog dialog = MessageDialog.show(this, "Importing scalars...");
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                String filename = OpenDialog.getFilename();
                                ProjectionUtil.importScalars((GraphModel)GraphFrame.this.model, filename);
                                GraphFrame.this.updateScalars(null);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            finally {
                                dialog.close();
                            }
                        }
                    };
                    t.start();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void exportScalarsOptionActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
                int result = SaveDialog.showSaveDialog(spm, new SCALARFilter(), this, "scalars.scalar");
                if (result == 0 && this.model != null) {
                    String filename = SaveDialog.getFilename();
                    ProjectionUtil.exportScalars((GraphModel)this.model, filename);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void toolOptionsActionPerformed(ActionEvent evt) {
        GraphFameOptions.getInstance(this).display(this);
    }

    private void toolButtonActionPerformed(ActionEvent evt) {
        this.toolOptionsActionPerformed(evt);
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.zoomOut();
        }
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.zoomIn();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.fileSaveActionPerformed(evt);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.fileOpenActionPerformed(evt);
    }

    private void moveInstancesToggleButtonActionPerformed(ActionEvent evt) {
        this.moveinstances = this.moveInstancesToggleButton.isSelected();
    }

    private void cleanInstancesButtonActionPerformed(ActionEvent evt) {
        this.editCleanActionPerformed(evt);
    }

    private void joinScalarsOptionsActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            Scalar s = JoinScalars.getInstance(this).display((GraphModel)this.model);
            this.updateScalars(s);
        }
    }

    private void multidimensionalMenuItemActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            Scalar s = MultidimensionalClusteringView.getInstance(this).display((GraphModel)this.model);
            this.updateScalars(s);
        }
    }

    private void silhouetteCoefficientMenuItemActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            try {
                SilhouetteCoefficientView.getInstance(this).display((GraphModel)this.model, this.getCurrentScalar());
                this.updateScalars(null);
            }
            catch (IOException ex) {
                Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void scalarComboItemStateChanged(ItemEvent evt) {
        Scalar scalar;
        if (evt.getStateChange() == 2 && (scalar = (Scalar)this.scalarCombo.getSelectedItem()) != null) {
            this.view.colorAs(scalar);
        }
    }

    private void runForceButtonActionPerformed(ActionEvent evt) {
        boolean s = this.runForce();
        if (!s) {
            this.runForceButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Stop16.gif")));
            this.runForceButton.setToolTipText("Stop Force Directed Layout");
        } else {
            this.runForceButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Play16.gif")));
            this.runForceButton.setToolTipText("Run Force Directed Layout");
        }
    }

    private void edgeComboItemStateChanged(ItemEvent evt) {
        Connectivity conn;
        if (evt.getStateChange() == 2 && (conn = (Connectivity)this.edgeCombo.getSelectedItem()) != null) {
            this.view.drawEdges(conn);
        }
    }

    @Override
    public void setModel(AbstractModel model) {
        if (model instanceof GraphModel && model != null) {
            Dimension size = this.getSize();
            size.height = (int)((float)size.height * 0.75f);
            size.width = (int)((float)size.width * 0.95f);
            ((GraphModel)model).fitToSize(size);
            super.setModel(model);
            Scalar scalar = ((GraphModel)model).getSelectedScalar();
            if (scalar != null) {
                this.updateScalars(scalar);
            } else {
                this.updateScalars(((GraphModel)model).getScalars().get(0));
            }
            this.updateEdges(((GraphModel)model).getConnectivities().get(0));
            this.view.setModel((GraphModel)model);
        }
    }

    public void addSelection(final AbstractSelection selection) {
        if (selection != null) {
            JToggleButton button = new JToggleButton();
            this.selectionButtonGroup.add(button);
            button.setIcon(selection.getIcon());
            button.setSelected(false);
            button.setToolTipText(selection.toString());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (GraphFrame.this.view != null) {
                        GraphFrame.this.view.setSelection(selection);
                    }
                }
            });
            this.selectionToolBar.add(button);
        }
    }

    public void updateScalars(Scalar scalar) {
        this.scalarComboModel.removeAllElements();
        for (Scalar s : ((GraphModel)this.model).getScalars()) {
            this.scalarComboModel.addElement(s);
        }
        if (scalar != null) {
            this.scalarCombo.setSelectedItem(scalar);
            ((GraphModel)this.model).setSelectedScalar(scalar);
        } else {
            this.scalarCombo.setSelectedItem(((GraphModel)this.model).getSelectedScalar());
        }
        this.model.setChanged();
        this.model.notifyObservers();
    }

    public void updateEdges(Connectivity conn) {
        this.edgeComboModel.removeAllElements();
        for (Connectivity c : ((GraphModel)this.model).getConnectivities()) {
            this.edgeComboModel.addElement(c);
        }
        if (conn != null) {
            this.edgeCombo.setSelectedItem(conn);
            ((GraphModel)this.model).setSelectedConnectivity(conn);
        } else {
            this.edgeCombo.setSelectedItem(((GraphModel)this.model).getSelectedConnectivity());
        }
        this.model.setChanged();
        this.model.notifyObservers();
    }

    public void setViewerBackground(Color bg) {
        if (this.view != null) {
            this.view.setBackground(bg);
            this.view.cleanImage();
            this.view.repaint();
        }
    }

    public Scalar getCurrentScalar() {
        return (Scalar)this.scalarCombo.getSelectedItem();
    }

    public Connectivity getCurrentConnectivity() {
        return (Connectivity)this.edgeCombo.getSelectedItem();
    }

    public ViewPanel getView() {
        return this.view;
    }

    public boolean isHighQualityRender() {
        return this.highqualityrender;
    }

    public void setHighQualityRender(boolean highqualityrender) {
        this.highqualityrender = highqualityrender;
        this.view.cleanImage();
        this.view.repaint();
    }

    public boolean isShowInstanceLabel() {
        return this.showinstancelabel;
    }

    public void setShowInstanceLabel(boolean showinstancelabel) {
        this.showinstancelabel = showinstancelabel;
        this.view.cleanImage();
        this.view.repaint();
    }

    public boolean isMoveInstances() {
        return this.moveinstances;
    }

    public void setMoveInstance(boolean moveinstances) {
        this.moveinstances = moveinstances;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.model != null) {
            this.view.cleanImage();
            this.view.repaint();
        }
    }

    @Override
    public void addCoordinator(AbstractCoordinator coordinator) {
        super.addCoordinator(coordinator);
        this.addSelection(CoordinationSelectionFactory.getInstance(coordinator, this));
    }

    public void changeStatus(String status) {
        this.status_jLabel.setText(status);
        this.status_jLabel.update(this.status_jLabel.getGraphics());
        Rectangle r = this.status_jLabel.getGraphicsConfiguration().getBounds();
        this.status_jLabel.getGraphics().clearRect(r.x, r.y, r.width, r.height);
        this.status_jLabel.update(this.status_jLabel.getGraphics());
    }

    public boolean runForce() {
        if (this.model != null) {
            if (this.start) {
                for (AbstractInstance ai : this.model.getInstances()) {
                    GraphInstance gi = (GraphInstance)ai;
                    if (gi.fdata != null) continue;
                    gi.fdata = new ForceData();
                }
                this.force = new ForceDirectLayout((GraphModel)this.model, this);
                this.force.start(this.getCurrentConnectivity());
                this.start = false;
            } else {
                this.force.stop();
                this.start = true;
            }
        }
        this.model.setChanged();
        this.model.notifyObservers();
        return this.start;
    }

    public void updateImage() {
        if (this.view != null) {
            this.view.cleanImage();
            this.view.adjustPanel();
            this.view.repaint();
        }
    }

    public static void main(String[] args) {
        try {
            MatrixReaderComp reader = new MatrixReaderComp();
            reader.setFilename("D:\\Meus documentos\\FERNANDO\\Dados\\cbrilpirson.data");
            reader.execute();
            AbstractMatrix matrix = reader.output();
            NJConnectionComp nj = new NJConnectionComp();
            nj.setDissimilarityType(DissimilarityFactory.DissimilarityType.COSINE_BASED);
            nj.input(matrix);
            nj.execute();
            Connectivity con = nj.output();
            RadialLayoutComp radial = new RadialLayoutComp();
            radial.input(matrix, con);
            radial.execute();
            AbstractMatrix placement = radial.output();
            GraphModelComp modelcomp = new GraphModelComp();
            modelcomp.attach(con);
            modelcomp.input(placement);
            modelcomp.execute();
            GraphModel model = modelcomp.output();
            GraphFrameComp frame = new GraphFrameComp();
            frame.input(model);
            frame.execute();
        }
        catch (IOException ex) {
            Logger.getLogger(GraphFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public class ViewPanel
    extends JPanel {
        private GraphInstance selinstance;
        private Polygon selpolygon;
        private Point selsource;
        private Point seltarget;
        private Color selcolor = Color.RED;
        private String label;
        private Point labelpos;
        private BufferedImage image;
        private ColorScalePanel colorscale;
        private AbstractSelection selection;

        public ViewPanel() {
            this.setBackground(Color.WHITE);
            this.addMouseMotionListener(new MouseMotionListener());
            this.addMouseListener(new MouseClickedListener());
            this.setLayout(new FlowLayout(0));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (GraphFrame.this.model != null && this.image == null) {
                Dimension size = ((GraphModel)GraphFrame.this.model).getSize();
                this.image = new BufferedImage(size.width + 10, size.height + 10, 1);
                Graphics2D g2Buffer = this.image.createGraphics();
                g2Buffer.setColor(this.getBackground());
                g2Buffer.fillRect(0, 0, size.width + 10, size.height + 10);
                if (GraphFrame.this.highqualityrender) {
                    g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                ((GraphModel)GraphFrame.this.model).draw(this.image, GraphFrame.this.highqualityrender);
                g2Buffer.dispose();
            }
            if (this.image != null) {
                g2.drawImage((Image)this.image, 0, 0, null);
            }
            if (this.selsource != null && this.seltarget != null) {
                int x = this.selsource.x;
                int width = this.seltarget.x - this.selsource.x;
                int y = this.selsource.y;
                int height = this.seltarget.y - this.selsource.y;
                if (this.selsource.x > this.seltarget.x) {
                    x = this.seltarget.x;
                    width = this.selsource.x - this.seltarget.x;
                }
                if (this.selsource.y > this.seltarget.y) {
                    y = this.seltarget.y;
                    height = this.selsource.y - this.seltarget.y;
                }
                g2.setColor(this.selcolor);
                g2.drawRect(x, y, width, height);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.fillRect(x, y, width, height);
            } else if (GraphFrame.this.showinstancelabel && this.label != null && this.labelpos != null) {
                g2.setFont(this.getFont());
                FontMetrics metrics = g2.getFontMetrics(g2.getFont());
                int width = metrics.stringWidth(this.label);
                int height = metrics.getAscent();
                g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
                g2.setPaint(Color.WHITE);
                g2.fillRect(this.labelpos.x - 2, this.labelpos.y - height, width + 4, height + 4);
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g2.setColor(Color.DARK_GRAY);
                g2.drawRect(this.labelpos.x - 2, this.labelpos.y - height, width + 4, height + 4);
                g2.drawString(this.label, this.labelpos.x, this.labelpos.y);
            }
            if (this.selpolygon != null) {
                g2.setColor(this.selcolor);
                g2.drawPolygon(this.selpolygon);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.fillPolygon(this.selpolygon);
            }
        }

        public void saveToPngImageFile(String filename) throws IOException {
            try {
                Dimension size = ((GraphModel)GraphFrame.this.model).getSize();
                BufferedImage buffer = new BufferedImage(size.width + 10, size.height + 10, 1);
                this.paint(buffer.getGraphics());
                ImageIO.write((RenderedImage)buffer, "png", new File(filename));
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void cleanImage() {
            this.image = null;
        }

        public void setModel(GraphModel model) {
            this.colorscale = new ColorScalePanel(null);
            this.colorscale.setColorTable(model.getColorTable());
            this.colorscale.setPreferredSize(new Dimension(200, 12));
            this.removeAll();
            this.add(this.colorscale);
            this.colorscale.setBackground(this.getBackground());
            Dimension size = model.getSize();
            this.setPreferredSize(new Dimension(size.width * 2, size.height * 2));
            this.setSize(new Dimension(size.width * 2, size.height * 2));
            this.cleanImage();
            this.repaint();
        }

        public void setSelection(AbstractSelection selection) {
            this.selection = selection;
        }

        public void colorAs(Scalar scalar) {
            if (GraphFrame.this.model != null) {
                ((GraphModel)GraphFrame.this.model).setSelectedScalar(scalar);
                GraphFrame.this.model.notifyObservers();
            }
        }

        public void drawEdges(Connectivity conn) {
            if (GraphFrame.this.model != null) {
                ((GraphModel)GraphFrame.this.model).setSelectedConnectivity(conn);
                GraphFrame.this.model.notifyObservers();
            }
        }

        public void zoomIn() {
            if (GraphFrame.this.model != null) {
                ((GraphModel)GraphFrame.this.model).zoom(1.1f);
                Dimension size = ((GraphModel)GraphFrame.this.model).getSize();
                this.setPreferredSize(new Dimension(size.width * 2, size.height * 2));
                this.setSize(new Dimension(size.width * 2, size.height * 2));
                GraphFrame.this.model.notifyObservers();
            }
        }

        public void zoomOut() {
            if (GraphFrame.this.model != null) {
                ((GraphModel)GraphFrame.this.model).zoom(0.9091f);
                Dimension size = ((GraphModel)GraphFrame.this.model).getSize();
                this.setPreferredSize(new Dimension(size.width * 2, size.height * 2));
                this.setSize(new Dimension(size.width * 2, size.height * 2));
                GraphFrame.this.model.notifyObservers();
            }
        }

        public void adjustPanel() {
            float iniX = ((GraphInstance)GraphFrame.this.model.getInstances().get(0)).getX();
            float iniY = ((GraphInstance)GraphFrame.this.model.getInstances().get(0)).getY();
            float max_x = iniX;
            float max_y = iniX;
            float min_x = iniY;
            float min_y = iniY;
            int zero = 30;
            for (int i = 1; i < GraphFrame.this.model.getInstances().size(); ++i) {
                float x = ((GraphInstance)GraphFrame.this.model.getInstances().get(i)).getX();
                if (max_x < x) {
                    max_x = x;
                } else if (min_x > x) {
                    min_x = x;
                }
                float y = ((GraphInstance)GraphFrame.this.model.getInstances().get(i)).getY();
                if (max_y < y) {
                    max_y = y;
                    continue;
                }
                if (!(min_y > y)) continue;
                min_y = y;
            }
            for (AbstractInstance ai : GraphFrame.this.model.getInstances()) {
                GraphInstance pi = (GraphInstance)ai;
                pi.setX(pi.getX() + (float)zero - min_x);
                pi.setY(pi.getY() + (float)zero - min_y);
            }
            Dimension d = this.getSize();
            d.width = (int)max_x + zero;
            d.height = (int)max_y + zero;
            this.setSize(d);
            this.setPreferredSize(d);
            GraphFrame.this.model.notifyObservers();
        }

        public void cleanSelectedInstances() {
            if (GraphFrame.this.model != null) {
                GraphFrame.this.model.cleanSelectedInstances();
                GraphFrame.this.model.notifyObservers();
            }
        }

        public void removeSelectedInstances() {
            if (GraphFrame.this.model != null) {
                GraphFrame.this.model.removeSelectedInstances();
                GraphFrame.this.model.notifyObservers();
            }
        }

        public ArrayList<GraphInstance> getSelectedInstances(Polygon polygon) {
            ArrayList<GraphInstance> selected = new ArrayList<GraphInstance>();
            if (GraphFrame.this.model != null) {
                ArrayList<ProjectionInstance> selaux = ((GraphModel)GraphFrame.this.model).getInstancesByPosition(polygon);
                for (ProjectionInstance pi : selaux) {
                    if (!(pi instanceof GraphInstance)) continue;
                    selected.add((GraphInstance)pi);
                }
            }
            return selected;
        }

        public ArrayList<GraphInstance> getSelectedInstances(Point source, Point target) {
            ArrayList<GraphInstance> selinstances = new ArrayList<GraphInstance>();
            if (GraphFrame.this.model != null) {
                int x = Math.min(source.x, target.x);
                int width = Math.abs(source.x - target.x);
                int y = Math.min(source.y, target.y);
                int height = Math.abs(source.y - target.y);
                Rectangle rect = new Rectangle(x, y, width, height);
                ArrayList<ProjectionInstance> selaux = ((GraphModel)GraphFrame.this.model).getInstancesByPosition(rect);
                for (ProjectionInstance pi : selaux) {
                    if (!(pi instanceof GraphInstance)) continue;
                    selinstances.add((GraphInstance)pi);
                }
            }
            return selinstances;
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.colorscale != null) {
                this.colorscale.setBackground(bg);
            }
        }

        public void removeInstancesWithScalar(float val) {
            if (GraphFrame.this.model != null) {
                ArrayList<AbstractInstance> insts = new ArrayList<AbstractInstance>();
                Scalar scalar = ((GraphModel)GraphFrame.this.model).addScalar("cdata");
                for (AbstractInstance ai : GraphFrame.this.model.getInstances()) {
                    GraphInstance gi = (GraphInstance)ai;
                    if (gi.getScalarValue(scalar) != val) continue;
                    insts.add(gi);
                }
                GraphFrame.this.model.removeInstances(insts);
                GraphFrame.this.model.notifyObservers();
            }
        }

        class MouseClickedListener
        extends MouseAdapter {
            MouseClickedListener() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                super.mouseClicked(evt);
                if (evt.getButton() == 1) {
                    if (GraphFrame.this.model != null) {
                        ProjectionInstance instance = ((GraphModel)GraphFrame.this.model).getInstanceByPosition(evt.getPoint());
                        GraphFrame.this.changeStatus("Number of Instances in Selection: 0");
                        if (instance != null) {
                            GraphFrame.this.changeStatus("Number of Instances in Selection: 1");
                            GraphFrame.this.model.setSelectedInstance(instance);
                            GraphFrame.this.model.notifyObservers();
                        }
                    }
                } else if (evt.getButton() == 3) {
                    ViewPanel.this.cleanSelectedInstances();
                    GraphFrame.this.changeStatus("Number of Instances in Selection: 0");
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                super.mousePressed(evt);
                if (evt.getButton() == 1) {
                    if (GraphFrame.this.model != null) {
                        ProjectionInstance instance = ((GraphModel)GraphFrame.this.model).getInstanceByPosition(evt.getPoint());
                        if (instance != null) {
                            if (GraphFrame.this.moveinstances && GraphFrame.this.model.getSelectedInstances().contains(instance)) {
                                ViewPanel.this.selinstance = (GraphInstance)instance;
                            }
                        } else {
                            ViewPanel.this.selsource = evt.getPoint();
                        }
                    }
                } else if (evt.getButton() == 3) {
                    ViewPanel.this.selpolygon = new Polygon();
                    ViewPanel.this.selpolygon.addPoint(evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                super.mouseReleased(evt);
                if (GraphFrame.this.model != null && (ViewPanel.this.selsource != null && ViewPanel.this.seltarget != null || ViewPanel.this.selpolygon != null)) {
                    ArrayList<GraphInstance> instances = null;
                    instances = ViewPanel.this.selpolygon != null ? ViewPanel.this.getSelectedInstances(ViewPanel.this.selpolygon) : ViewPanel.this.getSelectedInstances(ViewPanel.this.selsource, ViewPanel.this.seltarget);
                    if (instances != null) {
                        float perc = 100.0f * ((float)instances.size() / (float)GraphFrame.this.model.getInstances().size());
                        DecimalFormat df = new DecimalFormat("0.##");
                        GraphFrame.this.changeStatus("Number of Instances in Selection: " + instances.size() + " (" + df.format(perc) + "%)");
                        if (ViewPanel.this.selection != null) {
                            ViewPanel.this.selection.selected(new ArrayList<AbstractInstance>(instances));
                        }
                    }
                }
                ViewPanel.this.selpolygon = null;
                ViewPanel.this.selinstance = null;
                ViewPanel.this.selsource = null;
                ViewPanel.this.seltarget = null;
            }
        }

        class MouseMotionListener
        extends MouseMotionAdapter {
            MouseMotionListener() {
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                super.mouseMoved(evt);
                if (GraphFrame.this.model != null) {
                    ProjectionInstance instance = ((GraphModel)GraphFrame.this.model).getInstanceByPosition(evt.getPoint());
                    if (instance != null) {
                        ViewPanel.this.label = instance.toString();
                        if (ViewPanel.this.label.trim().length() > 0) {
                            if (ViewPanel.this.label.length() > 100) {
                                ViewPanel.this.label = ViewPanel.this.label.substring(0, 96) + "...";
                            }
                            ViewPanel.this.labelpos = evt.getPoint();
                            ViewPanel.this.repaint();
                        }
                    } else {
                        ViewPanel.this.label = null;
                        ViewPanel.this.labelpos = null;
                        ViewPanel.this.repaint();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (ViewPanel.this.selinstance != null) {
                    if (GraphFrame.this.model.hasSelectedInstances()) {
                        float x = (float)evt.getX() - ViewPanel.this.selinstance.getX();
                        float y = (float)evt.getY() - ViewPanel.this.selinstance.getY();
                        for (AbstractInstance ai : GraphFrame.this.model.getSelectedInstances()) {
                            GraphInstance gi = (GraphInstance)ai;
                            gi.setX(x + gi.getX());
                            gi.setY(y + gi.getY());
                        }
                        ViewPanel.this.adjustPanel();
                    }
                } else if (ViewPanel.this.selsource != null) {
                    ViewPanel.this.seltarget = evt.getPoint();
                } else if (ViewPanel.this.selpolygon != null) {
                    ViewPanel.this.selpolygon.addPoint(evt.getX(), evt.getY());
                }
                ViewPanel.this.repaint();
            }
        }
    }
}

