/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.coordination.AbstractCoordinator;
import simpletree.model.GraphModel;
import simpletree.view.GraphFrame;
import simpletree.view.GraphFrameParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Graph.View", name="Graph View Frame", description="Display a graph model.")
public class GraphFrameComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String title = "";
    private transient GraphModel model;
    private transient GraphFrameParamView paramview;
    private transient ArrayList<AbstractCoordinator> coordinators;

    public void execute() throws IOException {
        if (this.model != null) {
            GraphFrame frame = new GraphFrame();
            frame.setSize(600, 600);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
            frame.setTitle(this.title);
            frame.setModel(this.model);
            if (this.coordinators != null) {
                for (int i = 0; i < this.coordinators.size(); ++i) {
                    frame.addCoordinator(this.coordinators.get(i));
                }
            }
        } else {
            throw new IOException("A projection model should be provided.");
        }
    }

    public void input(@Param(name="graph model") GraphModel model) {
        this.model = model;
    }

    public void attach(@Param(name="Coordinator") AbstractCoordinator coordinator) {
        if (this.coordinators == null) {
            this.coordinators = new ArrayList();
        }
        if (coordinator != null) {
            this.coordinators.add(coordinator);
        }
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new GraphFrameParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
        this.coordinators = null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }
}

