/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simpletree.basics.color.ColorScaleFactory;
import simpletree.basics.color.ColorScalePanel;
import simpletree.model.ProjectionModel;
import simpletree.view.ProjectionFrame;

public class ProjectionFameOptions
extends JDialog {
    private ProjectionFrame viewer;
    private JPanel adjustsPanel;
    private JSlider alphaSlider;
    private JButton backGroundButton;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel coloScalePanel;
    private JPanel colorChosePanel;
    private JPanel colorPanel;
    private JRadioButton highRadioButton;
    private JLabel jLabel1;
    private JSlider maxSlider;
    private JSlider minSlider;
    private JPanel paremetersPanel;
    private JRadioButton poorRadioButton;
    private JPanel qualityPanel;
    private ButtonGroup renderQualitybuttonGroup;
    private JCheckBox reverseScaleCheckBox;
    private JComboBox scaleComboBox;
    private JPanel scaleRangePanel;

    private ProjectionFameOptions(Frame parent) {
        super(parent);
        this.initComponents();
        for (ColorScaleFactory.ColorScaleType cst : ColorScaleFactory.ColorScaleType.values()) {
            this.scaleComboBox.addItem(cst);
        }
    }

    private void initComponents() {
        this.renderQualitybuttonGroup = new ButtonGroup();
        this.adjustsPanel = new JPanel();
        this.paremetersPanel = new JPanel();
        this.backGroundButton = new JButton();
        this.qualityPanel = new JPanel();
        this.highRadioButton = new JRadioButton();
        this.poorRadioButton = new JRadioButton();
        this.alphaSlider = new JSlider();
        this.colorPanel = new JPanel();
        this.scaleRangePanel = new JPanel();
        this.minSlider = new JSlider();
        this.maxSlider = new JSlider();
        this.coloScalePanel = new ColorScalePanel(null);
        this.reverseScaleCheckBox = new JCheckBox();
        this.colorChosePanel = new JPanel();
        this.scaleComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Projection Options");
        this.setModal(true);
        this.adjustsPanel.setBorder(BorderFactory.createTitledBorder("Adjustments "));
        this.adjustsPanel.setLayout(new GridBagLayout());
        this.paremetersPanel.setBorder(BorderFactory.createTitledBorder("Graphics Parameters"));
        this.paremetersPanel.setLayout(new GridBagLayout());
        this.backGroundButton.setText("BackGround Color");
        this.backGroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFameOptions.this.backGroundButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.paremetersPanel.add((Component)this.backGroundButton, gridBagConstraints);
        this.qualityPanel.setBorder(BorderFactory.createTitledBorder("Render Quality"));
        this.qualityPanel.setLayout(new GridBagLayout());
        this.renderQualitybuttonGroup.add(this.highRadioButton);
        this.highRadioButton.setSelected(true);
        this.highRadioButton.setText("High quality (slow)");
        this.highRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.highRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFameOptions.this.highRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.qualityPanel.add((Component)this.highRadioButton, gridBagConstraints);
        this.renderQualitybuttonGroup.add(this.poorRadioButton);
        this.poorRadioButton.setText("Poor quality (fast)");
        this.poorRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.poorRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFameOptions.this.poorRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.qualityPanel.add((Component)this.poorRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.qualityPanel, gridBagConstraints);
        this.alphaSlider.setPaintLabels(true);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setSnapToTicks(true);
        this.alphaSlider.setBorder(BorderFactory.createTitledBorder("Alpha"));
        this.alphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProjectionFameOptions.this.alphaSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.alphaSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.paremetersPanel, gridBagConstraints);
        this.colorPanel.setBorder(BorderFactory.createTitledBorder("Color Scale"));
        this.colorPanel.setLayout(new BorderLayout(3, 3));
        this.scaleRangePanel.setBorder(BorderFactory.createTitledBorder("Scale Range"));
        this.scaleRangePanel.setLayout(new GridBagLayout());
        this.minSlider.setMaximum(50);
        this.minSlider.setPaintLabels(true);
        this.minSlider.setPaintTicks(true);
        this.minSlider.setInverted(true);
        this.minSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProjectionFameOptions.this.minSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.minSlider, gridBagConstraints);
        this.maxSlider.setMaximum(50);
        this.maxSlider.setPaintLabels(true);
        this.maxSlider.setPaintTicks(true);
        this.maxSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProjectionFameOptions.this.maxSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.maxSlider, gridBagConstraints);
        this.coloScalePanel.setMinimumSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.coloScalePanel, gridBagConstraints);
        this.reverseScaleCheckBox.setText("Reverse Scale");
        this.reverseScaleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFameOptions.this.reverseScaleCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.reverseScaleCheckBox, gridBagConstraints);
        this.colorPanel.add((Component)this.scaleRangePanel, "South");
        this.colorChosePanel.setLayout(new GridBagLayout());
        this.scaleComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectionFameOptions.this.scaleComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.scaleComboBox, gridBagConstraints);
        this.jLabel1.setText("Scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.colorPanel.add((Component)this.colorChosePanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.colorPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.adjustsPanel, "Center");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFameOptions.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void backGroundButtonActionPerformed(ActionEvent evt) {
        Color color;
        if (this.viewer != null && (color = JColorChooser.showDialog(this, "Choose the Backgroud Color", Color.BLACK)) != null) {
            this.viewer.setViewerBackground(color);
        }
    }

    private void highRadioButtonActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            this.viewer.setHighQualityRender(true);
        }
    }

    private void poorRadioButtonActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            this.viewer.setHighQualityRender(false);
        }
    }

    private void alphaSliderStateChanged(ChangeEvent evt) {
        ProjectionModel model;
        if (this.viewer != null && (model = (ProjectionModel)this.viewer.getModel()) != null) {
            JSlider slider = (JSlider)evt.getSource();
            model.setAlpha((float)Math.pow((float)slider.getValue() / 100.0f, 2.0));
            model.notifyObservers();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.viewer = null;
        this.setVisible(false);
    }

    private void minSliderStateChanged(ChangeEvent evt) {
        if (this.viewer != null) {
            try {
                if (this.viewer.getModel() != null) {
                    float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum() / 2.0f;
                    float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum() / 2.0f;
                    ((ProjectionModel)this.viewer.getModel()).getColorTable().getColorScale().setMinMax(0.5f - min, max + 0.5f);
                }
                if (this.viewer.getView() != null) {
                    this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
                }
                this.coloScalePanel.repaint();
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFameOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void maxSliderStateChanged(ChangeEvent evt) {
        if (this.viewer != null) {
            try {
                if (this.viewer.getModel() != null) {
                    float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum() / 2.0f;
                    float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum() / 2.0f;
                    ((ProjectionModel)this.viewer.getModel()).getColorTable().getColorScale().setMinMax(0.5f - min, max + 0.5f);
                }
                if (this.viewer.getView() != null) {
                    this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
                }
                this.coloScalePanel.repaint();
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFameOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void reverseScaleCheckBoxActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            ProjectionModel model = (ProjectionModel)this.viewer.getModel();
            if (model != null) {
                model.getColorTable().getColorScale().setReverse(this.reverseScaleCheckBox.isSelected());
            }
            if (this.viewer.getView() != null) {
                this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
            }
            this.coloScalePanel.repaint();
        }
    }

    private void scaleComboBoxItemStateChanged(ItemEvent evt) {
        ColorScaleFactory.ColorScaleType type;
        if (this.viewer != null && evt.getStateChange() == 2 && (type = (ColorScaleFactory.ColorScaleType)((Object)this.scaleComboBox.getSelectedItem())) != null) {
            try {
                this.changeColorScale(type);
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFameOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static ProjectionFameOptions getInstance(JFrame parent) {
        return new ProjectionFameOptions(parent);
    }

    public void display(ProjectionFrame viewer) {
        if (viewer != null) {
            if (viewer.isHighQualityRender()) {
                this.highRadioButton.setSelected(true);
                this.poorRadioButton.setSelected(false);
            } else {
                this.highRadioButton.setSelected(false);
                this.poorRadioButton.setSelected(true);
            }
            ProjectionModel model = (ProjectionModel)viewer.getModel();
            if (model != null) {
                this.alphaSlider.setValue((int)(Math.sqrt(model.getAlpha()) * 100.0));
                this.scaleComboBox.setSelectedItem((Object)model.getColorTable().getColorScaleType());
                ((ColorScalePanel)this.coloScalePanel).setColorTable(model.getColorTable());
                this.reverseScaleCheckBox.setSelected(model.getColorTable().getColorScale().isReverse());
                this.maxSlider.setValue((int)(model.getColorTable().getColorScale().getMax() * (float)this.maxSlider.getMaximum()));
                this.minSlider.setValue((int)((1.0f - model.getColorTable().getColorScale().getMin() * 2.0f) * (float)this.minSlider.getMaximum()));
            }
        }
        this.viewer = viewer;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void changeColorScale(ColorScaleFactory.ColorScaleType scaletype) throws IOException {
        if (this.viewer != null && this.viewer.getModel() != null) {
            ProjectionModel model = (ProjectionModel)this.viewer.getModel();
            model.getColorTable().setColorScaleType(scaletype);
            float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum() / 2.0f;
            float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum() / 2.0f;
            model.getColorTable().getColorScale().setMinMax(0.5f - min, max + 0.5f);
            model.getColorTable().getColorScale().setReverse(this.reverseScaleCheckBox.isSelected());
            if (this.viewer != null && this.viewer.getView() != null) {
                this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
            }
            this.coloScalePanel.repaint();
        }
    }
}

