/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import simpletree.basics.color.ColorScalePanel;
import simpletree.coordination.AbstractCoordinator;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.reader.MatrixReaderComp;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.ProjectionModelComp;
import simpletree.model.Scalar;
import simpletree.model.XMLModelReader;
import simpletree.model.XMLModelWriter;
import simpletree.projection.technique.lsp.LSPProjection2DComp;
import simpletree.util.OpenDialog;
import simpletree.util.ProjectionUtil;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.PNGFilter;
import simpletree.util.filter.SCALARFilter;
import simpletree.util.filter.XMLFilter;
import simpletree.view.JExtendedComboBox;
import simpletree.view.JFrameModelViewer;
import simpletree.view.MemoryCheck;
import simpletree.view.MessageDialog;
import simpletree.view.ProjectionFameOptions;
import simpletree.view.ProjectionFrameComp;
import simpletree.view.selection.AbstractSelection;
import simpletree.view.selection.InstanceSelection;
import simpletree.view.selection.coordination.CoordinationSelectionFactory;
import simpletree.view.tools.JoinScalars;
import simpletree.view.tools.MultidimensionalClusteringView;
import simpletree.view.tools.SilhouetteCoefficientView;

public class ProjectionFrame
extends JFrameModelViewer {
    private DefaultComboBoxModel scalarComboModel = new DefaultComboBoxModel();
    private boolean highqualityrender = false;
    private boolean showinstancelabel = true;
    private boolean moveinstances = true;
    private ViewPanel view = new ViewPanel();
    private JButton cleanInstancesButton;
    private JMenu clusteringMenu;
    private JLabel colorLabel;
    private JPanel controlPanel;
    private JPanel dataPanel;
    private JMenuItem editClean;
    private JMenuItem editDelete;
    private JMenu exportMenu;
    private JMenuItem exportScalarsOption;
    private JMenuItem fileExportToPng;
    private JMenuItem fileExportToProjection;
    private JMenuItem fileOpen;
    private JMenuItem fileSave;
    private JButton findButton;
    private JPanel findPanel;
    private JTextField findTextField;
    private JToolBar fixedToolBar;
    private JMenuItem importScalarsOption;
    private JMenuItem joinScalarsOptions;
    private JMenuItem memoryCheckMenuItem;
    private JMenuBar menuBar;
    private JMenu menuEdit;
    private JMenu menuFile;
    private JMenu menuTool;
    private JToggleButton moveInstancesToggleButton;
    private JMenuItem multidimensionalMenuItem;
    private JButton openButton;
    private JButton saveButton;
    private JComboBox scalarCombo;
    private JMenu scalarMenu;
    private JPanel scalarPanel;
    private JScrollPane scrollPanel;
    private ButtonGroup selectionButtonGroup;
    private JToolBar selectionToolBar;
    private JSeparator separator1;
    private JLabel separatorLabel1;
    private JLabel separatorLabel2;
    private JLabel separatorLabel5;
    private JSeparator separatorOptions1;
    private JSeparator separatorOptions2;
    private JSeparator separatorOptions3;
    private JMenuItem silhouetteCoefficientMenuItem;
    private JPanel statusBar_jPanel;
    private JLabel status_jLabel;
    private JToolBar toolBar;
    private JButton toolButton;
    private JMenuItem toolOptions;
    private JPanel toolbarPanel;
    private JButton zoomInButton;
    private JButton zoomOutButton;

    public ProjectionFrame() {
        this.initComponents();
        this.addSelection(new InstanceSelection(this));
    }

    private void initComponents() {
        this.selectionButtonGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.openButton = new JButton();
        this.saveButton = new JButton();
        this.separatorLabel1 = new JLabel();
        this.zoomInButton = new JButton();
        this.zoomOutButton = new JButton();
        this.separatorLabel2 = new JLabel();
        this.toolButton = new JButton();
        this.separatorLabel5 = new JLabel();
        this.findPanel = new JPanel();
        this.findTextField = new JTextField();
        this.findButton = new JButton();
        this.controlPanel = new JPanel();
        this.dataPanel = new JPanel();
        this.scrollPanel = new JScrollPane(this.view);
        this.scalarPanel = new JPanel();
        this.colorLabel = new JLabel();
        this.scalarCombo = new JExtendedComboBox((ComboBoxModel)this.scalarComboModel);
        this.statusBar_jPanel = new JPanel();
        this.status_jLabel = new JLabel();
        this.toolbarPanel = new JPanel();
        this.fixedToolBar = new JToolBar();
        this.moveInstancesToggleButton = new JToggleButton();
        this.cleanInstancesButton = new JButton();
        this.selectionToolBar = new JToolBar();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.fileOpen = new JMenuItem();
        this.fileSave = new JMenuItem();
        this.separator1 = new JSeparator();
        this.exportMenu = new JMenu();
        this.fileExportToPng = new JMenuItem();
        this.fileExportToProjection = new JMenuItem();
        this.menuEdit = new JMenu();
        this.editClean = new JMenuItem();
        this.editDelete = new JMenuItem();
        this.menuTool = new JMenu();
        this.memoryCheckMenuItem = new JMenuItem();
        this.separatorOptions1 = new JSeparator();
        this.scalarMenu = new JMenu();
        this.importScalarsOption = new JMenuItem();
        this.exportScalarsOption = new JMenuItem();
        this.joinScalarsOptions = new JMenuItem();
        this.separatorOptions2 = new JSeparator();
        this.clusteringMenu = new JMenu();
        this.multidimensionalMenuItem = new JMenuItem();
        this.silhouetteCoefficientMenuItem = new JMenuItem();
        this.separatorOptions3 = new JSeparator();
        this.toolOptions = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.openButton.setToolTipText("Open an existing projection");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.openButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.openButton);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.saveButton.setToolTipText("Save the current projection");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.saveButton);
        this.separatorLabel1.setText("       ");
        this.toolBar.add(this.separatorLabel1);
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        this.zoomInButton.setToolTipText("Zoom in");
        this.zoomInButton.setMaximumSize(new Dimension(29, 27));
        this.zoomInButton.setMinimumSize(new Dimension(29, 27));
        this.zoomInButton.setPreferredSize(new Dimension(29, 27));
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.zoomInButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.zoomInButton);
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        this.zoomOutButton.setToolTipText("Zoom out");
        this.zoomOutButton.setMaximumSize(new Dimension(29, 27));
        this.zoomOutButton.setMinimumSize(new Dimension(29, 27));
        this.zoomOutButton.setPreferredSize(new Dimension(29, 27));
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.zoomOutButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.zoomOutButton);
        this.separatorLabel2.setText("       ");
        this.toolBar.add(this.separatorLabel2);
        this.toolButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.toolButton.setToolTipText("Tool Preferences");
        this.toolButton.setMaximumSize(new Dimension(29, 27));
        this.toolButton.setMinimumSize(new Dimension(29, 27));
        this.toolButton.setPreferredSize(new Dimension(29, 27));
        this.toolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.toolButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.toolButton);
        this.separatorLabel5.setText("       ");
        this.toolBar.add(this.separatorLabel5);
        this.findPanel.setOpaque(false);
        this.findPanel.setLayout(new FlowLayout(2));
        this.findTextField.setColumns(10);
        this.findTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ProjectionFrame.this.findTextFieldKeyPressed(evt);
            }
        });
        this.findPanel.add(this.findTextField);
        this.findButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Find16.gif")));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.findButtonActionPerformed(evt);
            }
        });
        this.findPanel.add(this.findButton);
        this.toolBar.add(this.findPanel);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.controlPanel.setLayout(new BorderLayout());
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.add((Component)this.scrollPanel, "Center");
        this.scalarPanel.setBorder(BorderFactory.createEtchedBorder());
        this.colorLabel.setText("Color");
        this.scalarPanel.add(this.colorLabel);
        this.scalarCombo.setMaximumSize(new Dimension(85, 27));
        this.scalarCombo.setMinimumSize(new Dimension(85, 27));
        this.scalarCombo.setPreferredSize(new Dimension(85, 27));
        this.scalarCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectionFrame.this.scalarComboItemStateChanged(evt);
            }
        });
        this.scalarPanel.add(this.scalarCombo);
        this.dataPanel.add((Component)this.scalarPanel, "North");
        this.controlPanel.add((Component)this.dataPanel, "Center");
        this.statusBar_jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar_jPanel.setPreferredSize(new Dimension(30, 30));
        this.status_jLabel.setText("                      ");
        this.statusBar_jPanel.add(this.status_jLabel);
        this.controlPanel.add((Component)this.statusBar_jPanel, "Last");
        this.toolbarPanel.setLayout(new BorderLayout(0, 20));
        this.fixedToolBar.setOrientation(1);
        this.fixedToolBar.setRollover(true);
        this.moveInstancesToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward16.gif")));
        this.moveInstancesToggleButton.setToolTipText("Move Point");
        this.moveInstancesToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.moveInstancesToggleButtonActionPerformed(evt);
            }
        });
        this.fixedToolBar.add(this.moveInstancesToggleButton);
        this.cleanInstancesButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Edit16.gif")));
        this.cleanInstancesButton.setToolTipText("Clean Instances");
        this.cleanInstancesButton.setFocusable(false);
        this.cleanInstancesButton.setHorizontalTextPosition(0);
        this.cleanInstancesButton.setVerticalTextPosition(3);
        this.cleanInstancesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.cleanInstancesButtonActionPerformed(evt);
            }
        });
        this.fixedToolBar.add(this.cleanInstancesButton);
        this.toolbarPanel.add((Component)this.fixedToolBar, "North");
        this.selectionToolBar.setOrientation(1);
        this.toolbarPanel.add((Component)this.selectionToolBar, "Center");
        this.controlPanel.add((Component)this.toolbarPanel, "East");
        this.getContentPane().add((Component)this.controlPanel, "Center");
        this.menuFile.setMnemonic('F');
        this.menuFile.setText("File");
        this.fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileOpen.setMnemonic('O');
        this.fileOpen.setText("Open Projection");
        this.fileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.fileOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.fileOpen);
        this.fileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSave.setMnemonic('S');
        this.fileSave.setText("Save Projection");
        this.fileSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.fileSaveActionPerformed(evt);
            }
        });
        this.menuFile.add(this.fileSave);
        this.menuFile.add(this.separator1);
        this.exportMenu.setText("Export");
        this.fileExportToPng.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        this.fileExportToPng.setMnemonic('P');
        this.fileExportToPng.setText("Export PNG File");
        this.fileExportToPng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.fileExportToPngActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.fileExportToPng);
        this.fileExportToProjection.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.fileExportToProjection.setMnemonic('J');
        this.fileExportToProjection.setText("Export 2D Points File");
        this.fileExportToProjection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.fileExportToProjectionActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.fileExportToProjection);
        this.menuFile.add(this.exportMenu);
        this.menuBar.add(this.menuFile);
        this.menuEdit.setMnemonic('E');
        this.menuEdit.setText("Edit");
        this.editClean.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.editClean.setMnemonic('C');
        this.editClean.setText("Clean Projection");
        this.editClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.editCleanActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.editClean);
        this.editDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.editDelete.setMnemonic('D');
        this.editDelete.setText("Delete Points");
        this.editDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.editDeleteActionPerformed(evt);
            }
        });
        this.menuEdit.add(this.editDelete);
        this.menuBar.add(this.menuEdit);
        this.menuTool.setMnemonic('T');
        this.menuTool.setText("Tool");
        this.memoryCheckMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 10));
        this.memoryCheckMenuItem.setMnemonic('H');
        this.memoryCheckMenuItem.setText("Memory Check");
        this.memoryCheckMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.memoryCheckMenuItemActionPerformed(evt);
            }
        });
        this.menuTool.add(this.memoryCheckMenuItem);
        this.menuTool.add(this.separatorOptions1);
        this.scalarMenu.setText("Scalar");
        this.importScalarsOption.setAccelerator(KeyStroke.getKeyStroke(73, 3));
        this.importScalarsOption.setMnemonic('S');
        this.importScalarsOption.setText("Import Scalars");
        this.importScalarsOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.importScalarsOptionActionPerformed(evt);
            }
        });
        this.scalarMenu.add(this.importScalarsOption);
        this.exportScalarsOption.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        this.exportScalarsOption.setMnemonic('x');
        this.exportScalarsOption.setText("Export Scalars");
        this.exportScalarsOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.exportScalarsOptionActionPerformed(evt);
            }
        });
        this.scalarMenu.add(this.exportScalarsOption);
        this.joinScalarsOptions.setAccelerator(KeyStroke.getKeyStroke(74, 3));
        this.joinScalarsOptions.setMnemonic('J');
        this.joinScalarsOptions.setText("Join Scalars");
        this.joinScalarsOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.joinScalarsOptionsActionPerformed(evt);
            }
        });
        this.scalarMenu.add(this.joinScalarsOptions);
        this.menuTool.add(this.scalarMenu);
        this.menuTool.add(this.separatorOptions2);
        this.clusteringMenu.setMnemonic('C');
        this.clusteringMenu.setText("Clustering");
        this.multidimensionalMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        this.multidimensionalMenuItem.setText("Multidimensional Data");
        this.multidimensionalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.multidimensionalMenuItemActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.multidimensionalMenuItem);
        this.silhouetteCoefficientMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.silhouetteCoefficientMenuItem.setText("Silhouette Coefficient");
        this.silhouetteCoefficientMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.silhouetteCoefficientMenuItemActionPerformed(evt);
            }
        });
        this.clusteringMenu.add(this.silhouetteCoefficientMenuItem);
        this.menuTool.add(this.clusteringMenu);
        this.menuTool.add(this.separatorOptions3);
        this.toolOptions.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.toolOptions.setMnemonic('O');
        this.toolOptions.setText("Tool Options");
        this.toolOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectionFrame.this.toolOptionsActionPerformed(evt);
            }
        });
        this.menuTool.add(this.toolOptions);
        this.menuBar.add(this.menuTool);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void fileOpenActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, new XMLFilter(), this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                try {
                    XMLModelReader mreader = new XMLModelReader();
                    ProjectionModel newmodel = new ProjectionModel();
                    mreader.read(newmodel, filename);
                    this.setModel(newmodel);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Problems opening the file", 0);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fileSaveActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                int result = SaveDialog.showSaveDialog(spm, new XMLFilter(), this, "model.xml");
                if (result == 0) {
                    String filename = SaveDialog.getFilename();
                    try {
                        XMLModelWriter mwriter = new XMLModelWriter();
                        mwriter.write((ProjectionModel)this.model, filename);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void fileExportToPngActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = SaveDialog.showSaveDialog(spm, new PNGFilter(), this, "image.png");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                try {
                    this.view.saveToPngImageFile(filename);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fileExportToProjectionActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                int result = SaveDialog.showSaveDialog(spm, new DATAFilter(), this, "projection.data");
                if (result == 0) {
                    String filename = SaveDialog.getFilename();
                    try {
                        AbstractMatrix matrix = ProjectionUtil.modelToMatrix((ProjectionModel)this.model, this.getCurrentScalar());
                        matrix.save(filename);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        JOptionPane.showMessageDialog(this, e.getMessage(), "Problems saving the file", 0);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void editCleanActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.cleanSelectedInstances();
        }
    }

    private void editDeleteActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.removeSelectedInstances();
        }
    }

    private void toolButtonActionPerformed(ActionEvent evt) {
        this.toolOptionsActionPerformed(evt);
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.zoomOut();
        }
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            this.view.zoomIn();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.fileSaveActionPerformed(evt);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.fileOpenActionPerformed(evt);
    }

    private void moveInstancesToggleButtonActionPerformed(ActionEvent evt) {
        this.moveinstances = this.moveInstancesToggleButton.isSelected();
    }

    private void cleanInstancesButtonActionPerformed(ActionEvent evt) {
        this.editCleanActionPerformed(evt);
    }

    private void scalarComboItemStateChanged(ItemEvent evt) {
        Scalar scalar;
        if (evt.getStateChange() == 2 && (scalar = (Scalar)this.scalarCombo.getSelectedItem()) != null) {
            this.view.colorAs(scalar);
        }
    }

    private void toolOptionsActionPerformed(ActionEvent evt) {
        ProjectionFameOptions.getInstance(this).display(this);
    }

    private void silhouetteCoefficientMenuItemActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            try {
                SilhouetteCoefficientView.getInstance(this).display((ProjectionModel)this.model, this.getCurrentScalar());
                this.updateScalars(null);
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void multidimensionalMenuItemActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            Scalar s = MultidimensionalClusteringView.getInstance(this).display((ProjectionModel)this.model);
            this.updateScalars(s);
        }
    }

    private void joinScalarsOptionsActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            Scalar s = JoinScalars.getInstance(this).display((ProjectionModel)this.model);
            this.updateScalars(s);
        }
    }

    private void exportScalarsOptionActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                int result = SaveDialog.showSaveDialog(spm, new SCALARFilter(), this, "scalars.scalar");
                if (result == 0 && this.model != null) {
                    String filename = SaveDialog.getFilename();
                    ProjectionUtil.exportScalars((ProjectionModel)this.model, filename);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void importScalarsOptionActionPerformed(ActionEvent evt) {
        if (this.view != null) {
            try {
                PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
                int result = OpenDialog.showOpenDialog(spm, new SCALARFilter(), this);
                if (result == 0 && this.model != null) {
                    final MessageDialog dialog = MessageDialog.show(this, "Importing scalars...");
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                String filename = OpenDialog.getFilename();
                                ProjectionUtil.importScalars((ProjectionModel)ProjectionFrame.this.model, filename);
                                ProjectionFrame.this.updateScalars(null);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            finally {
                                dialog.close();
                            }
                        }
                    };
                    t.start();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void memoryCheckMenuItemActionPerformed(ActionEvent evt) {
        MemoryCheck.showMemoryCheck();
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            this.model.cleanSelectedInstances();
            Pattern p = Pattern.compile(this.findTextField.getText().trim().toLowerCase());
            int begin = 0;
            int end = this.model.getInstances().size();
            boolean stop = false;
            boolean restart = true;
            while (!stop) {
                for (int i = begin; i < end; ++i) {
                    Matcher m = p.matcher(this.model.getInstances().get(i).toString().trim().toLowerCase());
                    if (!m.find()) continue;
                    this.model.setSelectedInstance(this.model.getInstances().get(i));
                    stop = true;
                    break;
                }
                if (restart) {
                    end = begin - 2;
                    begin = 0;
                    restart = false;
                    continue;
                }
                stop = true;
            }
            this.model.setChanged();
            this.model.notifyObservers();
        }
    }

    private void findTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.findButtonActionPerformed(null);
        }
    }

    @Override
    public void setModel(AbstractModel model) {
        if (model instanceof ProjectionModel && model != null) {
            Dimension size = this.getSize();
            size.height = (int)((float)size.height * 0.75f);
            size.width = (int)((float)size.width * 0.95f);
            ((ProjectionModel)model).fitToSize(size);
            super.setModel(model);
            Scalar scalar = ((ProjectionModel)model).getSelectedScalar();
            if (scalar != null) {
                this.updateScalars(scalar);
            } else {
                this.updateScalars(((ProjectionModel)model).getScalars().get(0));
            }
            this.view.setModel((ProjectionModel)model);
        }
    }

    public final void addSelection(final AbstractSelection selection) {
        if (selection != null) {
            JToggleButton button = new JToggleButton();
            this.selectionButtonGroup.add(button);
            button.setIcon(selection.getIcon());
            button.setSelected(false);
            button.setToolTipText(selection.toString());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ProjectionFrame.this.view != null) {
                        ProjectionFrame.this.view.setSelection(selection);
                    }
                }
            });
            this.selectionToolBar.add(button);
        }
    }

    public void updateScalars(Scalar scalar) {
        this.scalarComboModel.removeAllElements();
        for (Scalar s : ((ProjectionModel)this.model).getScalars()) {
            this.scalarComboModel.addElement(s);
        }
        if (scalar != null) {
            this.scalarCombo.setSelectedItem(scalar);
            ((ProjectionModel)this.model).setSelectedScalar(scalar);
        } else {
            this.scalarCombo.setSelectedItem(((ProjectionModel)this.model).getSelectedScalar());
        }
        this.model.setChanged();
        this.model.notifyObservers();
    }

    public void setViewerBackground(Color bg) {
        if (this.view != null) {
            this.view.setBackground(bg);
            this.view.cleanImage();
            this.view.repaint();
        }
    }

    public Scalar getCurrentScalar() {
        return (Scalar)this.scalarCombo.getSelectedItem();
    }

    public ViewPanel getView() {
        return this.view;
    }

    public boolean isHighQualityRender() {
        return this.highqualityrender;
    }

    public void setHighQualityRender(boolean highqualityrender) {
        this.highqualityrender = highqualityrender;
        this.view.cleanImage();
        this.view.repaint();
    }

    public boolean isShowInstanceLabel() {
        return this.showinstancelabel;
    }

    public void setShowInstanceLabel(boolean showinstancelabel) {
        this.showinstancelabel = showinstancelabel;
        this.view.cleanImage();
        this.view.repaint();
    }

    public boolean isMoveInstances() {
        return this.moveinstances;
    }

    public void setMoveInstance(boolean moveinstances) {
        this.moveinstances = moveinstances;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.model != null) {
            this.view.cleanImage();
            this.view.repaint();
        }
    }

    @Override
    public void addCoordinator(AbstractCoordinator coordinator) {
        super.addCoordinator(coordinator);
        this.addSelection(CoordinationSelectionFactory.getInstance(coordinator, this));
    }

    public void changeStatus(String status) {
        this.status_jLabel.setText(status);
        this.status_jLabel.update(this.status_jLabel.getGraphics());
        Rectangle r = this.status_jLabel.getGraphicsConfiguration().getBounds();
        this.status_jLabel.getGraphics().clearRect(r.x, r.y, r.width, r.height);
        this.status_jLabel.update(this.status_jLabel.getGraphics());
    }

    public void updateImage() {
        if (this.view != null) {
            this.view.cleanImage();
            this.view.adjustPanel();
            this.view.repaint();
        }
    }

    public static void main(String[] args) {
        try {
            MatrixReaderComp reader = new MatrixReaderComp();
            reader.setFilename("D:\\Meus documentos\\FERNANDO\\mammals-10000.data-normcols.data");
            reader.execute();
            LSPProjection2DComp proj = new LSPProjection2DComp();
            proj.setDissimilarityType(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
            proj.setNumberIterations(50);
            proj.setFractionDelta(8.0f);
            proj.setNumberControlPoints(68);
            proj.setNumberNeighbors(10);
            proj.input(reader.output());
            proj.execute();
            ProjectionModelComp mcomp1 = new ProjectionModelComp();
            mcomp1.input(proj.output());
            mcomp1.execute();
            ProjectionFrameComp fcomp1 = new ProjectionFrameComp();
            fcomp1.input(mcomp1.output());
            fcomp1.execute();
        }
        catch (IOException ex) {
            Logger.getLogger(ProjectionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public class ViewPanel
    extends JPanel {
        private ProjectionInstance selinstance;
        private Polygon selpolygon;
        private Point selsource;
        private Point seltarget;
        private Color selcolor = Color.RED;
        private ProjectionInstance labelins;
        private Point labelpos;
        private BufferedImage image;
        private ColorScalePanel colorscale;
        private AbstractSelection selection;

        public ViewPanel() {
            this.setBackground(Color.WHITE);
            this.addMouseMotionListener(new MouseMotionListener());
            this.addMouseListener(new MouseClickedListener());
            this.setLayout(new FlowLayout(0));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (ProjectionFrame.this.model != null && this.image == null) {
                Dimension size = ((ProjectionModel)ProjectionFrame.this.model).getSize();
                this.image = new BufferedImage(size.width + 10, size.height + 10, 1);
                Graphics2D g2Buffer = this.image.createGraphics();
                g2Buffer.setColor(this.getBackground());
                g2Buffer.fillRect(0, 0, size.width + 10, size.height + 10);
                if (ProjectionFrame.this.highqualityrender) {
                    g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                ((ProjectionModel)ProjectionFrame.this.model).draw(this.image, ProjectionFrame.this.highqualityrender);
                g2Buffer.dispose();
            }
            if (this.image != null) {
                g2.drawImage((Image)this.image, 0, 0, null);
            }
            if (this.selsource != null && this.seltarget != null) {
                int x = this.selsource.x;
                int width = this.seltarget.x - this.selsource.x;
                int y = this.selsource.y;
                int height = this.seltarget.y - this.selsource.y;
                if (this.selsource.x > this.seltarget.x) {
                    x = this.seltarget.x;
                    width = this.selsource.x - this.seltarget.x;
                }
                if (this.selsource.y > this.seltarget.y) {
                    y = this.seltarget.y;
                    height = this.selsource.y - this.seltarget.y;
                }
                g2.setColor(this.selcolor);
                g2.drawRect(x, y, width, height);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.fillRect(x, y, width, height);
            } else if (ProjectionFrame.this.showinstancelabel && this.labelins != null && this.labelpos != null && !this.labelins.isSelected()) {
                this.labelins.drawLabel(g2, this.labelpos.x, this.labelpos.y);
            }
            if (this.selpolygon != null) {
                g2.setColor(this.selcolor);
                g2.drawPolygon(this.selpolygon);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.fillPolygon(this.selpolygon);
            }
        }

        public void saveToPngImageFile(String filename) throws IOException {
            try {
                Dimension size = ((ProjectionModel)ProjectionFrame.this.model).getSize();
                BufferedImage buffer = new BufferedImage(size.width + 10, size.height + 10, 1);
                this.paint(buffer.getGraphics());
                ImageIO.write((RenderedImage)buffer, "png", new File(filename));
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void cleanImage() {
            this.image = null;
        }

        public void setModel(ProjectionModel model) {
            this.colorscale = new ColorScalePanel(null);
            this.colorscale.setColorTable(model.getColorTable());
            this.colorscale.setPreferredSize(new Dimension(200, 12));
            this.removeAll();
            this.add(this.colorscale);
            this.colorscale.setBackground(this.getBackground());
            Dimension size = model.getSize();
            this.setPreferredSize(new Dimension(size.width * 2, size.height * 2));
            this.setSize(new Dimension(size.width * 2, size.height * 2));
            this.cleanImage();
            this.repaint();
        }

        public void setSelection(AbstractSelection selection) {
            this.selection = selection;
        }

        public void colorAs(Scalar scalar) {
            if (ProjectionFrame.this.model != null) {
                ((ProjectionModel)ProjectionFrame.this.model).setSelectedScalar(scalar);
                ProjectionFrame.this.model.notifyObservers();
            }
        }

        public void zoomIn() {
            if (ProjectionFrame.this.model != null) {
                ((ProjectionModel)ProjectionFrame.this.model).zoom(1.1f);
                Dimension size = ((ProjectionModel)ProjectionFrame.this.model).getSize();
                this.setPreferredSize(new Dimension(size.width * 2, size.height * 2));
                this.setSize(new Dimension(size.width * 2, size.height * 2));
                ProjectionFrame.this.model.notifyObservers();
            }
        }

        public void zoomOut() {
            if (ProjectionFrame.this.model != null) {
                ((ProjectionModel)ProjectionFrame.this.model).zoom(0.9091f);
                Dimension size = ((ProjectionModel)ProjectionFrame.this.model).getSize();
                this.setPreferredSize(new Dimension(size.width * 2, size.height * 2));
                this.setSize(new Dimension(size.width * 2, size.height * 2));
                ProjectionFrame.this.model.notifyObservers();
            }
        }

        public void adjustPanel() {
            float iniX = ((ProjectionInstance)ProjectionFrame.this.model.getInstances().get(0)).getX();
            float iniY = ((ProjectionInstance)ProjectionFrame.this.model.getInstances().get(0)).getY();
            float max_x = iniX;
            float max_y = iniX;
            float min_x = iniY;
            float min_y = iniY;
            int zero = 30;
            for (int i = 1; i < ProjectionFrame.this.model.getInstances().size(); ++i) {
                float x = ((ProjectionInstance)ProjectionFrame.this.model.getInstances().get(i)).getX();
                if (max_x < x) {
                    max_x = x;
                } else if (min_x > x) {
                    min_x = x;
                }
                float y = ((ProjectionInstance)ProjectionFrame.this.model.getInstances().get(i)).getY();
                if (max_y < y) {
                    max_y = y;
                    continue;
                }
                if (!(min_y > y)) continue;
                min_y = y;
            }
            for (AbstractInstance ai : ProjectionFrame.this.model.getInstances()) {
                ProjectionInstance pi = (ProjectionInstance)ai;
                pi.setX(pi.getX() + (float)zero - min_x);
                pi.setY(pi.getY() + (float)zero - min_y);
            }
            Dimension d = this.getSize();
            d.width = (int)max_x + zero;
            d.height = (int)max_y + zero;
            this.setSize(d);
            this.setPreferredSize(d);
            ProjectionFrame.this.model.notifyObservers();
        }

        public void cleanSelectedInstances() {
            if (ProjectionFrame.this.model != null) {
                ProjectionFrame.this.model.cleanSelectedInstances();
                ProjectionFrame.this.model.notifyObservers();
            }
        }

        public void removeSelectedInstances() {
            if (ProjectionFrame.this.model != null) {
                ProjectionFrame.this.model.removeSelectedInstances();
                ProjectionFrame.this.model.notifyObservers();
            }
        }

        public ArrayList<ProjectionInstance> getSelectedInstances(Polygon polygon) {
            ArrayList<ProjectionInstance> selected = new ArrayList<ProjectionInstance>();
            if (ProjectionFrame.this.model != null) {
                selected = ((ProjectionModel)ProjectionFrame.this.model).getInstancesByPosition(polygon);
            }
            return selected;
        }

        public ArrayList<ProjectionInstance> getSelectedInstances(Point source, Point target) {
            ArrayList<ProjectionInstance> selinstances = new ArrayList<ProjectionInstance>();
            if (ProjectionFrame.this.model != null) {
                int x = Math.min(source.x, target.x);
                int width = Math.abs(source.x - target.x);
                int y = Math.min(source.y, target.y);
                int height = Math.abs(source.y - target.y);
                Rectangle rect = new Rectangle(x, y, width, height);
                selinstances = ((ProjectionModel)ProjectionFrame.this.model).getInstancesByPosition(rect);
            }
            return selinstances;
        }

        @Override
        public final void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.colorscale != null) {
                this.colorscale.setBackground(bg);
            }
        }

        public void removeInstancesWithScalar(float val) {
            if (ProjectionFrame.this.model != null) {
                ArrayList<AbstractInstance> insts = new ArrayList<AbstractInstance>();
                Scalar scalar = ((ProjectionModel)ProjectionFrame.this.model).addScalar("cdata");
                for (AbstractInstance ai : ProjectionFrame.this.model.getInstances()) {
                    if (((ProjectionInstance)ai).getScalarValue(scalar) != val) continue;
                    insts.add(ai);
                }
                ProjectionFrame.this.model.removeInstances(insts);
                ProjectionFrame.this.model.notifyObservers();
            }
        }

        class MouseClickedListener
        extends MouseAdapter {
            MouseClickedListener() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                super.mouseClicked(evt);
                if (evt.getButton() == 1) {
                    if (ProjectionFrame.this.model != null) {
                        ProjectionInstance instance = ((ProjectionModel)ProjectionFrame.this.model).getInstanceByPosition(evt.getPoint());
                        ProjectionFrame.this.changeStatus("Number of Instances in Selection: 0");
                        if (instance != null) {
                            ProjectionFrame.this.changeStatus("Number of Instances in Selection: 1");
                            ProjectionFrame.this.model.setSelectedInstance(instance);
                            ProjectionFrame.this.model.notifyObservers();
                        }
                    }
                } else if (evt.getButton() == 3) {
                    ViewPanel.this.cleanSelectedInstances();
                    ProjectionFrame.this.changeStatus("Number of Instances in Selection: 0");
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                super.mousePressed(evt);
                if (evt.getButton() == 1) {
                    if (ProjectionFrame.this.model != null) {
                        ProjectionInstance instance = ((ProjectionModel)ProjectionFrame.this.model).getInstanceByPosition(evt.getPoint());
                        if (instance != null) {
                            if (ProjectionFrame.this.moveinstances && ProjectionFrame.this.model.getSelectedInstances().contains(instance)) {
                                ViewPanel.this.selinstance = instance;
                            }
                        } else {
                            ViewPanel.this.selsource = evt.getPoint();
                        }
                    }
                } else if (evt.getButton() == 3) {
                    ViewPanel.this.selpolygon = new Polygon();
                    ViewPanel.this.selpolygon.addPoint(evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                super.mouseReleased(evt);
                if (ProjectionFrame.this.model != null && (ViewPanel.this.selsource != null && ViewPanel.this.seltarget != null || ViewPanel.this.selpolygon != null)) {
                    ArrayList<ProjectionInstance> instances = null;
                    instances = ViewPanel.this.selpolygon != null ? ViewPanel.this.getSelectedInstances(ViewPanel.this.selpolygon) : ViewPanel.this.getSelectedInstances(ViewPanel.this.selsource, ViewPanel.this.seltarget);
                    if (instances != null) {
                        float perc = 100.0f * ((float)instances.size() / (float)ProjectionFrame.this.model.getInstances().size());
                        DecimalFormat df = new DecimalFormat("0.##");
                        ProjectionFrame.this.changeStatus("Number of Instances in Selection: " + instances.size() + " (" + df.format(perc) + "%)");
                        if (ViewPanel.this.selection != null) {
                            ViewPanel.this.selection.selected(new ArrayList<AbstractInstance>(instances));
                        }
                    }
                }
                ViewPanel.this.selpolygon = null;
                ViewPanel.this.selinstance = null;
                ViewPanel.this.selsource = null;
                ViewPanel.this.seltarget = null;
            }
        }

        class MouseMotionListener
        extends MouseMotionAdapter {
            MouseMotionListener() {
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                super.mouseMoved(evt);
                if (ProjectionFrame.this.model != null) {
                    ViewPanel.this.labelins = ((ProjectionModel)ProjectionFrame.this.model).getInstanceByPosition(evt.getPoint());
                    if (ViewPanel.this.labelins != null) {
                        ViewPanel.this.labelpos = evt.getPoint();
                    } else {
                        ViewPanel.this.labelpos = null;
                    }
                    ViewPanel.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (ViewPanel.this.selinstance != null) {
                    if (ProjectionFrame.this.model.hasSelectedInstances()) {
                        float x = (float)evt.getX() - ViewPanel.this.selinstance.getX();
                        float y = (float)evt.getY() - ViewPanel.this.selinstance.getY();
                        for (AbstractInstance ai : ProjectionFrame.this.model.getSelectedInstances()) {
                            ProjectionInstance pi = (ProjectionInstance)ai;
                            pi.setX(x + pi.getX());
                            pi.setY(y + pi.getY());
                        }
                        ViewPanel.this.adjustPanel();
                    }
                } else if (ViewPanel.this.selsource != null) {
                    ViewPanel.this.seltarget = evt.getPoint();
                } else if (ViewPanel.this.selpolygon != null) {
                    ViewPanel.this.selpolygon.addPoint(evt.getX(), evt.getY());
                }
                ViewPanel.this.repaint();
            }
        }
    }
}

