/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simpletree.basics.color.ColorScaleFactory;
import simpletree.basics.color.ColorScalePanel;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.ImageCollection;
import simpletree.util.ProjectionOpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.ZIPFilter;
import simpletree.view.SimpleTreeFrame;

public class SimpleTreeFrameOptions
extends JDialog {
    private SimpleTreeFrame viewer;
    private JPanel adjustsPanel;
    private JSlider alphaSlider;
    private JButton backGroundButton;
    private JCheckBox boldCheckBox;
    private JPanel buttonPanel;
    protected JRadioButton circlesRadioButton;
    private JButton closeButton;
    private JPanel coloScalePanel;
    private JPanel colorChosePanel;
    private JPanel colorPanel;
    private ButtonGroup drawButtonGroup;
    private JPanel drawPanel;
    private JRadioButton highRadioButton;
    protected JComboBox imageSizeComboBox;
    private JLabel imageSizeLabel;
    protected JRadioButton imagesRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JComboBox labelfontSizeComboBox;
    private JLabel labelfontSizeLabel;
    protected JComboBox labelsComboBox;
    private JSlider maxSlider;
    private JSlider minSlider;
    private JPanel paremetersPanel;
    private JRadioButton poorRadioButton;
    private JPanel qualityPanel;
    private ButtonGroup renderQualitybuttonGroup;
    private JCheckBox reverseScaleCheckBox;
    private JComboBox scaleComboBox;
    private JPanel scaleRangePanel;
    private JCheckBox showClassOnLabelCheckBox;
    protected JCheckBox showImageFrameCheckBox;
    private JLabel vertexLabel;

    protected SimpleTreeFrameOptions(Frame parent) {
        super(parent);
        this.initComponents();
        this.viewer = (SimpleTreeFrame)parent;
        for (ColorScaleFactory.ColorScaleType cst : ColorScaleFactory.ColorScaleType.values()) {
            this.scaleComboBox.addItem(cst);
        }
        String[] items = new String[]{"file name", "image"};
        this.labelsComboBox.setModel(new DefaultComboBoxModel<String>(items));
        if (this.viewer.getModel() != null) {
            if (((SimpleTreeModel)this.viewer.getModel()).isDrawAsImage()) {
                this.imagesRadioButton.setSelected(true);
            } else {
                this.circlesRadioButton.setSelected(true);
            }
            if (this.viewer.isDrawInstaceLabelAsImages()) {
                this.labelsComboBox.setSelectedIndex(1);
            } else {
                this.labelsComboBox.setSelectedIndex(0);
            }
            this.showImageFrameCheckBox.setSelected(((SimpleTreeModel)this.viewer.getModel()).isDrawImageFrame());
            this.imageSizeComboBox.setSelectedItem(Integer.toString(((SimpleTreeModel)this.viewer.getModel()).getImagesSize()));
        }
        this.labelfontSizeComboBox.setSelectedItem(Integer.toString(this.viewer.getLabelSize()));
        this.boldCheckBox.setSelected(this.viewer.isLabelBold());
    }

    private void initComponents() {
        this.renderQualitybuttonGroup = new ButtonGroup();
        this.drawButtonGroup = new ButtonGroup();
        this.adjustsPanel = new JPanel();
        this.paremetersPanel = new JPanel();
        this.backGroundButton = new JButton();
        this.qualityPanel = new JPanel();
        this.highRadioButton = new JRadioButton();
        this.poorRadioButton = new JRadioButton();
        this.alphaSlider = new JSlider();
        this.jPanel1 = new JPanel();
        this.labelfontSizeLabel = new JLabel();
        this.labelfontSizeComboBox = new JComboBox<String>(new String[]{"11", "12", "13", "14", "16", "18", "20", "25", "30", "35", "40", "50"});
        this.boldCheckBox = new JCheckBox();
        this.imageSizeLabel = new JLabel();
        this.imageSizeComboBox = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8"});
        this.showClassOnLabelCheckBox = new JCheckBox();
        this.drawPanel = new JPanel();
        this.circlesRadioButton = new JRadioButton();
        this.imagesRadioButton = new JRadioButton();
        this.vertexLabel = new JLabel();
        this.labelsComboBox = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20"});
        this.showImageFrameCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.colorPanel = new JPanel();
        this.scaleRangePanel = new JPanel();
        this.minSlider = new JSlider();
        this.maxSlider = new JSlider();
        this.coloScalePanel = new ColorScalePanel(null);
        this.reverseScaleCheckBox = new JCheckBox();
        this.colorChosePanel = new JPanel();
        this.scaleComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Projection Options");
        this.setModal(true);
        this.adjustsPanel.setBorder(BorderFactory.createTitledBorder("Adjustments "));
        this.adjustsPanel.setLayout(new GridBagLayout());
        this.paremetersPanel.setBorder(BorderFactory.createTitledBorder("Graphics Parameters"));
        this.paremetersPanel.setLayout(new GridBagLayout());
        this.backGroundButton.setText("BackGround Color");
        this.backGroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.backGroundButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.paremetersPanel.add((Component)this.backGroundButton, gridBagConstraints);
        this.qualityPanel.setBorder(BorderFactory.createTitledBorder("Render Quality"));
        this.qualityPanel.setLayout(new GridBagLayout());
        this.renderQualitybuttonGroup.add(this.highRadioButton);
        this.highRadioButton.setSelected(true);
        this.highRadioButton.setText("High quality (slow)");
        this.highRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.highRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.highRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.qualityPanel.add((Component)this.highRadioButton, gridBagConstraints);
        this.renderQualitybuttonGroup.add(this.poorRadioButton);
        this.poorRadioButton.setText("Poor quality (fast)");
        this.poorRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.poorRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.poorRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.qualityPanel.add((Component)this.poorRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.qualityPanel, gridBagConstraints);
        this.alphaSlider.setPaintLabels(true);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setSnapToTicks(true);
        this.alphaSlider.setBorder(BorderFactory.createTitledBorder("Alpha"));
        this.alphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimpleTreeFrameOptions.this.alphaSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.paremetersPanel.add((Component)this.alphaSlider, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Text/Image"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.labelfontSizeLabel.setText("Label font size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.labelfontSizeLabel, gridBagConstraints);
        this.labelfontSizeComboBox.setEditable(true);
        this.labelfontSizeComboBox.setMinimumSize(new Dimension(50, 18));
        this.labelfontSizeComboBox.setPreferredSize(new Dimension(50, 20));
        this.labelfontSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.labelfontSizeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.labelfontSizeComboBox, gridBagConstraints);
        this.boldCheckBox.setText("Bold");
        this.boldCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.boldCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.boldCheckBox, gridBagConstraints);
        this.imageSizeLabel.setText("Image Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.imageSizeLabel, gridBagConstraints);
        this.imageSizeComboBox.setEditable(true);
        this.imageSizeComboBox.setMinimumSize(new Dimension(50, 18));
        this.imageSizeComboBox.setPreferredSize(new Dimension(50, 20));
        this.imageSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.imageSizeComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.imageSizeComboBox, gridBagConstraints);
        this.showClassOnLabelCheckBox.setText("Show Class on Label");
        this.showClassOnLabelCheckBox.setEnabled(false);
        this.showClassOnLabelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.showClassOnLabelCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        this.jPanel1.add((Component)this.showClassOnLabelCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.paremetersPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.drawPanel.setBorder(BorderFactory.createTitledBorder("Draw"));
        this.drawPanel.setLayout(new GridBagLayout());
        this.drawButtonGroup.add(this.circlesRadioButton);
        this.circlesRadioButton.setText("circles");
        this.circlesRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.circlesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.circlesRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.drawPanel.add((Component)this.circlesRadioButton, gridBagConstraints);
        this.drawButtonGroup.add(this.imagesRadioButton);
        this.imagesRadioButton.setText("images");
        this.imagesRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.imagesRadioButton.setEnabled(false);
        this.imagesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.imagesRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.drawPanel.add((Component)this.imagesRadioButton, gridBagConstraints);
        this.vertexLabel.setText("Title");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.drawPanel.add((Component)this.vertexLabel, gridBagConstraints);
        this.labelsComboBox.setMaximumRowCount(3);
        this.labelsComboBox.setEnabled(false);
        this.labelsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.labelsComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.drawPanel.add((Component)this.labelsComboBox, gridBagConstraints);
        this.showImageFrameCheckBox.setText("Show images frames");
        this.showImageFrameCheckBox.setBorder(null);
        this.showImageFrameCheckBox.setEnabled(false);
        this.showImageFrameCheckBox.setMaximumSize(new Dimension(145, 15));
        this.showImageFrameCheckBox.setMinimumSize(new Dimension(141, 15));
        this.showImageFrameCheckBox.setPreferredSize(new Dimension(155, 15));
        this.showImageFrameCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.showImageFrameCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        this.drawPanel.add((Component)this.showImageFrameCheckBox, gridBagConstraints);
        this.jLabel3.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.drawPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel2.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.drawPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel4.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.drawPanel.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.paremetersPanel.add((Component)this.drawPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.paremetersPanel, gridBagConstraints);
        this.colorPanel.setBorder(BorderFactory.createTitledBorder("Color Scale"));
        this.colorPanel.setLayout(new BorderLayout(3, 3));
        this.scaleRangePanel.setBorder(BorderFactory.createTitledBorder("Scale Range"));
        this.scaleRangePanel.setLayout(new GridBagLayout());
        this.minSlider.setMaximum(50);
        this.minSlider.setPaintLabels(true);
        this.minSlider.setPaintTicks(true);
        this.minSlider.setInverted(true);
        this.minSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimpleTreeFrameOptions.this.minSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.minSlider, gridBagConstraints);
        this.maxSlider.setMaximum(50);
        this.maxSlider.setPaintLabels(true);
        this.maxSlider.setPaintTicks(true);
        this.maxSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimpleTreeFrameOptions.this.maxSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.maxSlider, gridBagConstraints);
        this.coloScalePanel.setMinimumSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.coloScalePanel, gridBagConstraints);
        this.reverseScaleCheckBox.setText("Reverse Scale");
        this.reverseScaleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.reverseScaleCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.reverseScaleCheckBox, gridBagConstraints);
        this.colorPanel.add((Component)this.scaleRangePanel, "South");
        this.colorChosePanel.setLayout(new GridBagLayout());
        this.scaleComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimpleTreeFrameOptions.this.scaleComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.scaleComboBox, gridBagConstraints);
        this.jLabel1.setText("Scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.colorPanel.add((Component)this.colorChosePanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.adjustsPanel.add((Component)this.colorPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.adjustsPanel, "Center");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeFrameOptions.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void backGroundButtonActionPerformed(ActionEvent evt) {
        Color color;
        if (this.viewer != null && (color = JColorChooser.showDialog(this, "Choose the Backgroud Color", Color.BLACK)) != null) {
            this.viewer.setViewerBackground(color);
        }
    }

    private void highRadioButtonActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            this.viewer.setHighQualityRender(true);
        }
    }

    private void poorRadioButtonActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            this.viewer.setHighQualityRender(false);
        }
    }

    private void alphaSliderStateChanged(ChangeEvent evt) {
        ProjectionModel model;
        if (this.viewer != null && (model = (ProjectionModel)this.viewer.getModel()) != null) {
            JSlider slider = (JSlider)evt.getSource();
            model.setAlpha((float)Math.pow((float)slider.getValue() / 100.0f, 2.0));
            model.notifyObservers();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.viewer = null;
        this.setVisible(false);
    }

    private void minSliderStateChanged(ChangeEvent evt) {
        if (this.viewer != null) {
            try {
                if (this.viewer.getModel() != null) {
                    float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum() / 2.0f;
                    float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum() / 2.0f;
                    ((ProjectionModel)this.viewer.getModel()).getColorTable().getColorScale().setMinMax(0.5f - min, max + 0.5f);
                }
                if (this.viewer.getView() != null) {
                    this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
                }
                this.coloScalePanel.repaint();
            }
            catch (IOException ex) {
                Logger.getLogger(SimpleTreeFrameOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void maxSliderStateChanged(ChangeEvent evt) {
        if (this.viewer != null) {
            try {
                if (this.viewer.getModel() != null) {
                    float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum() / 2.0f;
                    float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum() / 2.0f;
                    ((ProjectionModel)this.viewer.getModel()).getColorTable().getColorScale().setMinMax(0.5f - min, max + 0.5f);
                }
                if (this.viewer.getView() != null) {
                    this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
                }
                this.coloScalePanel.repaint();
            }
            catch (IOException ex) {
                Logger.getLogger(SimpleTreeFrameOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void reverseScaleCheckBoxActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            ProjectionModel model = (ProjectionModel)this.viewer.getModel();
            if (model != null) {
                model.getColorTable().getColorScale().setReverse(this.reverseScaleCheckBox.isSelected());
            }
            if (this.viewer.getView() != null) {
                this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
            }
            this.coloScalePanel.repaint();
        }
    }

    private void scaleComboBoxItemStateChanged(ItemEvent evt) {
        ColorScaleFactory.ColorScaleType type;
        if (this.viewer != null && evt.getStateChange() == 2 && (type = (ColorScaleFactory.ColorScaleType)((Object)this.scaleComboBox.getSelectedItem())) != null) {
            try {
                this.changeColorScale(type);
            }
            catch (IOException ex) {
                Logger.getLogger(SimpleTreeFrameOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void labelfontSizeComboBoxActionPerformed(ActionEvent evt) {
        String value = (String)this.labelfontSizeComboBox.getSelectedItem();
        boolean validNumber = true;
        for (int i = 0; i < value.length(); ++i) {
            Character caractere = Character.valueOf(value.charAt(i));
            if (Character.isDigit(caractere.charValue())) continue;
            validNumber = false;
            break;
        }
        if (validNumber && Integer.parseInt(value) > 0) {
            if (this.viewer != null) {
                this.viewer.setLabelSize(Integer.parseInt((String)this.labelfontSizeComboBox.getSelectedItem()));
            }
        } else {
            JOptionPane.showMessageDialog(this.labelfontSizeComboBox, "Invalid number!");
            this.labelfontSizeComboBox.setSelectedItem("12");
        }
    }

    private void boldCheckBoxActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            this.viewer.setLabelBold(this.boldCheckBox.isSelected());
        }
    }

    protected void imageSizeComboBoxActionPerformed(ActionEvent evt) {
        String value = (String)this.imageSizeComboBox.getSelectedItem();
        boolean validNumber = true;
        for (int i = 0; i < value.length(); ++i) {
            Character caractere = Character.valueOf(value.charAt(i));
            if (Character.isDigit(caractere.charValue())) continue;
            validNumber = false;
            break;
        }
        if (validNumber && Integer.parseInt(value) > 0) {
            this.viewer.setImagesSize(Integer.parseInt(value));
        } else {
            JOptionPane.showMessageDialog(this.imageSizeComboBox, "Invalid number!");
            this.imageSizeComboBox.setSelectedItem("4");
        }
    }

    private void circlesRadioButtonActionPerformed(ActionEvent evt) {
        ((SimpleTreeModel)this.viewer.getModel()).setImages(null);
        this.viewer.setDrawInstancesAsImages(false);
    }

    private void imagesRadioButtonActionPerformed(ActionEvent evt) {
        block12: {
            HashMap<Integer, String> labels = new HashMap<Integer, String>();
            SimpleTreeModel simpleTreeModel = (SimpleTreeModel)this.viewer.getModel();
            for (AbstractInstance ab : simpleTreeModel.getInstances()) {
                if (!((SimpleTreeInstance)ab).isValid()) continue;
                int id = ab instanceof ClusterSimpleTreeInstance ? ((ClusterSimpleTreeInstance)ab).getMedoidId() : ab.getId();
                labels.put(id, simpleTreeModel.getLabels().get(id));
            }
            if (labels != null && !labels.isEmpty()) {
                try {
                    ImageCollection imc = null;
                    if (this.viewer.getImageCollection() == null || simpleTreeModel.getImageCollectionPath() == null || simpleTreeModel.getImageCollectionPath().isEmpty()) {
                        PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
                        imc = ProjectionOpenDialog.openImages(spm, new ZIPFilter(), this.viewer);
                    } else {
                        imc = new ImageCollection(simpleTreeModel.getImageCollectionPath());
                    }
                    if (imc == null) {
                        this.circlesRadioButton.setSelected(true);
                        break block12;
                    }
                    if (simpleTreeModel.checkImages(imc)) {
                        simpleTreeModel.setImageCollectionPath(imc.getFilename());
                        HashMap<Integer, Image> imgs = new HashMap<Integer, Image>();
                        for (int i = 0; i < labels.size(); ++i) {
                            String label = (String)labels.values().toArray()[i];
                            try {
                                Image im = imc.getImage(label);
                                imgs.put((Integer)labels.keySet().toArray()[i], im);
                                continue;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        simpleTreeModel.setImages(imgs);
                        this.viewer.setDrawInstancesAsImages(true);
                        break block12;
                    }
                    this.circlesRadioButton.setSelected(true);
                    JOptionPane.showMessageDialog(this.viewer, "The image collection file do not correspond to the projected image collection!", "Error", 0, null);
                }
                catch (IOException ex) {
                    Logger.getLogger(SimpleTreeFrameOptions.class.getName()).log(Level.SEVERE, null, ex);
                    this.circlesRadioButton.setSelected(true);
                }
            } else {
                JOptionPane.showMessageDialog(this.viewer, "No source data set found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
            }
        }
    }

    private void labelsComboBoxActionPerformed(ActionEvent evt) {
        block8: {
            if (this.labelsComboBox.getSelectedIndex() == 1) {
                if (this.viewer.getImageCollection() != null || ((SimpleTreeModel)this.viewer.getModel()).getImageCollectionPath() != null && !((SimpleTreeModel)this.viewer.getModel()).getImageCollectionPath().isEmpty()) {
                    this.viewer.setDrawInstanceLabelsAsImages(this.labelsComboBox.getSelectedIndex());
                } else {
                    try {
                        PropertiesManager spm = PropertiesManager.getInstance("graph.properties");
                        ImageCollection imc = ProjectionOpenDialog.openImages(spm, new ZIPFilter(), this.viewer);
                        if (imc == null) {
                            this.labelsComboBox.setSelectedIndex(0);
                            break block8;
                        }
                        if (((SimpleTreeModel)this.viewer.getModel()).checkImages(imc)) {
                            ((SimpleTreeModel)this.viewer.getModel()).setImageCollectionPath(imc.getFilename());
                            this.viewer.setImageCollection(imc);
                            this.viewer.setDrawInstanceLabelsAsImages(this.labelsComboBox.getSelectedIndex());
                            break block8;
                        }
                        this.labelsComboBox.setSelectedIndex(0);
                        JOptionPane.showMessageDialog(this.viewer, "The image collection file do not correspond to the projected image collection!", "Error", 0, null);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SimpleTreeFrameOptions.class.getName()).log(Level.SEVERE, null, ex);
                        this.labelsComboBox.setSelectedIndex(0);
                    }
                }
            } else {
                this.viewer.setDrawInstanceLabelsAsImages(this.labelsComboBox.getSelectedIndex());
            }
        }
    }

    private void showImageFrameCheckBoxActionPerformed(ActionEvent evt) {
        this.viewer.setDrawFrame(this.showImageFrameCheckBox.isSelected());
    }

    private void showClassOnLabelCheckBoxActionPerformed(ActionEvent evt) {
        if (this.viewer != null) {
            this.viewer.setShowClassOnLabel(this.showClassOnLabelCheckBox.isSelected());
        }
    }

    public static SimpleTreeFrameOptions getInstance(JFrame parent) {
        return new SimpleTreeFrameOptions(parent);
    }

    public void display(SimpleTreeFrame viewer) {
        if (viewer != null) {
            if (viewer.isHighQualityRender()) {
                this.highRadioButton.setSelected(true);
                this.poorRadioButton.setSelected(false);
            } else {
                this.highRadioButton.setSelected(false);
                this.poorRadioButton.setSelected(true);
            }
            ProjectionModel model = (ProjectionModel)viewer.getModel();
            if (model != null) {
                this.alphaSlider.setValue((int)(Math.sqrt(model.getAlpha()) * 100.0));
                this.scaleComboBox.setSelectedItem((Object)model.getColorTable().getColorScaleType());
                ((ColorScalePanel)this.coloScalePanel).setColorTable(model.getColorTable());
                this.reverseScaleCheckBox.setSelected(model.getColorTable().getColorScale().isReverse());
                this.maxSlider.setValue((int)(model.getColorTable().getColorScale().getMax() * (float)this.maxSlider.getMaximum()));
                this.minSlider.setValue((int)((1.0f - model.getColorTable().getColorScale().getMin() * 2.0f) * (float)this.minSlider.getMaximum()));
            }
        }
        this.viewer = viewer;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void changeColorScale(ColorScaleFactory.ColorScaleType scaletype) throws IOException {
        if (this.viewer != null && this.viewer.getModel() != null) {
            ProjectionModel model = (ProjectionModel)this.viewer.getModel();
            model.getColorTable().setColorScaleType(scaletype);
            float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum() / 2.0f;
            float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum() / 2.0f;
            model.getColorTable().getColorScale().setMinMax(0.5f - min, max + 0.5f);
            model.getColorTable().getColorScale().setReverse(this.reverseScaleCheckBox.isSelected());
            if (this.viewer != null && this.viewer.getView() != null) {
                this.viewer.getView().colorAs(this.viewer.getCurrentScalar());
            }
            this.coloScalePanel.repaint();
        }
    }
}

