/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.forms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import simpletree.coordination.AbstractCoordinator;
import simpletree.coordination.IdentityCoordinator;
import simpletree.coordination.IdentityCoordinatorComp;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.AbstractInstance;
import simpletree.model.AbstractModel;
import simpletree.model.SimpleTreeModel;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModel;
import simpletree.technique.parallelcoordinates.model.ParallelCoordinatesModelComp;
import simpletree.technique.parallelcoordinates.model.view.ParallelCoordinatesFrameComp;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.DMATFilter;
import simpletree.view.JFrameModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.forms.CustomTableCellRenderer;
import simpletree.view.forms.MatrixModel;
import simpletree.view.forms.MatrixTableModel;
import simpletree.view.forms.VectorInstance;
import simpletree.view.tools.MatrixAttributesSelector;

public class MatrixView
extends JFrameModelViewer
implements Observer,
ListSelectionListener {
    private static int distanceCounter = 0;
    private final int INDEX_COLUMN = 0;
    private final int ID_COLUMN = 1;
    private final int LABEL_COLUMN = 2;
    private final int CLASS_COLUMN = 3;
    private DistanceMatrix distanceMatrix;
    private AbstractMatrix pointsMatrix;
    private ArrayList<String> attributes;
    private ArrayList<String> selectedAttributes;
    private JFrameModelViewer parentFrame;
    private JComboBox dissimilarityComboBox;
    private JButton distanceButton;
    private JButton exportMatrixButton;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTable matrixTable;
    private JButton parallelCoordButton;
    private JPopupMenu popupMenu;
    private JMenuItem removeColumnMenuItem;
    private JMenuItem removeRowMenuItem;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JMenuItem visibleAttributesMenuItem;

    public MatrixView(JFrameModelViewer parent) {
        this();
        this.parentFrame = parent;
    }

    private void coordinate() {
        if (this.parentFrame == null) {
            return;
        }
        try {
            IdentityCoordinatorComp coord = new IdentityCoordinatorComp();
            coord.execute();
            if (this.coordinators == null) {
                this.coordinators = new ArrayList();
            }
            this.addCoordinator(coord.output());
            this.parentFrame.addCoordinator(coord.output());
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public MatrixView() {
        this.initComponents();
        this.matrixTable.setDefaultRenderer(Float.class, new CustomTableCellRenderer());
        this.matrixTable.setDefaultRenderer(String.class, new CustomTableCellRenderer());
        this.matrixTable.setDefaultRenderer(Integer.class, new CustomTableCellRenderer());
        this.matrixTable.getTableHeader().setBackground(Color.LIGHT_GRAY);
    }

    public void refreshTableData(DistanceMatrix distanceMatrix) {
        ArrayList<String> labels = distanceMatrix.getLabels();
        ArrayList<Integer> ids = distanceMatrix.getIds();
        float[] cdata = distanceMatrix.getClassData();
        int elementCount = distanceMatrix.getElementCount();
        this.model = new MatrixModel();
        this.model.addObserver(this);
        Object[] columnNames = new Object[elementCount + 4];
        columnNames[0] = "Index";
        columnNames[1] = "Id";
        columnNames[2] = "Label";
        columnNames[3] = "Class";
        for (int i = 0; i < elementCount; ++i) {
            columnNames[i + 4] = "Distance " + i;
        }
        float[][] distanceValues = new float[elementCount][elementCount];
        for (int i = 0; i < elementCount; ++i) {
            for (int j = i + 1; j < elementCount; ++j) {
                distanceValues[i][j] = distanceMatrix.getDistance(i, j);
                distanceValues[j][i] = distanceMatrix.getDistance(i, j);
            }
        }
        Object[][] tableData = new Object[elementCount][elementCount + 4];
        for (int i = 0; i < elementCount; ++i) {
            block10: for (int j = 0; j < elementCount + 4; ++j) {
                switch (j) {
                    case 0: {
                        tableData[i][j] = i;
                        continue block10;
                    }
                    case 1: {
                        tableData[i][j] = ids.get(i);
                        VectorInstance instance = new VectorInstance(ids.get(i));
                        this.model.addInstance(instance);
                        continue block10;
                    }
                    case 2: {
                        if (labels != null && !labels.isEmpty()) {
                            tableData[i][j] = labels.get(i);
                            continue block10;
                        }
                        tableData[i][j] = "";
                        continue block10;
                    }
                    case 3: {
                        if (cdata != null && cdata.length > 0) {
                            tableData[i][j] = Float.valueOf(cdata[i]);
                            continue block10;
                        }
                        tableData[i][j] = Float.valueOf(0.0f);
                        continue block10;
                    }
                    default: {
                        tableData[i][j] = Float.valueOf(distanceValues[i][j - 4]);
                    }
                }
            }
        }
        MatrixTableModel tableModel = new MatrixTableModel(tableData, columnNames);
        this.matrixTable.setModel(tableModel);
        this.distanceMatrix = distanceMatrix;
        this.matrixTable.getSelectionModel().addListSelectionListener(this);
        this.coordinate();
    }

    public static ArrayList<String> getMatrixAttributes(AbstractMatrix pointsMatrix) {
        ArrayList<String> returnList = new ArrayList();
        int dimensionsCount = pointsMatrix.getDimensions();
        if (!pointsMatrix.getAttributes().isEmpty()) {
            returnList = pointsMatrix.getAttributes();
        } else {
            for (int i = 0; i < dimensionsCount; ++i) {
                returnList.add("Attribute " + i);
            }
        }
        return returnList;
    }

    @Override
    public void setModel(AbstractModel newModel) {
        super.setModel(newModel);
        for (AbstractCoordinator coordinator : this.coordinators) {
            coordinator.addModel(newModel);
        }
    }

    public void refreshTableData(AbstractMatrix inputPointsMatrix) {
        int j;
        ArrayList<String> labels = inputPointsMatrix.getLabels();
        ArrayList<Integer> ids = inputPointsMatrix.getIds();
        ArrayList<String> attributeList = MatrixView.getMatrixAttributes(inputPointsMatrix);
        MatrixModel newModel = new MatrixModel();
        this.setModel(newModel);
        float[] cdata = inputPointsMatrix.getClassData();
        int elementCount = inputPointsMatrix.getRowCount();
        int valuesCount = attributeList.size();
        Object[] columnNames = new Object[attributeList.size() + 4];
        columnNames[0] = "Index";
        columnNames[1] = "Id";
        columnNames[2] = "Label";
        columnNames[3] = "Class";
        for (int i = 0; i < attributeList.size(); ++i) {
            columnNames[i + 4] = attributeList.get(i);
        }
        float[][] matrixValues = new float[elementCount][valuesCount];
        for (int i = 0; i < elementCount; ++i) {
            AbstractVector currentRow = inputPointsMatrix.getRow(i);
            for (j = 0; j < attributeList.size(); ++j) {
                matrixValues[i][j] = currentRow.getValue(j);
            }
        }
        Object[][] tableData = new Object[elementCount][valuesCount + 4];
        for (int i = 0; i < elementCount; ++i) {
            block10: for (j = 0; j < valuesCount + 4; ++j) {
                switch (j) {
                    case 0: {
                        tableData[i][j] = i;
                        continue block10;
                    }
                    case 1: {
                        tableData[i][j] = ids.get(i);
                        VectorInstance instance = new VectorInstance(ids.get(i));
                        newModel.addInstance(instance);
                        continue block10;
                    }
                    case 2: {
                        if (labels != null && !labels.isEmpty()) {
                            tableData[i][j] = labels.get(i);
                            continue block10;
                        }
                        tableData[i][j] = "";
                        continue block10;
                    }
                    case 3: {
                        if (cdata != null && cdata.length > 0) {
                            tableData[i][j] = Float.valueOf(cdata[i]);
                            continue block10;
                        }
                        tableData[i][j] = Float.valueOf(0.0f);
                        continue block10;
                    }
                    default: {
                        tableData[i][j] = Float.valueOf(matrixValues[i][j - 4]);
                    }
                }
            }
        }
        MatrixTableModel tableModel = new MatrixTableModel(tableData, columnNames);
        this.matrixTable.setModel(tableModel);
        this.pointsMatrix = inputPointsMatrix;
        this.attributes = MatrixView.getMatrixAttributes(inputPointsMatrix);
        if (this.selectedAttributes == null) {
            this.selectedAttributes = this.attributes;
        }
        this.matrixTable.getSelectionModel().addListSelectionListener(this);
        this.coordinate();
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.visibleAttributesMenuItem = new JMenuItem();
        this.removeColumnMenuItem = new JMenuItem();
        this.removeRowMenuItem = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.matrixTable = new JTable();
        this.toolBar = new JToolBar();
        this.exportMatrixButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.parallelCoordButton = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.distanceButton = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.dissimilarityComboBox = new JComboBox();
        this.visibleAttributesMenuItem.setText("Visible attributes...");
        this.visibleAttributesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatrixView.this.visibleAttributesMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.visibleAttributesMenuItem);
        this.removeColumnMenuItem.setText("Remove Selected Column(s)");
        this.removeColumnMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatrixView.this.removeColumnMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.removeColumnMenuItem);
        this.removeRowMenuItem.setText("Remove Selected Row(s)");
        this.removeRowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatrixView.this.removeRowMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.removeRowMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Instance Matrix Visualization");
        this.setIconImages(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                MatrixView.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.matrixTable.setAutoCreateRowSorter(true);
        this.matrixTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.matrixTable.setAutoResizeMode(0);
        this.matrixTable.setComponentPopupMenu(this.popupMenu);
        this.scrollPane.setViewportView(this.matrixTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.scrollPane, gridBagConstraints);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.exportMatrixButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.exportMatrixButton.setText("Export");
        this.exportMatrixButton.setFocusable(false);
        this.exportMatrixButton.setHorizontalAlignment(4);
        this.exportMatrixButton.setHorizontalTextPosition(4);
        this.exportMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatrixView.this.exportMatrixButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.exportMatrixButton);
        this.toolBar.add(this.jSeparator1);
        this.parallelCoordButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/barChart.png")));
        this.parallelCoordButton.setText("Parallel Coordinates");
        this.parallelCoordButton.setFocusable(false);
        this.parallelCoordButton.setHorizontalTextPosition(4);
        this.parallelCoordButton.setVerticalTextPosition(3);
        this.parallelCoordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatrixView.this.parallelCoordButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.parallelCoordButton);
        this.toolBar.add(this.jSeparator2);
        this.distanceButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/Distance_16.png")));
        this.distanceButton.setText("Distance");
        this.distanceButton.setFocusable(false);
        this.distanceButton.setHorizontalTextPosition(4);
        this.distanceButton.setVerticalTextPosition(3);
        this.distanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatrixView.this.distanceButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.distanceButton);
        this.toolBar.add(this.jSeparator3);
        this.dissimilarityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dissimilarityComboBox.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
        this.initComboDissimilarity();
        this.toolBar.add(this.dissimilarityComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.toolBar, gridBagConstraints);
        this.setSize(new Dimension(600, 600));
        this.setLocationRelativeTo(null);
    }

    private void formWindowOpened(WindowEvent evt) {
        this.setLocationRelativeTo(null);
    }

    private void initComboDissimilarity() {
        this.dissimilarityComboBox.removeAllItems();
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.dissimilarityComboBox.setSelectedItem((Object)DissimilarityFactory.DissimilarityType.EUCLIDEAN);
    }

    private AbstractMatrix createPointsMatrixFromView() {
        DenseMatrix denseMatrix = new DenseMatrix();
        int elementCount = this.matrixTable.getRowCount();
        DefaultTableModel model = (DefaultTableModel)this.matrixTable.getModel();
        Vector<Vector> modelData = model.getDataVector();
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < elementCount; ++i) {
            float elementClass = ((Float)this.matrixTable.getValueAt(i, 3)).floatValue();
            String label = (String)this.matrixTable.getValueAt(i, 2);
            if (label != null & !label.trim().isEmpty()) {
                labels.add(label);
            }
            float[] vectorValues = new float[this.selectedAttributes.size()];
            for (int j = 0; j < this.selectedAttributes.size(); ++j) {
                vectorValues[j] = ((Float)modelData.get(i).get(j + 4)).floatValue();
            }
            ((AbstractMatrix)denseMatrix).addRow(new DenseVector(vectorValues, (Integer)this.matrixTable.getValueAt(i, 1), elementClass));
        }
        denseMatrix.setAttributes(this.selectedAttributes);
        denseMatrix.setLabels(labels);
        return denseMatrix;
    }

    private void visibleAttributesMenuItemActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MatrixAttributesSelector attributeSelector = new MatrixAttributesSelector((Frame)MatrixView.this, true);
                attributeSelector.refreshTableValues(MatrixView.this.attributes, MatrixView.this.selectedAttributes);
                attributeSelector.setDefaultCloseOperation(2);
                attributeSelector.setTitle("Select visible attributes");
                attributeSelector.setLocationRelativeTo(MatrixView.this);
                if (attributeSelector.display() == 0) {
                    MatrixView.this.selectedAttributes = attributeSelector.getSelectedAttributes();
                    MatrixView.this.refreshTableData(MatrixView.this.pointsMatrix);
                }
            }
        });
    }

    private void saveDistanceMatrix() throws IOException {
        PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
        int result = SaveDialog.showSaveDialog(spm, new DMATFilter(), this, "matrix.dmat");
        if (result == 0 && this.distanceMatrix != null) {
            try {
                this.distanceMatrix.save(SaveDialog.getFilename());
            }
            catch (IOException ex) {
                Logger.getLogger(MatrixView.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(null, "Error saving file!");
            }
        }
    }

    private void savePointsMatrix() throws IOException {
        PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
        int result = SaveDialog.showSaveDialog(spm, new DATAFilter(), this, "matrix.data");
        if (result == 0) {
            try {
                AbstractMatrix denseMatrix = this.createPointsMatrixFromView();
                if (SaveDialog.getFilename().endsWith("2d")) {
                    denseMatrix.setAttributes(new ArrayList<String>());
                }
                denseMatrix.save(SaveDialog.getFilename());
            }
            catch (IOException ex) {
                Logger.getLogger(MatrixView.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(null, "Error saving file!");
            }
        }
    }

    private void removeRowMenuItemActionPerformed(ActionEvent evt) {
        int[] listIndex = this.matrixTable.getSelectedRows();
        for (int i = this.matrixTable.getSelectedRowCount() - 1; i >= 0; --i) {
            Integer index = listIndex[i];
            if (index == -1) continue;
            ((DefaultTableModel)this.matrixTable.getModel()).removeRow(index);
        }
        this.matrixTable.repaint();
    }

    private void removeColumnMenuItemActionPerformed(ActionEvent evt) {
        int[] listIndex = this.matrixTable.getSelectedColumns();
        for (int i = this.matrixTable.getSelectedColumnCount() - 1; i >= 0; --i) {
            Integer index = listIndex[i];
            if (index == -1) continue;
            String name = this.matrixTable.getColumnName(index);
            TableColumn tcol = this.matrixTable.getColumn(name);
            this.matrixTable.removeColumn(tcol);
        }
        this.matrixTable.repaint();
    }

    private void exportMatrixButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.distanceMatrix != null) {
                this.saveDistanceMatrix();
            } else if (this.pointsMatrix != null) {
                this.savePointsMatrix();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void distanceButtonActionPerformed(ActionEvent evt) {
        try {
            AbstractMatrix denseMatrix = this.createPointsMatrixFromView();
            DissimilarityFactory.DissimilarityType diss = (DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem());
            DistanceMatrix newDmat = new DistanceMatrix(denseMatrix, DissimilarityFactory.getInstance(diss));
            ++distanceCounter;
            MatrixView newView = new MatrixView(this);
            newView.matrixTable.setComponentPopupMenu(null);
            newView.refreshTableData(newDmat);
            newView.setDefaultCloseOperation(2);
            newView.setTitle("Distance matrix --" + diss.name());
            newView.distanceButton.setEnabled(false);
            newView.parallelCoordButton.setEnabled(false);
            newView.dissimilarityComboBox.setEnabled(false);
            newView.exportMatrixButton.setEnabled(true);
            newView.setVisible(true);
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixView.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, "Error opening file!", "Error!", 0);
        }
    }

    private void parallelCoordButtonActionPerformed(ActionEvent evt) {
        try {
            IdentityCoordinatorComp coordComp = new IdentityCoordinatorComp();
            coordComp.execute();
            this.parentFrame.addCoordinator(coordComp.output());
            this.addCoordinator(coordComp.output());
            ParallelCoordinatesModelComp pcmodelComp = new ParallelCoordinatesModelComp();
            pcmodelComp.input(this.pointsMatrix);
            pcmodelComp.execute();
            ParallelCoordinatesModel pcmodel = pcmodelComp.output();
            SimpleTreeModel stModel = (SimpleTreeModel)((SimpleTreeFrame)this.parentFrame).getModel();
            pcmodel.setColorTable(stModel.getColorTable());
            pcmodel.updateKlassRange(stModel.getSelectedScalar().getMin());
            pcmodel.updateKlassRange(stModel.getSelectedScalar().getMax());
            ParallelCoordinatesFrameComp pcframe = new ParallelCoordinatesFrameComp();
            pcframe.setTitle("Parallel Coordinates");
            pcframe.input(pcmodelComp.output());
            pcframe.attach(coordComp.output());
            pcframe.execute();
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractMatrix matrix = null;
                try {
                    matrix = MatrixFactory.getInstance("D:\\ValetMatrix20.data");
                }
                catch (IOException ex) {
                    Logger.getLogger(MatrixView.class.getName()).log(Level.SEVERE, null, ex);
                }
                MatrixView sMatrix = new MatrixView();
                sMatrix.refreshTableData(matrix);
                sMatrix.setVisible(true);
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        this.matrixTable.getSelectionModel().removeListSelectionListener(this);
        this.matrixTable.clearSelection();
        this.matrixTable.setColumnSelectionAllowed(false);
        this.matrixTable.setRowSelectionAllowed(true);
        ArrayList<AbstractInstance> selectedInstances = this.model.getSelectedInstances();
        TableModel tableModel = this.matrixTable.getModel();
        for (AbstractInstance abstractInstance : selectedInstances) {
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                int instanceId = (Integer)tableModel.getValueAt(i, 1);
                if (abstractInstance.getId() != instanceId) continue;
                this.matrixTable.addRowSelectionInterval(i, i);
            }
        }
        this.matrixTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] selectedRowsIndex = this.matrixTable.getSelectedRows();
        TableModel tableModel = this.matrixTable.getModel();
        ArrayList<AbstractInstance> selectedInstances = new ArrayList<AbstractInstance>();
        for (int i = 0; i < selectedRowsIndex.length; ++i) {
            int instanceId = (Integer)tableModel.getValueAt(selectedRowsIndex[i], 1);
            AbstractInstance instance = ((MatrixModel)this.model).getInstanceById(instanceId);
            selectedInstances.add(instance);
        }
        for (AbstractCoordinator ac : this.getCoordinators()) {
            if (!(ac instanceof IdentityCoordinator)) continue;
            ac.coordinate(new ArrayList<AbstractInstance>(selectedInstances), null);
        }
    }
}

