/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import simpletree.disk.BinaryReaderParamView;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.DATAFilter;

public class NewSuperTreeDialog
extends JDialog {
    public boolean result;
    public DissimilarityFactory.DissimilarityType dissType = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    public String datasetName = "";
    public int nrClusters = 10;
    public int maxClusterSize = 50;
    public int nrMedoids = 10;
    public boolean useClasses = false;
    private JButton cancelButton;
    private JPanel clusteringPanel;
    private JComboBox<String> clusteringTechniqueComboBox;
    private JLabel clusteringTechniqueLabel;
    private JPanel datasetPanel;
    private JTextField datasetTextField;
    private JComboBox<DissimilarityFactory.DissimilarityType> dissimilarityComboBox;
    private JPanel distancePanel;
    private JLabel maxClusterSizeLabel;
    private JTextField maxClusterSizeTextField;
    private JLabel nrClustersLabel;
    private JTextField nrClustersTextField;
    private JLabel nrMedoidsLabel;
    private JTextField nrMedoidsTextField;
    private JButton okButton;
    private JPanel okPanel;
    private JButton selectMatrixButton;
    private JCheckBox useClassesCheckBox;

    public NewSuperTreeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        try {
            this.initComponents();
            for (DissimilarityFactory.DissimilarityType type : DissimilarityFactory.DissimilarityType.values()) {
                this.dissimilarityComboBox.addItem(type);
            }
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            String inputDataset = spm.getProperty("INPUT_DATASET");
            if (inputDataset == null) {
                inputDataset = "";
            }
            this.datasetTextField.setText(inputDataset);
            String selectedDissimilarityProperty = spm.getProperty("DISSIMILARITY");
            if (selectedDissimilarityProperty.isEmpty()) {
                selectedDissimilarityProperty = "0";
            }
            this.dissimilarityComboBox.setSelectedIndex(Integer.valueOf(selectedDissimilarityProperty));
            String numberOfClustersProperty = spm.getProperty("NUM_CLUSTERS");
            if (numberOfClustersProperty.isEmpty()) {
                numberOfClustersProperty = "10";
            }
            this.nrClustersTextField.setText(numberOfClustersProperty);
            String maxClusterSizeProperty = spm.getProperty("MAX_CLUSTER_SIZE");
            if (maxClusterSizeProperty.isEmpty()) {
                maxClusterSizeProperty = "50";
            }
            this.maxClusterSizeTextField.setText(maxClusterSizeProperty);
            String numberOfMedoidsProperty = spm.getProperty("NUMBER_MEDOIDS");
            if (numberOfMedoidsProperty.isEmpty()) {
                numberOfMedoidsProperty = "10";
            }
            this.nrMedoidsTextField.setText(numberOfMedoidsProperty);
            String useClassesAsClustersProperty = spm.getProperty("USE_CLASS_AS_CLUSTERS");
            if (useClassesAsClustersProperty.isEmpty()) {
                this.useClassesCheckBox.setSelected(false);
            } else if (useClassesAsClustersProperty.equals("true")) {
                this.useClassesCheckBox.setSelected(true);
            } else if (useClassesAsClustersProperty.equals("false")) {
                this.useClassesCheckBox.setSelected(false);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NewSuperTreeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.datasetPanel = new JPanel();
        this.datasetTextField = new JTextField();
        this.selectMatrixButton = new JButton();
        this.distancePanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.clusteringPanel = new JPanel();
        this.clusteringTechniqueLabel = new JLabel();
        this.clusteringTechniqueComboBox = new JComboBox();
        this.nrClustersLabel = new JLabel();
        this.nrClustersTextField = new JTextField();
        this.maxClusterSizeLabel = new JLabel();
        this.maxClusterSizeTextField = new JTextField();
        this.nrMedoidsLabel = new JLabel();
        this.nrMedoidsTextField = new JTextField();
        this.useClassesCheckBox = new JCheckBox();
        this.okPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create a new SuperTree");
        this.setMinimumSize(new Dimension(249, 310));
        this.setPreferredSize(new Dimension(300, 310));
        this.setSize(new Dimension(300, 310));
        this.getContentPane().setLayout(new GridBagLayout());
        this.datasetPanel.setBorder(BorderFactory.createTitledBorder("Input Dataset"));
        this.datasetPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.datasetPanel.add((Component)this.datasetTextField, gridBagConstraints);
        this.selectMatrixButton.setText("Select");
        this.selectMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSuperTreeDialog.this.selectMatrixButtonActionPerformed(evt);
            }
        });
        this.datasetPanel.add((Component)this.selectMatrixButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.datasetPanel, gridBagConstraints);
        this.distancePanel.setBorder(BorderFactory.createTitledBorder("Distance Measure"));
        this.distancePanel.setLayout(new BorderLayout());
        this.distancePanel.add(this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.distancePanel, gridBagConstraints);
        this.clusteringPanel.setBorder(BorderFactory.createTitledBorder("Clustering Parameters"));
        this.clusteringPanel.setLayout(new GridBagLayout());
        this.clusteringTechniqueLabel.setHorizontalAlignment(4);
        this.clusteringTechniqueLabel.setText("Technique");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.clusteringPanel.add((Component)this.clusteringTechniqueLabel, gridBagConstraints);
        this.clusteringTechniqueComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"K-Means"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.clusteringPanel.add(this.clusteringTechniqueComboBox, gridBagConstraints);
        this.nrClustersLabel.setHorizontalAlignment(4);
        this.nrClustersLabel.setText("Number of Clusters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.clusteringPanel.add((Component)this.nrClustersLabel, gridBagConstraints);
        this.nrClustersTextField.setText("10");
        this.nrClustersTextField.setPreferredSize(new Dimension(40, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.clusteringPanel.add((Component)this.nrClustersTextField, gridBagConstraints);
        this.maxClusterSizeLabel.setHorizontalAlignment(4);
        this.maxClusterSizeLabel.setText("Max Cluster Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.clusteringPanel.add((Component)this.maxClusterSizeLabel, gridBagConstraints);
        this.maxClusterSizeTextField.setText("50");
        this.maxClusterSizeTextField.setPreferredSize(new Dimension(40, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.clusteringPanel.add((Component)this.maxClusterSizeTextField, gridBagConstraints);
        this.nrMedoidsLabel.setHorizontalAlignment(4);
        this.nrMedoidsLabel.setText("Number of Medoids");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.clusteringPanel.add((Component)this.nrMedoidsLabel, gridBagConstraints);
        this.nrMedoidsTextField.setText("10");
        this.nrMedoidsTextField.setPreferredSize(new Dimension(40, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.clusteringPanel.add((Component)this.nrMedoidsTextField, gridBagConstraints);
        this.useClassesCheckBox.setText("Use classes as first level");
        this.useClassesCheckBox.setFocusable(false);
        this.useClassesCheckBox.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.clusteringPanel.add((Component)this.useClassesCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.clusteringPanel, gridBagConstraints);
        this.okPanel.setPreferredSize(new Dimension(104, 35));
        this.okPanel.setLayout(new GridBagLayout());
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSuperTreeDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.okPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSuperTreeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okPanel.add((Component)this.cancelButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.okPanel, gridBagConstraints);
        this.setBounds(0, 0, 508, 378);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = false;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            this.result = true;
            this.datasetName = this.datasetTextField.getText();
            this.nrClusters = Integer.valueOf(this.nrClustersTextField.getText());
            this.nrMedoids = Integer.valueOf(this.nrMedoidsTextField.getText());
            this.useClasses = this.useClassesCheckBox.isSelected();
            this.dissType = (DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem());
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            spm.setProperty("INPUT_DATASET", this.datasetTextField.getText());
            spm.setProperty("DISSIMILARITY", this.dissimilarityComboBox.getSelectedIndex() + "");
            spm.setProperty("NUM_CLUSTERS", this.nrClustersTextField.getText());
            spm.setProperty("MAX_CLUSTER_SIZE", this.maxClusterSizeTextField.getText());
            spm.setProperty("NUMBER_MEDOIDS", this.nrMedoidsTextField.getText());
            spm.setProperty("USE_CLASS_AS_CLUSTERS", this.useClassesCheckBox.isSelected() + "");
            this.setVisible(false);
        }
        catch (IOException ex) {
            Logger.getLogger(NewSuperTreeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void selectMatrixButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = OpenDialog.showOpenDialog(spm, new DATAFilter(), this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.datasetTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(BinaryReaderParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NewSuperTreeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(NewSuperTreeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NewSuperTreeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(NewSuperTreeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSuperTreeDialog dialog = new NewSuperTreeDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

