/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.forms;

import code.AnySelectionTable;
import code.TableSelectionEvent;
import code.TableSelectionListener;
import code.TableSelectionModel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import simpletree.basics.color.ColorTable;
import simpletree.io.file.SupertreeFile;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.ImageContent;
import simpletree.model.content.LabelContent;
import simpletree.util.ImageCollection;
import simpletree.util.PseudoClass;
import simpletree.util.TablePScalar;
import simpletree.view.SimpleTreeFrame;

public class SimpleTreeMultipleImageView
extends JDialog {
    private static final long serialVersionUID = 1L;
    private TablePScalar tableModel;
    private TablePScalar tablePScalar;
    private DefaultTableModel imagesModel;
    private static SimpleTreeMultipleImageView instance;
    private SimpleTreeFrame viewer;
    private ArrayList<TablesMapping> tablepositions;
    private ArrayList<AbstractInstance> instances;
    private boolean manualClassifierActive = false;
    private ArrayList<Integer> selectedIds = new ArrayList();
    private JScrollPane imagesScrollPane;
    private AnySelectionTable imagesTable;
    private boolean fromImage = false;
    private String oldScalarName;
    private JPanel buttonPanel;
    private JPanel classButtonsPanel;
    private JButton classifyButton;
    private JButton closeButton;
    private JPanel dataPanel;
    private JTable instancesListTable;
    private JScrollPane jScrollPane1;
    private JPanel manualClassPanel;
    private JButton setAllButTheseButton;
    private JButton setAllButton;
    private JPanel subButtonsPanel;
    private JButton updateButton;
    private JSplitPane windowsSplitPane;

    private SimpleTreeMultipleImageView(JFrame parent) {
        super(parent);
        this.viewer = (SimpleTreeFrame)parent;
        this.initComponents();
        this.imagesScrollPane = new JScrollPane();
        this.imagesTable = new AnySelectionTable();
        this.imagesScrollPane.setBorder(BorderFactory.createTitledBorder("Images"));
        this.imagesScrollPane.setMinimumSize(new Dimension(800, 600));
        this.imagesScrollPane.setPreferredSize(new Dimension(800, 600));
        this.imagesTable.setCellSelectionEnabled(true);
        this.imagesTable.setIntercellSpacing(new Dimension(2, 2));
        this.imagesTable.setSelectionMode(2);
        this.imagesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleTreeMultipleImageView.this.imagesTableMouseClicked(evt);
            }
        });
        this.imagesTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SimpleTreeMultipleImageView.this.imagesTableMouseMoved(evt);
            }
        });
        this.imagesTable.getTableSelectionModel().addTableSelectionListener(new MyTableSelectionListener());
        this.imagesScrollPane.setViewportView(this.imagesTable);
        this.dataPanel.add((Component)this.imagesScrollPane, "Center");
        this.imagesModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return ImageIcon.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.imagesModel.addColumn("Images");
        this.imagesModel.addColumn("Images");
        this.imagesModel.addColumn("Images");
        this.imagesModel.addColumn("Images");
        this.imagesTable.setModel(this.imagesModel);
        this.imagesTable.setAutoResizeMode(4);
        this.imagesTable.setRowHeight(200);
        this.tablepositions = new ArrayList();
        this.pack();
    }

    private void initComponents() {
        this.windowsSplitPane = new JSplitPane();
        this.dataPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.subButtonsPanel = new JPanel();
        this.closeButton = new JButton();
        this.classifyButton = new JButton();
        this.manualClassPanel = new JPanel();
        this.classButtonsPanel = new JPanel();
        this.updateButton = new JButton();
        this.setAllButton = new JButton();
        this.setAllButTheseButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.instancesListTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Images Multiple View");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                SimpleTreeMultipleImageView.this.formWindowClosed(evt);
            }
        });
        this.windowsSplitPane.setBorder(null);
        this.windowsSplitPane.setOrientation(0);
        this.windowsSplitPane.setOneTouchExpandable(true);
        this.dataPanel.setMinimumSize(new Dimension(800, 50));
        this.dataPanel.setOpaque(false);
        this.dataPanel.setLayout(new BorderLayout());
        this.windowsSplitPane.setLeftComponent(this.dataPanel);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.subButtonsPanel.setPreferredSize(new Dimension(100, 33));
        this.subButtonsPanel.setRequestFocusEnabled(false);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeMultipleImageView.this.closeButtonActionPerformed(evt);
            }
        });
        this.subButtonsPanel.add(this.closeButton);
        this.classifyButton.setText("Manual Classifier");
        this.classifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeMultipleImageView.this.classifyButtonActionPerformed(evt);
            }
        });
        this.subButtonsPanel.add(this.classifyButton);
        this.buttonPanel.add(this.subButtonsPanel);
        this.manualClassPanel.setBorder(BorderFactory.createTitledBorder("Manual Classifier"));
        this.manualClassPanel.setMinimumSize(new Dimension(800, 13));
        this.manualClassPanel.setPreferredSize(new Dimension(800, 13));
        this.manualClassPanel.setLayout(new GridBagLayout());
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeMultipleImageView.this.updateButtonActionPerformed(evt);
            }
        });
        this.classButtonsPanel.add(this.updateButton);
        this.setAllButton.setText("Set All");
        this.setAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeMultipleImageView.this.setAllButtonActionPerformed(evt);
            }
        });
        this.classButtonsPanel.add(this.setAllButton);
        this.setAllButTheseButton.setText("Set All but These");
        this.setAllButTheseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeMultipleImageView.this.setAllButTheseButtonActionPerformed(evt);
            }
        });
        this.classButtonsPanel.add(this.setAllButTheseButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.manualClassPanel.add((Component)this.classButtonsPanel, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(700, 20));
        this.jScrollPane1.setPreferredSize(new Dimension(800, 64));
        this.instancesListTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.instancesListTable.setMinimumSize(new Dimension(300, 364));
        this.instancesListTable.setPreferredSize(new Dimension(300, 364));
        this.instancesListTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimpleTreeMultipleImageView.this.instancesListTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.instancesListTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.manualClassPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonPanel.add(this.manualClassPanel);
        this.windowsSplitPane.setRightComponent(this.buttonPanel);
        this.getContentPane().add((Component)this.windowsSplitPane, "Center");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.formWindowClosed(null);
    }

    private void formWindowClosed(WindowEvent evt) {
        instance = null;
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        HashMap<Integer, String> labels = ((SimpleTreeModel)this.viewer.getModel()).getLabels();
        if (labels != null && !labels.isEmpty()) {
            if (this.manualClassifierActive) {
                Scalar pseudoScalar = null;
                if (this.oldScalarName != null && !this.oldScalarName.isEmpty()) {
                    pseudoScalar = this.oldScalarName.contains("pseudoClass_") ? ((SimpleTreeModel)this.viewer.getModel()).getScalarByName(this.oldScalarName) : ((SimpleTreeModel)this.viewer.getModel()).getScalarByName("pseudoClass_" + this.oldScalarName);
                }
                if (pseudoScalar == null) {
                    return;
                }
                for (AbstractInstance ai : ((SimpleTreeModel)this.viewer.getModel()).getValidInstances()) {
                    SimpleTreeInstance lins = (SimpleTreeInstance)ai;
                    int j = this.tableModel.getNumRowGiveName(((SimpleTreeModel)this.viewer.getModel()).getLabels().get(lins.getId()));
                    if (j == -1) continue;
                    float f = Float.valueOf(this.tableModel.getValueAt(j, 3).toString().trim()).floatValue();
                    lins.setScalarValue(pseudoScalar, f);
                }
                this.viewer.updateScalars(pseudoScalar);
                ((SimpleTreeModel)this.viewer.getModel()).updateTablePScalar(this.tableModel);
                ((SimpleTreeModel)this.viewer.getModel()).getTablePScalar();
                this.unmarkImages();
                this.markSelectedImages(this.selectedIds);
            }
        } else {
            JOptionPane.showMessageDialog(this.viewer.getContainer(), "No source data set found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
        }
    }

    private void classifyButtonActionPerformed(ActionEvent evt) {
        HashMap<Integer, String> labels = ((SimpleTreeModel)this.viewer.getModel()).getLabels();
        if (labels != null && !labels.isEmpty()) {
            Float oldClassValue = null;
            Float scalarvalue = null;
            this.manualClassPanel.setVisible(true);
            PseudoClass pc = new PseudoClass();
            ArrayList<PseudoClass> pseudoClassList = new ArrayList<PseudoClass>();
            Scalar oldScalar = ((SimpleTreeModel)this.viewer.getModel()).getSelectedScalar();
            if (oldScalar == null) {
                oldScalar = ((SimpleTreeModel)this.viewer.getModel()).getScalars().get(0);
            }
            this.oldScalarName = oldScalar.getName();
            Scalar pseudoClass = null;
            pseudoClass = this.oldScalarName.contains("pseudoClass_") ? oldScalar : ((SimpleTreeModel)this.viewer.getModel()).getScalarByName("pseudoClass_" + this.oldScalarName);
            if (pseudoClass == null) {
                pseudoClass = ((SimpleTreeModel)this.viewer.getModel()).addScalar("pseudoClass_" + this.oldScalarName);
                for (int k = 0; k < ((SimpleTreeModel)this.viewer.getModel()).getInstances().size(); ++k) {
                    SimpleTreeInstance pi = (SimpleTreeInstance)((SimpleTreeModel)this.viewer.getModel()).getInstances().get(k);
                    oldClassValue = Float.valueOf(pi.getScalarValue(oldScalar));
                    pi.setScalarValue(pseudoClass, oldClassValue.floatValue());
                }
            }
            ((SimpleTreeModel)this.viewer.getModel()).updateTablePScalar(pseudoClass);
            this.tablePScalar = ((SimpleTreeModel)this.viewer.getModel()).getTablePScalar();
            if (this.instances != null) {
                for (int t = 0; t < this.instances.size(); ++t) {
                    String filename = labels.get(((SimpleTreeInstance)this.instances.get(t)).getId());
                    if (filename == null) continue;
                    int pos = this.tablePScalar.getNumRowGiveName(filename);
                    String nFilename = (String)this.tablePScalar.getValueAt(pos, 1);
                    scalarvalue = Float.valueOf(Float.valueOf(this.tablePScalar.getValueAt(pos, 3).toString().trim()).floatValue());
                    pc = new PseudoClass(this.instances.get(t).getId(), filename, nFilename, true, scalarvalue);
                    pseudoClassList.add(pc);
                    TablesMapping tp = this.getTablesMappingById(this.instances.get(t).getId());
                    if (tp == null) continue;
                    tp.instanceTableRow = pseudoClassList.indexOf(pc);
                }
            }
            try {
                this.tableModel = new TablePScalar(pseudoClassList, this.tablePScalar);
                this.instancesListTable.setModel(this.tableModel);
                this.instancesListTable.getColumn("+").setWidth(0);
                this.instancesListTable.getColumn("+").setMinWidth(0);
                this.instancesListTable.getColumn("+").setMaxWidth(0);
                this.instancesListTable.getColumn("Color").setWidth(0);
                this.instancesListTable.getColumn("Color").setMinWidth(0);
                this.instancesListTable.getColumn("Color").setMaxWidth(0);
                this.instancesListTable.getColumn("ID").setMinWidth(0);
                this.instancesListTable.getColumn("ID").setMaxWidth(0);
                if (this.tableModel.getRowCount() < 6) {
                    this.instancesListTable.setSize(new Dimension(800, 16 * this.tableModel.getRowCount()));
                    this.instancesListTable.setMinimumSize(new Dimension(800, 16 * this.tableModel.getRowCount()));
                    this.instancesListTable.setPreferredSize(new Dimension(800, 16 * this.tableModel.getRowCount()));
                } else {
                    this.instancesListTable.setSize(new Dimension(800, 96));
                    this.instancesListTable.setMinimumSize(new Dimension(800, 96));
                    this.instancesListTable.setPreferredSize(new Dimension(800, 96));
                }
                this.instancesListTable.getSelectionModel().addListSelectionListener(new InstancesRowListener());
                int classScrollPaneHeight = 16 * (this.tableModel.getRowCount() + 1);
                this.instancesListTable.setSize(new Dimension(800, classScrollPaneHeight));
                this.instancesListTable.setPreferredSize(new Dimension(800, classScrollPaneHeight));
                if (this.tableModel.getRowCount() < 6) {
                    this.jScrollPane1.setSize(new Dimension(800, classScrollPaneHeight));
                    this.jScrollPane1.setMinimumSize(new Dimension(800, classScrollPaneHeight));
                    this.jScrollPane1.setPreferredSize(new Dimension(800, classScrollPaneHeight));
                } else {
                    this.jScrollPane1.setSize(new Dimension(800, 96));
                    this.jScrollPane1.setMinimumSize(new Dimension(800, 96));
                    this.jScrollPane1.setPreferredSize(new Dimension(800, 96));
                }
                int winHeight = this.getHeight();
                if (winHeight < 700) {
                    this.setSize(this.getWidth(), this.getHeight() + classScrollPaneHeight + 40);
                } else {
                    this.windowsSplitPane.setDividerLocation(370);
                }
                this.manualClassifierActive = true;
            }
            catch (Exception ex) {
                System.err.println("Caught: " + ex);
            }
        } else {
            JOptionPane.showMessageDialog(this.viewer.getContainer(), "No source data set found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
        }
    }

    private void setAllButtonActionPerformed(ActionEvent evt) {
        if (this.manualClassifierActive) {
            Scalar pseudoScalar = null;
            if (this.oldScalarName != null && !this.oldScalarName.isEmpty()) {
                pseudoScalar = this.oldScalarName.contains("pseudoClass_") ? ((SimpleTreeModel)this.viewer.getModel()).getScalarByName(this.oldScalarName) : ((SimpleTreeModel)this.viewer.getModel()).getScalarByName("pseudoClass_" + this.oldScalarName);
            }
            if (pseudoScalar == null) {
                return;
            }
            String className = JOptionPane.showInputDialog(null, "Class name:", "", 1);
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                this.tableModel.setValueAt(className, i, 1);
            }
            try {
                this.instancesListTable.setModel(this.tableModel);
            }
            catch (Exception ex) {
                System.err.println("Caught: " + ex);
            }
            this.instancesListTable.updateUI();
            this.updateButtonActionPerformed(evt);
        }
    }

    private void setAllButTheseButtonActionPerformed(ActionEvent evt) {
        HashMap<Integer, String> labels = ((SimpleTreeModel)this.viewer.getModel()).getLabels();
        if (labels != null && !labels.isEmpty()) {
            if (this.manualClassifierActive) {
                Scalar pseudoScalar = null;
                if (this.oldScalarName != null && !this.oldScalarName.isEmpty()) {
                    pseudoScalar = this.oldScalarName.contains("pseudoClass_") ? ((SimpleTreeModel)this.viewer.getModel()).getScalarByName(this.oldScalarName) : ((SimpleTreeModel)this.viewer.getModel()).getScalarByName("pseudoClass_" + this.oldScalarName);
                }
                if (pseudoScalar == null) {
                    return;
                }
                String className = JOptionPane.showInputDialog(null, "Class name:", "", 1);
                for (AbstractInstance ai : ((SimpleTreeModel)this.viewer.getModel()).getValidInstances()) {
                    SimpleTreeInstance lins = (SimpleTreeInstance)ai;
                    int i = this.tableModel.getNumRowGiveName(labels.get(lins.getId()));
                    if (i != -1) continue;
                    PseudoClass pc = new PseudoClass();
                    pc = new PseudoClass(0, labels.get(lins.getId()), className, true, Float.valueOf(lins.getScalarValue(pseudoScalar)));
                    this.tableModel.addFila(pc);
                }
                this.updateButtonActionPerformed(evt);
                this.tableModel.fill();
                this.instancesListTable.setModel(this.tableModel);
                this.instancesListTable.updateUI();
            }
        } else {
            JOptionPane.showMessageDialog(this.viewer.getContainer(), "No source data set found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
        }
    }

    private void instancesListTableMouseClicked(MouseEvent evt) {
        if (this.manualClassifierActive && evt.getButton() == 3) {
            if (this.instancesListTable.getSelectedRows().length > 0) {
                Scalar pseudoScalar = null;
                if (this.oldScalarName != null && !this.oldScalarName.isEmpty()) {
                    pseudoScalar = this.oldScalarName.contains("pseudoClass_") ? ((SimpleTreeModel)this.viewer.getModel()).getScalarByName(this.oldScalarName) : ((SimpleTreeModel)this.viewer.getModel()).getScalarByName("pseudoClass_" + this.oldScalarName);
                }
                if (pseudoScalar == null) {
                    return;
                }
                String className = JOptionPane.showInputDialog(null, "Class name:", "", 1);
                for (int i = 0; i < this.instancesListTable.getSelectedRows().length; ++i) {
                    this.tableModel.setValueAt(className, this.instancesListTable.getSelectedRows()[i], 1);
                }
                try {
                    this.instancesListTable.setModel(this.tableModel);
                }
                catch (Exception ex) {
                    System.err.println("Caught: " + ex);
                }
                this.instancesListTable.updateUI();
                this.updateButtonActionPerformed(null);
            } else {
                JOptionPane.showMessageDialog(null, "No instances selected.");
            }
        }
    }

    private void imagesTableMouseMoved(MouseEvent evt) {
        TablesMapping tp;
        int column;
        Point p = evt.getPoint();
        int row = this.imagesTable.rowAtPoint(p);
        ImageIcon ic = (ImageIcon)this.imagesTable.getValueAt(row, column = this.imagesTable.columnAtPoint(p));
        if (ic != null && (tp = this.getTablesMappingByImc(ic)) != null) {
            this.imagesTable.setToolTipText(tp.label);
        }
    }

    private void imagesTableMouseClicked(MouseEvent evt) {
        this.instancesListTableMouseClicked(evt);
    }

    public static SimpleTreeMultipleImageView getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new SimpleTreeMultipleImageView(parent);
        }
        return instance;
    }

    public void display(ImageCollection im, ArrayList<AbstractInstance> instances) {
        LabelContent labels = (LabelContent)this.viewer.getModel().getContent(AbstractContent.Type.LABEL);
        if (labels != null && !labels.isEmpty()) {
            int i;
            int Size = 0;
            this.instances = instances;
            if (instances != null) {
                int rowcount = this.imagesModel.getRowCount();
                for (i = rowcount - 1; i >= 0; --i) {
                    this.imagesModel.removeRow(i);
                }
                for (i = 0; i < instances.size(); i += 4) {
                    for (int j = 0; j < 4 && i + j < instances.size(); ++j) {
                        AbstractInstance ins = instances.get(i + j);
                        if (!((SimpleTreeInstance)ins).isValid() || labels.get(ins.getId()).isEmpty()) continue;
                        ++Size;
                    }
                }
                for (i = 0; i < Size; i += 4) {
                    Object[] images = new Object[4];
                    for (int j = 0; j < 4 && i + j < Size; ++j) {
                        AbstractInstance ins = instances.get(i + j);
                        if (!((SimpleTreeInstance)ins).isValid() || labels.get(ins.getId()).isEmpty()) continue;
                        try {
                            Image img = im.getImage(labels.get(ins.getId()));
                            if (img == null) continue;
                            BufferedImage bi = new BufferedImage(img.getWidth(null) + 4, img.getHeight(null) + 4, 2);
                            Graphics2D g = bi.createGraphics();
                            g.drawImage(img, 2, 2, null);
                            g.setColor(((SimpleTreeInstance)ins).getColor());
                            g.setStroke(new BasicStroke(3.0f));
                            g.drawRect(1, 1, img.getWidth(null) + 1, img.getHeight(null) + 1);
                            g.dispose();
                            ImageIcon imc = new ImageIcon(bi.getScaledInstance(190, 190, 0));
                            this.tablepositions.add(new TablesMapping(ins.getId(), labels.get(((SimpleTreeInstance)ins).getId()), i / 4, j, img, imc));
                            images[j] = imc;
                            continue;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.imagesModel.addRow(images);
                }
            }
            int sizeImage = 200;
            i = this.imagesModel.getRowCount();
            Dimension d = new Dimension(this.dataPanel.getWidth(), i * sizeImage + 50);
            if (i * sizeImage + 50 <= 650) {
                this.setSize(this.getWidth(), i * sizeImage + 140);
                this.dataPanel.setSize(d);
                this.imagesScrollPane.setSize(d);
                this.dataPanel.setPreferredSize(d);
                this.imagesScrollPane.setPreferredSize(d);
                this.windowsSplitPane.setDividerLocation(i * sizeImage + 50);
            } else {
                this.setSize(this.getWidth(), 740);
                this.windowsSplitPane.setDividerLocation(650);
            }
            this.setLocationRelativeTo(this.getParent());
            this.manualClassPanel.setVisible(false);
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.viewer.getContainer(), "No source data set found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
        }
    }

    private void insertImg(Object[] images, int noRow, int row, int col) {
        AbstractMatrix matrix = this.viewer.getMatrix();
        SimpleTreeModel model = (SimpleTreeModel)this.viewer.getModel();
        ImageContent imageContent = (ImageContent)this.viewer.getModel().getContent(AbstractContent.Type.IMAGE);
        SupertreeFile stFile = model.getSupertreeFile();
        int id = -1;
        String label = "";
        float klass = -1.0f;
        if (matrix != null) {
            id = matrix.getRow(noRow).getId();
            klass = matrix.getRow(noRow).getKlass();
            label = matrix.getLabel(noRow);
        } else if (model.getSupertreeFile() != null) {
            try {
                id = noRow;
                klass = stFile.Scalar.getById(id);
                label = stFile.Label.getById(id);
            }
            catch (IOException ex) {
                Logger.getLogger(SimpleTreeMultipleImageView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Image img = null;
        if (imageContent != null) {
            img = imageContent.get(id);
        }
        if (img != null) {
            ColorTable colortable = model.getColorTable();
            BufferedImage bi = new BufferedImage(img.getWidth(null) + 4, img.getHeight(null) + 4, 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(img, 2, 2, null);
            g.setStroke(new BasicStroke(3.0f));
            g.drawRect(1, 1, img.getWidth(null) + 1, img.getHeight(null) + 1);
            g.dispose();
            ImageIcon imc = new ImageIcon(bi.getScaledInstance(190, 190, 0));
            this.tablepositions.add(new TablesMapping(noRow, label, row, col, img, imc));
            images[col] = imc;
        } else {
            Logger.getLogger(SimpleTreeMultipleImageView.class.getName()).log(Level.WARNING, "Image not found for id " + id + " on row " + row);
        }
    }

    public void display(ArrayList<AbstractInstance> instances) {
        SimpleTreeFrame frame = this.viewer;
        SimpleTreeModel model = (SimpleTreeModel)frame.getModel();
        if (frame.getMatrix() == null && model.getSupertreeFile() == null || instances == null) {
            JOptionPane.showMessageDialog(this.viewer.getContainer(), "No source data found! Connect it to correspondent viewer component on the pipeline", "Error", 0, null);
            return;
        }
        this.instances = instances;
        int rowcount = this.imagesModel.getRowCount();
        for (int i = rowcount - 1; i >= 0; --i) {
            this.imagesModel.removeRow(i);
        }
        int countRow = 0;
        int countCol = 0;
        Object[] images = new Object[4];
        for (AbstractInstance inst : instances) {
            if (!((SimpleTreeInstance)inst).isValid()) continue;
            if (inst instanceof ClusterSimpleTreeInstance) {
                ClusterSimpleTreeInstance clusterInstance = (ClusterSimpleTreeInstance)inst;
                List<Object> medoids = new ArrayList();
                if (clusterInstance.getCluster() != null) {
                    medoids = clusterInstance.getCluster().getMedoidList();
                } else if (clusterInstance.getTreeCluster() != null) {
                    medoids = clusterInstance.getTreeCluster().getMedoidList();
                }
                int i = 0;
                for (i = 0; i < medoids.size(); ++i) {
                    if (countCol == 4) {
                        countCol = 0;
                        ++countRow;
                        this.imagesModel.addRow(images);
                        images = new Object[4];
                    }
                    this.insertImg(images, (Integer)medoids.get(i), countRow, countCol);
                    ++countCol;
                }
                continue;
            }
            if (countCol == 4) {
                countCol = 0;
                ++countRow;
                this.imagesModel.addRow(images);
                images = new Object[4];
            }
            if (frame.getMatrix() != null) {
                int matrixRow = frame.searchMatrixByID(frame.getMatrix(), ((SimpleTreeInstance)inst).getId());
                this.insertImg(images, matrixRow, countRow, countCol);
            } else if (model.getSupertreeFile() != null) {
                this.insertImg(images, inst.getId(), countRow, countCol);
            }
            ++countCol;
        }
        if (images[0] != null) {
            this.imagesModel.addRow(images);
        }
        int sizeImage = 200;
        int i = this.imagesModel.getRowCount();
        Dimension d = new Dimension(this.dataPanel.getWidth(), i * sizeImage + 50);
        if (i * sizeImage + 50 <= 650) {
            this.setSize(this.getWidth(), i * sizeImage + 140);
            this.dataPanel.setSize(d);
            this.imagesScrollPane.setSize(d);
            this.dataPanel.setPreferredSize(d);
            this.imagesScrollPane.setPreferredSize(d);
            this.windowsSplitPane.setDividerLocation(i * sizeImage + 50);
        } else {
            this.setSize(this.getWidth(), 740);
            this.windowsSplitPane.setDividerLocation(650);
        }
        this.setLocationRelativeTo(this.getParent());
        this.manualClassPanel.setVisible(false);
        this.setVisible(true);
    }

    public TablesMapping getTablesMappingById(int id) {
        for (int i = 0; i < this.tablepositions.size(); ++i) {
            if (this.tablepositions.get((int)i).id != id) continue;
            return this.tablepositions.get(i);
        }
        return null;
    }

    public TablesMapping getTablesMappingByImc(ImageIcon imc) {
        for (int i = 0; i < this.tablepositions.size(); ++i) {
            if (!this.tablepositions.get((int)i).imc.equals(imc)) continue;
            return this.tablepositions.get(i);
        }
        return null;
    }

    public SimpleTreeInstance getInstanceById(int id) {
        if (this.instances != null) {
            for (int i = 0; i < this.instances.size(); ++i) {
                if (this.instances.get(i).getId() != id) continue;
                return (SimpleTreeInstance)this.instances.get(i);
            }
        }
        return null;
    }

    public void unmarkImages() {
        for (int i = 0; i < this.tablepositions.size(); ++i) {
            TablesMapping tp = this.tablepositions.get(i);
            if (tp == null) continue;
            SimpleTreeInstance ins = this.getInstanceById(tp.id);
            BufferedImage bi = new BufferedImage(tp.im.getWidth(null) + 4, tp.im.getHeight(null) + 4, 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(tp.im, 2, 2, null);
            if (ins != null) {
                g.setColor(ins.getColor());
            }
            g.setStroke(new BasicStroke(3.0f));
            g.drawRect(1, 1, tp.im.getWidth(null) + 1, tp.im.getHeight(null) + 1);
            g.dispose();
            ImageIcon imc = new ImageIcon(bi.getScaledInstance(190, 190, 0));
            this.imagesTable.setValueAt(imc, tp.imageTableRow, tp.imageTableCol);
            tp.imc = imc;
        }
    }

    public void markSelectedImages(ArrayList<Integer> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            TablesMapping tp = this.getTablesMappingById(ids.get(i));
            if (tp == null) continue;
            SimpleTreeInstance ins = this.getInstanceById(tp.id);
            BufferedImage bi = new BufferedImage(tp.im.getWidth(null) + 4, tp.im.getHeight(null) + 4, 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(tp.im, 2, 2, null);
            if (ins != null) {
                g.setColor(ins.getColor());
            }
            g.setStroke(new BasicStroke(3.0f));
            g.drawRect(1, 1, tp.im.getWidth(null) + 1, tp.im.getHeight(null) + 1);
            g.setColor(Color.RED);
            g.setStroke(new BasicStroke(3.0f));
            g.fillRect(0, bi.getHeight() - 8, bi.getWidth(), 8);
            g.dispose();
            ImageIcon imi = new ImageIcon(bi.getScaledInstance(190, 190, 0));
            this.imagesTable.setValueAt(imi, tp.imageTableRow, tp.imageTableCol);
            tp.imc = imi;
        }
    }

    public void markSelectedInstances(ArrayList<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.fromImage = true;
        this.instancesListTable.clearSelection();
        TablesMapping tp = null;
        int minIndex = Integer.MAX_VALUE;
        int maxIndex = Integer.MIN_VALUE;
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < ids.size(); ++i) {
            tp = this.getTablesMappingById(ids.get(i));
            if (tp == null) continue;
            if (tp.instanceTableRow < minIndex) {
                minIndex = tp.instanceTableRow;
            }
            if (tp.instanceTableRow > maxIndex) {
                maxIndex = tp.instanceTableRow;
            }
            rows.add(tp.instanceTableRow);
        }
        this.instancesListTable.changeSelection(minIndex, 0, false, false);
        this.instancesListTable.changeSelection(maxIndex, 0, false, true);
        for (int j = minIndex; j <= maxIndex; ++j) {
            if (rows.contains(j)) continue;
            this.instancesListTable.changeSelection(j, 0, true, false);
        }
        this.fromImage = false;
    }

    private class MyTableSelectionListener
    implements TableSelectionListener {
        private MyTableSelectionListener() {
        }

        @Override
        public void valueChanged(TableSelectionEvent e) {
            TableSelectionModel tsm = (TableSelectionModel)e.getSource();
            ArrayList<Point> selectedCells = tsm.getSelectedCells();
            if (selectedCells != null) {
                ArrayList ims = new ArrayList();
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (int i = 0; i < selectedCells.size(); ++i) {
                    TablesMapping tp;
                    ImageIcon imi = (ImageIcon)SimpleTreeMultipleImageView.this.imagesTable.getValueAt(selectedCells.get((int)i).x, selectedCells.get((int)i).y);
                    if (imi == null || (tp = SimpleTreeMultipleImageView.this.getTablesMappingByImc(imi)) == null) continue;
                    ids.add(tp.id);
                }
                SimpleTreeMultipleImageView.this.unmarkImages();
                SimpleTreeMultipleImageView.this.markSelectedImages(ids);
                SimpleTreeMultipleImageView.this.markSelectedInstances(ids);
            }
        }
    }

    private class InstancesRowListener
    implements ListSelectionListener {
        private InstancesRowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!SimpleTreeMultipleImageView.this.fromImage) {
                SimpleTreeMultipleImageView.this.selectedIds.clear();
                SimpleTreeMultipleImageView.this.imagesTable.clearSelection();
                for (int i = 0; i < SimpleTreeMultipleImageView.this.instancesListTable.getSelectedRows().length; ++i) {
                    if (SimpleTreeMultipleImageView.this.selectedIds.contains((Integer)SimpleTreeMultipleImageView.this.instancesListTable.getValueAt(SimpleTreeMultipleImageView.this.instancesListTable.getSelectedRows()[i], 4))) continue;
                    SimpleTreeMultipleImageView.this.selectedIds.add((Integer)SimpleTreeMultipleImageView.this.instancesListTable.getValueAt(SimpleTreeMultipleImageView.this.instancesListTable.getSelectedRows()[i], 4));
                }
                SimpleTreeMultipleImageView.this.unmarkImages();
                SimpleTreeMultipleImageView.this.markSelectedImages(SimpleTreeMultipleImageView.this.selectedIds);
            }
        }
    }

    class TablesMapping {
        public int id;
        public String label;
        public Image im;
        public ImageIcon imc;
        public int imageTableRow;
        public int imageTableCol;
        public int instanceTableRow = -1;

        public TablesMapping(int id, String label, int row, int col, Image im, ImageIcon imc) {
            this.id = id;
            this.label = label;
            this.imageTableRow = row;
            this.imageTableCol = col;
            this.im = im;
            this.imc = imc;
        }
    }
}

