/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.AbstractInstance;
import simpletree.model.Edge;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.AbstractFilter;
import simpletree.util.filter.DATAFilter;
import simpletree.util.filter.DMATFilter;

public class SimpleTreeSaveClassDialog
extends JDialog {
    private String matrixFileName;
    private String dmatFilename;
    private String layoutDmatFilename;
    private String layoutMatrixFilename;
    private String source;
    private int choice;
    private Scalar scalar;
    private static SimpleTreeSaveClassDialog instance;
    private SimpleTreeModel model;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JButton distanceMatrixButton;
    private JRadioButton distanceMatrixRadioButton;
    private JTextField distanceMatrixTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JCheckBox outputDmatCheckBox;
    private JTextField outputDmatTextField;
    private JCheckBox outputLayoutDmatCheckBox;
    private JTextField outputLayoutDmatTextField;
    private JCheckBox outputLayoutMatrixCheckBox;
    private JTextField outputLayoutMatrixTextField;
    private JPanel outputPanel;
    private JCheckBox outputPointsCheckBox;
    private JTextField outputPointsTextField;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    protected JButton saveButton;
    private JPanel sourcePanel;
    private JCheckBox useWeightCheckBox;

    public SimpleTreeSaveClassDialog(JFrame parent) {
        super(parent);
        this.initComponents();
        this.setModal(true);
        this.choice = 0;
        if (this.source != null && this.source.endsWith(".dmat")) {
            this.choice = 1;
        }
        this.dissimilarityComboBox.removeAllItems();
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.dissimilarityComboBox.setSelectedItem((Object)DissimilarityFactory.DissimilarityType.EUCLIDEAN);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.sourcePanel = new JPanel();
        this.pointsRadioButton = new JRadioButton();
        this.distanceMatrixRadioButton = new JRadioButton();
        this.distanceMatrixTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.distanceMatrixButton = new JButton();
        this.outputPanel = new JPanel();
        this.outputPointsCheckBox = new JCheckBox();
        this.outputDmatCheckBox = new JCheckBox();
        this.outputPointsTextField = new JTextField();
        this.outputDmatTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.outputLayoutDmatCheckBox = new JCheckBox();
        this.outputLayoutDmatTextField = new JTextField();
        this.useWeightCheckBox = new JCheckBox();
        this.outputLayoutMatrixCheckBox = new JCheckBox();
        this.outputLayoutMatrixTextField = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.dissimilarityPanel, gridBagConstraints);
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.saveButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Source File"));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.buttonGroup1.add(this.distanceMatrixRadioButton);
        this.distanceMatrixRadioButton.setText("Distance File");
        this.distanceMatrixRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.distanceMatrixRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.distanceMatrixRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixRadioButton, gridBagConstraints);
        this.distanceMatrixTextField.setColumns(35);
        this.distanceMatrixTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.sourcePanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.sourcePanel, gridBagConstraints);
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output File"));
        this.outputPanel.setLayout(new GridBagLayout());
        this.outputPointsCheckBox.setLabel("Points File");
        this.outputPointsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.outputPointsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.outputPanel.add((Component)this.outputPointsCheckBox, gridBagConstraints);
        this.outputDmatCheckBox.setLabel("Distance File");
        this.outputDmatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.outputDmatCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.outputPanel.add((Component)this.outputDmatCheckBox, gridBagConstraints);
        this.outputPointsTextField.setEnabled(false);
        this.outputPointsTextField.setPreferredSize(new Dimension(465, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.outputPanel.add((Component)this.outputPointsTextField, gridBagConstraints);
        this.outputDmatTextField.setEnabled(false);
        this.outputDmatTextField.setPreferredSize(new Dimension(465, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.outputPanel.add((Component)this.outputDmatTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.outputPanel, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Layout Distance Matrix"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.outputLayoutDmatCheckBox.setText("Layout Distance File");
        this.outputLayoutDmatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.outputLayoutDmatCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.outputLayoutDmatCheckBox, gridBagConstraints);
        this.outputLayoutDmatTextField.setEnabled(false);
        this.outputLayoutDmatTextField.setPreferredSize(new Dimension(430, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.outputLayoutDmatTextField, gridBagConstraints);
        this.useWeightCheckBox.setText("Use Edges Weights");
        this.useWeightCheckBox.setHorizontalAlignment(4);
        this.useWeightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.useWeightCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.useWeightCheckBox, gridBagConstraints);
        this.outputLayoutMatrixCheckBox.setText("Layout Points File");
        this.outputLayoutMatrixCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleTreeSaveClassDialog.this.outputLayoutMatrixCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.outputLayoutMatrixCheckBox, gridBagConstraints);
        this.outputLayoutMatrixTextField.setEnabled(false);
        this.outputLayoutMatrixTextField.setPreferredSize(new Dimension(430, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.outputLayoutMatrixTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private ProjectionInstance getInstanceByID(int id) {
        ArrayList<AbstractInstance> modelInstances = this.model.getInstances();
        if (modelInstances != null && !modelInstances.isEmpty()) {
            for (int i = 0; i < modelInstances.size(); ++i) {
                if (modelInstances.get(i).getId() != id) continue;
                return (ProjectionInstance)modelInstances.get(i);
            }
        }
        return null;
    }

    private void setClasses(AbstractMatrix matrix, Scalar scalar) {
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            AbstractVector inst = matrix.getRow(i);
            if (inst == null) continue;
            ProjectionInstance ins = this.getInstanceByID(inst.getId());
            if (ins != null) {
                inst.setKlass(ins.getScalarValue(scalar));
                continue;
            }
            matrix.removeRow(i);
            --i;
        }
    }

    private void setClasses(DistanceMatrix dmat, Scalar scalar) {
        float[] cdata = dmat.getClassData();
        ArrayList<Integer> ids = dmat.getIds();
        for (int i = 0; i < dmat.getIds().size(); ++i) {
            ProjectionInstance ins = this.getInstanceByID(ids.get(i));
            if (ins != null) {
                cdata[i] = ins.getScalarValue(scalar);
                continue;
            }
            dmat.removeElement(dmat.getIds().get(i));
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveButtonActionPerformed(ActionEvent evt) {
        String result = "";
        String sourceFilename = "";
        if (this.outputPointsCheckBox.isSelected()) {
            if (this.outputPointsTextField.getText().trim().isEmpty()) {
                JOptionPane.showMessageDialog(null, "The output data matrix must be informed!");
                return;
            }
            this.matrixFileName = this.outputPointsTextField.getText().trim();
        }
        if (this.outputDmatCheckBox.isSelected()) {
            if (this.outputDmatTextField.getText().trim().isEmpty()) {
                JOptionPane.showMessageDialog(null, "The output distance matrix must be informed!");
                return;
            }
            this.dmatFilename = this.outputDmatTextField.getText().trim();
        }
        if (this.outputLayoutMatrixCheckBox.isSelected()) {
            if (this.outputLayoutMatrixTextField.getText().trim().isEmpty()) {
                JOptionPane.showMessageDialog(null, "The output layout points matrix must be informed!");
                return;
            }
            this.layoutMatrixFilename = this.outputLayoutMatrixTextField.getText().trim();
        }
        if (this.outputLayoutDmatCheckBox.isSelected()) {
            if (this.outputLayoutDmatTextField.getText().trim().isEmpty()) {
                JOptionPane.showMessageDialog(null, "The output layout distance matrix must be informed!");
                return;
            }
            this.layoutDmatFilename = this.outputLayoutDmatTextField.getText().trim();
        }
        if (this.choice == 0) {
            sourceFilename = this.pointsTextField.getText();
        } else if (this.choice == 1) {
            sourceFilename = this.distanceMatrixTextField.getText();
        } else if (this.source != null && !this.source.isEmpty()) {
            sourceFilename = this.source;
        }
        if (sourceFilename.isEmpty()) {
            JOptionPane.showMessageDialog(null, "The original data source must be informed!");
            return;
        }
        try {
            switch (this.choice) {
                case 0: {
                    AbstractMatrix matrix = MatrixFactory.getInstance(sourceFilename);
                    if (matrix == null) break;
                    this.setClasses(matrix, this.scalar);
                    if (this.outputPointsCheckBox.isSelected()) {
                        matrix.save(this.matrixFileName);
                        result = result + "Attributes Matrix saved.\n";
                    }
                    if (!this.outputDmatCheckBox.isSelected()) break;
                    AbstractDissimilarity diss = DissimilarityFactory.getInstance((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
                    DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
                    if (dmat != null) {
                        dmat.save(this.dmatFilename);
                    }
                    result = result + "Distance Matrix saved.\n";
                    break;
                }
                case 1: {
                    DistanceMatrix dmat = new DistanceMatrix(sourceFilename);
                    if (dmat == null) break;
                    this.setClasses(dmat, this.scalar);
                    if (!this.outputDmatCheckBox.isSelected()) break;
                    dmat.save(this.dmatFilename);
                    result = result + "Distance Matrix saved.\n";
                }
            }
            AbstractMatrix layoutPoints = null;
            if (this.outputLayoutMatrixCheckBox.isSelected()) {
                layoutPoints = this.exportPoints(this.model.getInstances());
                this.setClasses(layoutPoints, this.scalar);
                layoutPoints.save(this.layoutMatrixFilename);
                result = result + "Layout Points Matrix saved.\n";
            }
            if (this.outputLayoutDmatCheckBox.isSelected()) {
                DistanceMatrix layoutDmat = this.createDistanceMatrix(this.model, this.useWeightCheckBox.isSelected());
                this.setClasses(layoutDmat, this.scalar);
                layoutDmat.save(this.layoutDmatFilename);
                result = result + "Layout Distance Matrix saved.\n";
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeSaveClassDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (!result.isEmpty()) {
                JOptionPane.showMessageDialog(null, result);
                this.setVisible(false);
            }
        }
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(false);
        this.distanceMatrixTextField.setEnabled(false);
        this.outputPointsCheckBox.setEnabled(true);
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.distanceMatrixTextField.setText("");
        this.dissimilarityComboBox.setEnabled(true);
        this.choice = 0;
    }

    private void distanceMatrixRadioButtonActionPerformed(ActionEvent evt) {
        this.distanceMatrixButton.setEnabled(true);
        this.distanceMatrixTextField.setEnabled(true);
        this.outputPointsCheckBox.setEnabled(false);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.dissimilarityComboBox.setEnabled(false);
        this.choice = 1;
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DATAFilter(), this.pointsTextField);
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        this.pushButton(new DMATFilter(), this.distanceMatrixTextField);
    }

    private void outputPointsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.outputPointsCheckBox.isSelected()) {
            int result;
            String directory = "";
            String filename = "";
            if (this.source != null && this.source.lastIndexOf("/") != -1) {
                directory = this.source.substring(0, this.source.lastIndexOf("/"));
                filename = this.source.substring(this.source.lastIndexOf("/") + 1);
                filename = filename.replace(".dmat", ".data");
            }
            if ((result = SaveDialog.showSaveDialog(new DATAFilter(), this, directory, filename)) == 0) {
                this.outputPointsTextField.setText(SaveDialog.getFilename());
                this.outputPointsTextField.setEnabled(true);
            } else {
                this.outputPointsCheckBox.setSelected(false);
            }
        } else {
            this.outputPointsTextField.setEnabled(false);
        }
    }

    private void outputDmatCheckBoxActionPerformed(ActionEvent evt) {
        if (this.outputDmatCheckBox.isSelected()) {
            int result;
            String directory = "";
            String filename = "";
            if (this.source != null && this.source.lastIndexOf("/") != -1) {
                directory = this.source.substring(0, this.source.lastIndexOf("/"));
                filename = this.source.substring(this.source.lastIndexOf("/") + 1);
                filename = filename.replace(".data", ".dmat");
            }
            if ((result = SaveDialog.showSaveDialog(new DMATFilter(), this, directory, filename)) == 0) {
                this.outputDmatTextField.setText(SaveDialog.getFilename());
                this.outputDmatTextField.setEnabled(true);
            } else {
                this.outputDmatTextField.setEnabled(false);
            }
        } else {
            this.outputDmatTextField.setEnabled(false);
        }
    }

    private void outputLayoutDmatCheckBoxActionPerformed(ActionEvent evt) {
        if (this.outputLayoutDmatCheckBox.isSelected()) {
            int result;
            String directory = "";
            String filename = "";
            if (this.source != null && this.source.lastIndexOf("/") != -1) {
                directory = this.source.substring(0, this.source.lastIndexOf("/"));
                filename = this.source.substring(this.source.lastIndexOf("/") + 1);
                filename = filename.replace(".data", ".dmat");
                filename = "Layout_" + filename;
            }
            if ((result = SaveDialog.showSaveDialog(new DMATFilter(), this, directory, filename)) == 0) {
                this.outputLayoutDmatTextField.setText(SaveDialog.getFilename());
                this.outputLayoutDmatTextField.setEnabled(true);
            } else {
                this.outputLayoutDmatCheckBox.setSelected(false);
            }
        } else {
            this.outputLayoutDmatTextField.setEnabled(false);
        }
    }

    private void useWeightCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void outputLayoutMatrixCheckBoxActionPerformed(ActionEvent evt) {
        if (this.outputLayoutMatrixCheckBox.isSelected()) {
            int result;
            String directory = "";
            String filename = "";
            if (this.source.lastIndexOf("/") != -1) {
                directory = this.source.substring(0, this.source.lastIndexOf("/"));
                filename = this.source.substring(this.source.lastIndexOf("/") + 1);
                filename = filename.replace(".dmat", ".data");
                filename = "Layout_" + filename;
            }
            if ((result = SaveDialog.showSaveDialog(new DATAFilter(), this, directory, filename)) == 0) {
                this.outputLayoutMatrixTextField.setText(SaveDialog.getFilename());
                this.outputLayoutMatrixTextField.setEnabled(true);
            } else {
                this.outputLayoutMatrixCheckBox.setSelected(false);
            }
        } else {
            this.outputLayoutMatrixTextField.setEnabled(false);
        }
    }

    private void pushButton(AbstractFilter filter, JTextField field) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, filter, this);
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                field.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SimpleTreeSaveClassDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SimpleTreeSaveClassDialog getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new SimpleTreeSaveClassDialog(parent);
        }
        return instance;
    }

    public void display(SimpleTreeModel model, String source, Scalar scalar) {
        this.model = model;
        this.source = source;
        this.scalar = scalar;
        this.dmatFilename = "";
        this.matrixFileName = "";
        this.outputPointsCheckBox.setSelected(false);
        this.outputPointsTextField.setText("");
        this.outputPointsTextField.setEnabled(false);
        this.outputDmatCheckBox.setSelected(false);
        this.outputDmatTextField.setText("");
        this.outputDmatTextField.setEnabled(false);
        if (source != null && !source.isEmpty()) {
            this.sourcePanel.setVisible(false);
            this.dissimilarityPanel.setVisible(false);
            if (this.choice == 0) {
                this.outputPointsCheckBox.setVisible(true);
                this.outputPointsTextField.setVisible(true);
            } else if (this.choice == 1) {
                this.outputPointsCheckBox.setVisible(false);
                this.outputPointsTextField.setVisible(false);
            }
        } else {
            this.sourcePanel.setVisible(true);
            this.dissimilarityPanel.setVisible(true);
            this.outputPointsCheckBox.setVisible(true);
            this.outputPointsTextField.setVisible(true);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private DistanceMatrix createDistanceMatrix(SimpleTreeModel model, boolean useWeights) {
        int k;
        DistanceMatrix dm = new DistanceMatrix();
        float[][] dmat = new float[model.getInstances().size()][model.getInstances().size()];
        for (int i = 0; i < dmat.length; ++i) {
            for (int j = 0; j < dmat[i].length; ++j) {
                dmat[i][j] = i == j ? 0.0f : Float.MAX_VALUE;
            }
        }
        ArrayList<Edge> edges = null;
        if (model.getSelectedConnectivity() != null) {
            edges = model.getSelectedConnectivity().getEdges();
        } else if (model.getConnectivities() != null && model.getConnectivities().size() > 1) {
            edges = model.getConnectivities().get(1).getEdges();
        }
        if (edges == null) {
            return null;
        }
        for (int k2 = 0; k2 < edges.size(); ++k2) {
            Edge ed = edges.get(k2);
            int x = model.getInstances().indexOf(model.getInstanceById(ed.getSource()));
            int y = model.getInstances().indexOf(model.getInstanceById(ed.getTarget()));
            if (useWeights) {
                float f = ed.getWeight();
                dmat[y][x] = f;
                dmat[x][y] = f;
                continue;
            }
            dmat[y][x] = 1.0f;
            dmat[x][y] = 1.0f;
        }
        int n = dmat.length;
        for (k = 0; k < n; ++k) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    float dd = dmat[i][k] + dmat[k][j];
                    if (!(dmat[i][j] > dd)) continue;
                    dmat[i][j] = dd;
                }
            }
        }
        k = -1;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList ndmat = new ArrayList();
        for (int i = 0; i < dmat.length; ++i) {
            if (!((SimpleTreeInstance)model.getInstances().get(i)).isValid()) continue;
            ids.add(model.getInstances().get(i).getId());
            ++k;
            ndmat.add(new ArrayList());
            for (int j = 0; j < dmat[i].length; ++j) {
                if (!((SimpleTreeInstance)model.getInstances().get(j)).isValid()) continue;
                ((ArrayList)ndmat.get(k)).add(Float.valueOf(dmat[i][j]));
            }
        }
        dm.setElementCount(ndmat.size());
        float maxDistance = Float.NEGATIVE_INFINITY;
        float minDistance = Float.POSITIVE_INFINITY;
        float[][] distmat = new float[ndmat.size() - 1][];
        for (int i = 0; i < ndmat.size() - 1; ++i) {
            distmat[i] = new float[i + 1];
            for (int j = 0; j < distmat[i].length; ++j) {
                float distance = ((Float)((ArrayList)ndmat.get(i + 1)).get(j)).floatValue();
                if (distance < minDistance) {
                    minDistance = distance;
                }
                if (distance > maxDistance) {
                    maxDistance = distance;
                }
                if (i + 1 == j) continue;
                if (i + 1 < j) {
                    distmat[j - 1][i + 1] = distance;
                    continue;
                }
                distmat[i + 1 - 1][j] = distance;
            }
        }
        dm.setMinDistance(minDistance);
        dm.setMaxDistance(maxDistance);
        dm.setDistmatrix(distmat);
        ArrayList<String> labels = new ArrayList<String>();
        float[] classdata = new float[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            SimpleTreeInstance gi = model.getInstanceById((Integer)ids.get(i));
            if (gi == null) continue;
            labels.add(model.getLabels().get(gi.getId()));
            classdata[i] = gi.getScalarValue(this.scalar);
        }
        dm.setClassData(classdata);
        dm.setIds(ids);
        dm.setLabels(labels);
        return dm;
    }

    protected AbstractMatrix exportPoints(ArrayList<AbstractInstance> instances) {
        DenseMatrix matrix = new DenseMatrix();
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < instances.size(); ++i) {
            float[] point = new float[]{((ProjectionInstance)instances.get(i)).getX(), ((ProjectionInstance)instances.get(i)).getY()};
            Integer id = ((ProjectionInstance)instances.get(i)).getId();
            labels.add(((ProjectionInstance)instances.get(i)).toString());
            ((AbstractMatrix)matrix).addRow(new DenseVector(point, id, 0.0f));
        }
        matrix.setLabels(labels);
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("x");
        attributes.add("y");
        matrix.setAttributes(attributes);
        return matrix;
    }
}

