/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import simpletree.io.cluster.TreeCluster;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.newick.NewickUtils;
import simpletree.util.SimpleTreeUtil;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.selection.AbstractSelection;

public class MultilevelCollapseSelection
extends AbstractSelection
implements Runnable {
    private SimpleTreeInstance subtreeRoot;
    private SimpleTreeFrame frame;

    public MultilevelCollapseSelection(ModelViewer viewer) {
        super(viewer);
        this.frame = (SimpleTreeFrame)viewer;
        this.subtreeRoot = null;
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (selinst == null || selinst.isEmpty()) {
            return;
        }
        int maxLevel = -1;
        for (AbstractInstance ai : selinst) {
            if (((SimpleTreeInstance)ai).level <= maxLevel) continue;
            maxLevel = ((SimpleTreeInstance)ai).level;
            this.subtreeRoot = (SimpleTreeInstance)ai;
        }
        int maxNodeId = -1;
        int clusterLevelHeight = 1;
        int parentCluster = 0;
        for (AbstractInstance ai : this.frame.getModel().getInstances()) {
            if (ai.getId() > maxNodeId) {
                maxNodeId = ai.getId();
            }
            if (!(ai instanceof ClusterSimpleTreeInstance)) continue;
            clusterLevelHeight = ((ClusterSimpleTreeInstance)ai).getTreeCluster().getLevelHeight();
            parentCluster = ((ClusterSimpleTreeInstance)ai).getTreeCluster().getParentId();
        }
        ++maxNodeId;
        SimpleTreeModel treeModel = (SimpleTreeModel)this.frame.getModel();
        SimpleTreeModel subtreeModel = treeModel.getSubtreeModel(this.subtreeRoot.getId());
        int numValidInstances = 0;
        for (AbstractInstance ai : subtreeModel.getInstances()) {
            if (!((SimpleTreeInstance)ai).isValid()) continue;
            ++numValidInstances;
        }
        if (numValidInstances <= 1) {
            return;
        }
        TreeCluster subtreeCluster = this.clusterFromTree(subtreeModel, maxNodeId);
        subtreeCluster.setLevelHeight(clusterLevelHeight);
        subtreeCluster.setParentId(parentCluster);
        SimpleTreeUtil.memoryTreeClusters.put(subtreeCluster.getId(), subtreeCluster);
        ClusterSimpleTreeInstance clusterInstance = new ClusterSimpleTreeInstance(treeModel, maxNodeId, true);
        clusterInstance.manuallyCreated = true;
        clusterInstance.setTreeCluster(subtreeCluster);
        clusterInstance.setParent(this.subtreeRoot.getParent());
        SimpleTreeInstance parent = treeModel.getInstanceById(this.subtreeRoot.getParent());
        clusterInstance.setX(this.subtreeRoot.getX());
        clusterInstance.setY(this.subtreeRoot.getY());
        for (int i = 0; i < parent.getNumChildren(); ++i) {
            if (parent.getChildrenId(i) != this.subtreeRoot.getId()) continue;
            parent.setChildrenId(i, clusterInstance.getId());
            break;
        }
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        ArrayList<Edge> edgesToAdd = new ArrayList<Edge>();
        for (Edge e : treeModel.getConnectivityByName("Neighbor-Joinning").getEdges()) {
            if (e.getSource() == this.subtreeRoot.getId()) {
                edgesToRemove.add(e);
                edgesToAdd.add(new Edge(clusterInstance.getId(), e.getTarget(), e.getWeight()));
                continue;
            }
            if (e.getTarget() != this.subtreeRoot.getId()) continue;
            edgesToRemove.add(e);
            edgesToAdd.add(new Edge(e.getSource(), clusterInstance.getId(), e.getWeight()));
        }
        treeModel.getConnectivityByName("Neighbor-Joinning").getEdges().removeAll(edgesToRemove);
        treeModel.getConnectivityByName("Neighbor-Joinning").getEdges().addAll(edgesToAdd);
        treeModel.removeSubTree(this.subtreeRoot);
        subtreeModel.setSupertreeFile(treeModel.getSupertreeFile());
        this.frame.updateScalars(this.frame.getCurrentScalar());
        if (this.frame.treeVoronoi != null) {
            this.frame.createTreeVoronoi();
            treeModel.setChanged();
            treeModel.notifyObservers();
        }
    }

    private TreeCluster clusterFromTree(SimpleTreeModel stModel, int clusterId) {
        TreeCluster cluster = new TreeCluster(clusterId);
        for (AbstractInstance ai : stModel.getInstances()) {
            if (ai instanceof ClusterSimpleTreeInstance) {
                TreeCluster subcluster = ((ClusterSimpleTreeInstance)ai).getTreeCluster();
                cluster.getSubClusterList().add(subcluster);
                cluster.getMedoidList().add(subcluster.getMedoidList().get(0));
                cluster.setSize(cluster.getSize() + subcluster.getSize());
                continue;
            }
            if (!((SimpleTreeInstance)ai).isValid()) continue;
            cluster.getItemList().add(ai.getId());
            cluster.setSize(cluster.getSize() + 1);
        }
        cluster.setNewick(NewickUtils.toNewickString(stModel));
        return cluster;
    }

    @Override
    public ImageIcon getIcon() {
        URL ic = this.getClass().getResource("/resources/collapse16_2.png");
        if (ic == null) {
            ic = this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif");
        }
        return new ImageIcon(ic);
    }

    @Override
    public String toString() {
        return "Collapse Subtree";
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

