/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.interaction;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import simpletree.model.AbstractInstance;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.textprocessing.corpus.buffer.BufferCorpus;
import simpletree.textprocessing.processing.Stopword;
import simpletree.topic.EnglishStopwordsList;
import simpletree.topic.PExTopic;
import simpletree.topic.TopicOutline;
import simpletree.util.SimpleTreeUtil;
import simpletree.view.ModelViewer;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.interaction.TreeAbstractSelection;

public class TopicOutlineSelection
extends TreeAbstractSelection {
    public TopicOutlineSelection(ModelViewer viewer) {
        super(viewer);
    }

    @Override
    public void selected(ArrayList<AbstractInstance> selinst) {
        if (this.viewer.getModel() != null) {
            SimpleTreeModel stModel = (SimpleTreeModel)this.viewer.getModel();
            if (selinst.size() == 1) {
                selinst = TopicOutlineSelection.selectHierarchy((SimpleTreeInstance)selinst.get(0));
            }
            if (selinst.size() > 1) {
                TopicOutline outline = new TopicOutline();
                outline.setPadding(0.06);
                outline.setSamplingDistance(0.01);
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                ArrayList<Integer> nodeIds = new ArrayList<Integer>();
                for (AbstractInstance ai : selinst) {
                    SimpleTreeInstance stInst = (SimpleTreeInstance)ai;
                    points.add(new Point2D.Double(stInst.getX(), stInst.getY()));
                    nodeIds.add(stInst.getId());
                }
                points.addAll(this.sampleEdges(nodeIds));
                outline.compute(points, stModel.getSize());
                outline.pointsIds = nodeIds;
                try {
                    outline.terms = this.getTopic(stModel, selinst);
                }
                catch (IOException ex) {
                    Logger.getLogger(TopicOutlineSelection.class.getName()).log(Level.SEVERE, null, ex);
                }
                SimpleTreeFrame stFrame = (SimpleTreeFrame)this.viewer;
                stFrame.setOutlineTopic(outline);
                this.viewer.getModel().setChanged();
            }
        }
    }

    private Map<String, Float> getTopic(SimpleTreeModel stModel, ArrayList<AbstractInstance> selection) throws IOException {
        ArrayList<AbstractInstance> validInstances = new ArrayList<AbstractInstance>();
        ArrayList<Integer> validIds = new ArrayList<Integer>();
        for (AbstractInstance ai : selection) {
            if (!((SimpleTreeInstance)ai).isValid()) continue;
            validInstances.add(ai);
            validIds.add(ai.getId());
        }
        List<String> docs = null;
        if (!validInstances.isEmpty()) {
            docs = SimpleTreeUtil.getDocumentsFromInstances(stModel, validInstances);
        }
        BufferCorpus bcorpus = new BufferCorpus(docs, validIds, 1);
        Stopword stp = Stopword.getInstance();
        EnglishStopwordsList engStp = new EnglishStopwordsList();
        stp.changeStopwordList(engStp.getStopwords());
        Map<String, Float> terms = PExTopic.createTopic(stModel, validInstances, bcorpus);
        return terms;
    }

    private List<Point2D> sampleEdges(List<Integer> nodeIds) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        SimpleTreeModel stModel = (SimpleTreeModel)this.viewer.getModel();
        for (Edge e : stModel.getSelectedConnectivity().getEdges()) {
            if (!nodeIds.contains(e.getSource()) || !nodeIds.contains(e.getTarget())) continue;
            SimpleTreeInstance srcInst = stModel.getInstanceById(e.getSource());
            SimpleTreeInstance tgtInst = stModel.getInstanceById(e.getTarget());
            points.add(new Point2D.Float((srcInst.getX() + tgtInst.getX()) / 2.0f, (srcInst.getY() + tgtInst.getY()) / 2.0f));
        }
        return points;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/About16.gif"));
    }

    @Override
    public String toString() {
        return "On-demand Topic";
    }
}

