/*
 * Decompiled with CFR 0.152.
 */
package simpletree.view.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;

class IconWithArrow
implements Icon {
    private static final String ARROW_IMAGE_NAME = "/resources/arrow.png";
    private Icon orig;
    private Icon arrow = new ImageIcon(IconWithArrow.class.getResource("/resources/arrow.png"));
    private boolean paintRollOver;
    private static final int GAP = 6;

    public IconWithArrow(Icon orig, boolean paintRollOver) {
        if (orig == null) {
            throw new NullPointerException("The icon parameter cannot be null");
        }
        this.orig = orig;
        this.paintRollOver = paintRollOver;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int height = this.getIconHeight();
        this.orig.paintIcon(c, g, x, y + (height - this.orig.getIconHeight()) / 2);
        this.arrow.paintIcon(c, g, x + 6 + this.orig.getIconWidth(), y + (height - this.arrow.getIconHeight()) / 2);
        if (this.paintRollOver) {
            Color brighter = UIManager.getColor("controlHighlight");
            Color darker = UIManager.getColor("controlShadow");
            if (null == brighter || null == darker) {
                brighter = c.getBackground().brighter();
                darker = c.getBackground().darker();
            }
            if (null != brighter && null != darker) {
                g.setColor(brighter);
                g.drawLine(x + this.orig.getIconWidth() + 1, y, x + this.orig.getIconWidth() + 1, y + this.getIconHeight());
                g.setColor(darker);
                g.drawLine(x + this.orig.getIconWidth() + 2, y, x + this.orig.getIconWidth() + 2, y + this.getIconHeight());
            }
        }
    }

    public static Image icon2Image(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = image.getGraphics();
        icon.paintIcon(new JLabel(), g, 0, 0);
        g.dispose();
        return image;
    }

    @Override
    public int getIconWidth() {
        return this.orig.getIconWidth() + 6 + this.arrow.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.orig.getIconHeight(), this.arrow.getIconHeight());
    }

    public static int getArrowAreaWidth() {
        return 8;
    }
}

